/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.StatusMacroDao;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusMacroEntity;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusMacroDao
implements StatusMacroDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultStatusMacroDao.class);
    private final ActiveObjects ao;

    public DefaultStatusMacroDao(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public StatusMacroEntity createStatusMacroEntity(int statusSetId, long statusId, boolean outline, @Nullable Long confluencePageId, boolean labelled, String labelPrefix) {
        log.debug("statusSetId = {}, statusId = {}, outline = {}, confluencePageId = {}, labelled = {}, labelPrefix = {}.", new Object[]{statusSetId, statusId, outline, confluencePageId, labelled, labelPrefix});
        return (StatusMacroEntity)this.ao.create(StatusMacroEntity.class, new DBParam[]{new DBParam("CATEGORY", (Object)statusSetId), new DBParam("STATUS", (Object)statusId), new DBParam("OUTLINE", (Object)outline), new DBParam("PAGE_ID", (Object)confluencePageId), new DBParam("LABELLED", (Object)labelled), new DBParam("PREFIX", (Object)labelPrefix)});
    }

    @Override
    public StatusMacroEntity createDraftStatusMacroEntity(int statusSetId, long statusId, boolean outline, @Nullable Long confluencePageId, boolean labelled, String labelPrefix, int draftId) {
        log.debug("statusSetId = {}, statusId = {}, outline = {}, confluencePageId = {}, labelled = {}, labelPrefix = {}, draftId = {}.", new Object[]{statusSetId, statusId, outline, confluencePageId, labelled, labelPrefix, draftId});
        return (StatusMacroEntity)this.ao.create(StatusMacroEntity.class, new DBParam[]{new DBParam("CATEGORY", (Object)statusSetId), new DBParam("STATUS", (Object)statusId), new DBParam("OUTLINE", (Object)outline), new DBParam("PAGE_ID", (Object)confluencePageId), new DBParam("LABELLED", (Object)labelled), new DBParam("PREFIX", (Object)labelPrefix), new DBParam("DRAFT_ID", (Object)draftId)});
    }

    @Override
    public Optional<StatusMacroEntity> getStatusMacroEntity(int statusMacroId) {
        Query query = Query.select().where(String.format("%s = ?", "ID"), new Object[]{statusMacroId}).limit(1);
        return Stream.of((StatusMacroEntity[])this.ao.find(StatusMacroEntity.class, query)).findFirst();
    }

    @Override
    public Optional<StatusMacroEntity> getStatusMacroEntity(int statusMacroId, long confluencePageId) {
        String whereClause = String.format("%s = ? AND %s = ?", "ID", "PAGE_ID");
        Query query = Query.select().where(whereClause, new Object[]{statusMacroId, confluencePageId}).limit(1);
        return Stream.of((StatusMacroEntity[])this.ao.find(StatusMacroEntity.class, query)).findFirst();
    }

    @Override
    public Optional<StatusMacroEntity> getStatusMacroEntityByDraftId(int draftId) {
        Query query = Query.select().where("DRAFT_ID = ?", new Object[]{draftId}).limit(1);
        return Stream.of((StatusMacroEntity[])this.ao.find(StatusMacroEntity.class, query)).findFirst();
    }

    @Override
    public Collection<StatusMacroEntity> getStatusMacroEntitiesForPageWithLabel(long confluencePageId) {
        LinkedList<StatusMacroEntity> statusMacroEntities = new LinkedList<StatusMacroEntity>();
        Query query = Query.select((String)"ID, CATEGORY, PREFIX, LABELLED, STATUS").where("PAGE_ID = ? AND LABELLED = ?", new Object[]{confluencePageId, Boolean.TRUE});
        this.ao.stream(StatusMacroEntity.class, query, statusMacroEntities::add);
        return statusMacroEntities;
    }

    @Override
    public Collection<StatusMacroEntity> getStatusMacroEntitiesWhereConfluencePageIdIsNotNull(int statusSetId, int offset, int limit) {
        LinkedList<StatusMacroEntity> statusMacroEntities = new LinkedList<StatusMacroEntity>();
        Query query = Query.select((String)StatusMacroEntity.ALL).where("CATEGORY = ? AND PAGE_ID IS NOT NULL", new Object[]{statusSetId}).offset(offset).limit(limit).order("ID DESC");
        this.ao.stream(StatusMacroEntity.class, query, statusMacroEntities::add);
        return statusMacroEntities;
    }

    @Override
    public Collection<StatusMacroEntity> getStatusMacroEntitiesWhereConfluencePageIdIsNotNull(int statusSetId, int statusId, int offset, int limit) {
        LinkedList<StatusMacroEntity> statusMacroEntities = new LinkedList<StatusMacroEntity>();
        Query query = Query.select((String)StatusMacroEntity.ALL).where("CATEGORY = ? AND STATUS = ? AND PAGE_ID IS NOT NULL", new Object[]{statusSetId, statusId}).offset(offset).limit(limit).order("ID DESC");
        this.ao.stream(StatusMacroEntity.class, query, statusMacroEntities::add);
        return statusMacroEntities;
    }
}

