/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.StatusMacroChangesDao;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusMacroChangeEntity;
import com.stiltsoft.confluence.handy.macros.util.AOUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusMacroChangesDao
implements StatusMacroChangesDao {
    private final ActiveObjects ao;

    public DefaultStatusMacroChangesDao(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public Optional<StatusMacroChangeEntity> getLastStatusMacroChangeEntity(int statusMacroId) {
        Query query = Query.select().where("MACRO_ID = ?", new Object[]{statusMacroId}).limit(1).order("DATE DESC");
        return Stream.of((StatusMacroChangeEntity[])this.ao.find(StatusMacroChangeEntity.class, query)).findFirst();
    }

    @Override
    public List<StatusMacroChangeEntity> getLastFifteenStatusMacroChangeEntities(int statusMacroId) {
        Query query = Query.select().where("MACRO_ID = ?", new Object[]{statusMacroId}).limit(15).order("DATE DESC");
        return Arrays.asList((StatusMacroChangeEntity[])this.ao.find(StatusMacroChangeEntity.class, query));
    }

    @Override
    public void createStatusMacroChangeEntity(int statusMacroId, int oldStatusSetId, long oldStatusId, @Nullable Boolean oldOutline, @Nullable Integer newStatusSetId, @Nullable Long newStatusId, @Nullable Boolean newOutline, String confluenceUserKey, long timestamp) {
        this.ao.create(StatusMacroChangeEntity.class, new DBParam[]{new DBParam("MACRO_ID", (Object)statusMacroId), new DBParam("OLD_CATEGORY", (Object)oldStatusSetId), new DBParam("OLD_STATUS", (Object)oldStatusId), new DBParam("OLD_OUTLINE", (Object)oldOutline), new DBParam("NEW_CATEGORY", (Object)newStatusSetId), new DBParam("NEW_STATUS", (Object)newStatusId), new DBParam("NEW_OUTLINE", (Object)newOutline), new DBParam("USER_KEY", (Object)confluenceUserKey), new DBParam("DATE", (Object)timestamp)});
    }

    @Override
    public void deleteStatusMacroChangeEntity(int statusMacroChangeId) {
        this.ao.deleteWithSQL(StatusMacroChangeEntity.class, "ID = ?", new Object[]{statusMacroChangeId});
    }

    @Override
    public void updateStatusMacroId(List<Integer> statusMacroChangeIds, int statusMacroId) {
        if (statusMacroChangeIds.isEmpty()) {
            return;
        }
        String placeholder = AOUtil.getPlaceholderWithQuestionMarks(statusMacroChangeIds);
        String clause = String.format("%s IN (%s)", "ID", placeholder);
        Query query = Query.select().from(StatusMacroChangeEntity.class).where(clause, statusMacroChangeIds.toArray()).order("ID ASC");
        Arrays.stream((StatusMacroChangeEntity[])this.ao.find(StatusMacroChangeEntity.class, query)).forEach(historyEntity -> {
            historyEntity.setStatusMacroId(statusMacroId);
            historyEntity.save();
        });
    }
}

