/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.StatusDao;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusEntity;
import com.stiltsoft.confluence.handy.macros.util.AOUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusDao
implements StatusDao {
    private final ActiveObjects ao;

    public DefaultStatusDao(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public Optional<StatusEntity> getStatusEntity(int statusId) {
        return Optional.ofNullable((StatusEntity)this.ao.get(StatusEntity.class, (Object)statusId));
    }

    @Override
    public List<StatusEntity> getStatusEntitiesBySetId(int statusSetId) {
        Query query = Query.select().where(String.format("%s = ?", "STATUS_SET_ID"), new Object[]{statusSetId}).order(String.format("%s ASC", "PRIORITY"));
        return Arrays.asList((StatusEntity[])this.ao.find(StatusEntity.class, query));
    }

    @Override
    public StatusEntity createStatusEntity(int statusSetId, String name, String backgroundColor, String textColor, int priority) {
        return (StatusEntity)this.ao.create(StatusEntity.class, new DBParam[]{new DBParam("STATUS_SET_ID", (Object)statusSetId), new DBParam("NAME", (Object)name), new DBParam("BG_COLOR", (Object)backgroundColor), new DBParam("TEXT_COLOR", (Object)textColor), new DBParam("PRIORITY", (Object)priority)});
    }

    @Override
    public void removeStatusEntity(int statusId) {
        this.ao.deleteWithSQL(StatusEntity.class, "ID = ?", new Object[]{statusId});
    }

    @Override
    public Optional<StatusEntity> getAndUpdateStatusEntity(int statusId, String name, String backgroundColor, String textColor) {
        return this.getStatusEntity(statusId).map(statusEntity -> {
            statusEntity.setName(name);
            statusEntity.setBackgroundColor(backgroundColor);
            statusEntity.setTextColor(textColor);
            statusEntity.save();
            return statusEntity;
        });
    }

    @Override
    public void sortStatusEntities(int statusSetId, List<Integer> orderedStatusIds) {
        this.getStatusEntityByIdsAndStatusSetId(statusSetId, orderedStatusIds).forEach(statusEntity -> {
            int priority = orderedStatusIds.indexOf(statusEntity.getID());
            statusEntity.setPriority(priority);
            statusEntity.save();
        });
    }

    @Override
    public int countStatusesBySetId(int statusSetId) {
        Query query = Query.select().where(String.format("%s = ?", "STATUS_SET_ID"), new Object[]{statusSetId});
        return this.ao.count(StatusEntity.class, query);
    }

    @Override
    public Optional<StatusEntity> getFirstAvailableStatusEntityFromSets(List<Integer> statusSetIds) {
        String placeholder = AOUtil.getPlaceholderWithQuestionMarks(statusSetIds);
        String clause = String.format("%s IN (%s)", "STATUS_SET_ID", placeholder);
        Query query = Query.select().from(StatusEntity.class).where(clause, statusSetIds.toArray()).order(String.format("%s ASC", "PRIORITY")).limit(1);
        return Stream.of((StatusEntity[])this.ao.find(StatusEntity.class, query)).findFirst();
    }

    @Override
    public void removeStatusEntitiesBySetId(int statusSetId) {
        this.ao.deleteWithSQL(StatusEntity.class, "STATUS_SET_ID = ?", new Object[]{statusSetId});
    }

    private List<StatusEntity> getStatusEntityByIdsAndStatusSetId(int statusSetId, Collection<Integer> statusIds) {
        String placeholder = AOUtil.getPlaceholderWithQuestionMarks(statusIds);
        String whereClause = String.format("ID IN (%s) AND %s = ?", placeholder, "STATUS_SET_ID");
        ArrayList<Integer> whereParams = new ArrayList<Integer>(statusIds);
        whereParams.add(statusSetId);
        Query query = Query.select().from(StatusEntity.class).where(whereClause, whereParams.toArray());
        return Arrays.asList((StatusEntity[])this.ao.find(StatusEntity.class, query));
    }
}

