/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class StatusMacroUpdateCacheManager {
    private final Cache<Long, List<Map<Integer, String>>> cache;
    public static final int MACRO_ID = 0;
    public static final int STATUS_NAME = 1;
    public static final int USER_KEY = 2;

    public StatusMacroUpdateCacheManager(CacheManager cacheManager) {
        this.cache = cacheManager.getCache("Handy Macro Lazy Update", null, new CacheSettingsBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maxEntries(10000).build());
    }

    public void add(long pageId, int macroId, String statusName) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        HashMap<Integer, String> change = new HashMap<Integer, String>();
        change.put(0, String.valueOf(macroId));
        change.put(1, statusName);
        change.put(2, user.getKey().getStringValue());
        List<HashMap<Integer, String>> changes = this.cache.containsKey((Object)pageId) ? (List)this.cache.get((Object)pageId) : new ArrayList<HashMap<Integer, String>>();
        changes.add(change);
        this.cache.put((Object)pageId, changes);
    }

    public void remove(long pageId, Map<Integer, String> change) {
        if (this.cache.containsKey((Object)pageId)) {
            List changes = (List)this.cache.get((Object)pageId);
            changes.remove(change);
            if (changes.isEmpty()) {
                this.cache.remove((Object)pageId);
            } else {
                this.cache.put((Object)pageId, (Object)changes);
            }
        }
    }

    public Collection<Long> getKeys() {
        return this.cache.getKeys();
    }

    public List<Map<Integer, String>> get(Long pageId) {
        return (List)this.cache.get((Object)pageId);
    }

    public boolean contains(long pageId) {
        return this.cache.containsKey((Object)pageId);
    }
}

