/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class PageReindexationCacheManager {
    private static final String KEY = "pages";
    private final Cache<String, Set<Long>> cache;

    public PageReindexationCacheManager(CacheManager cacheManager) {
        this.cache = cacheManager.getCache(this.getClass().getName(), null, new CacheSettingsBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build());
    }

    public void add(long id) {
        HashSet<Long> ids = (HashSet<Long>)this.cache.get((Object)KEY);
        if (ids == null) {
            ids = new HashSet<Long>();
        }
        ids.add(id);
        this.cache.put((Object)KEY, ids);
    }

    public void remove(Set<Long> idsToRemove) {
        Set ids = (Set)this.cache.get((Object)KEY);
        if (ids != null) {
            ids.removeAll(idsToRemove);
            this.cache.put((Object)KEY, (Object)ids);
        }
    }

    public void remove(long id) {
        Set ids = (Set)this.cache.get((Object)KEY);
        if (ids != null) {
            ids.remove(id);
            this.cache.put((Object)KEY, (Object)ids);
        }
    }

    public Set<Long> get() {
        return (Set)this.cache.get((Object)KEY);
    }
}

