/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status;

import com.stiltsoft.confluence.handy.macros.macro.status.StatusesService;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusDto;
import com.stiltsoft.confluence.handy.macros.macro.status.upgrade.dao.OldNewStatusIdMapDao;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.text.html.StyleSheet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StatusMacroImagePlaceholderGenerator
extends HttpServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatusMacroImagePlaceholderGenerator.class);
    private final StatusesService statusesService;
    private final OldNewStatusIdMapDao oldNewStatusIdMapDao;

    public StatusMacroImagePlaceholderGenerator(StatusesService statusesService, OldNewStatusIdMapDao oldNewStatusIdMapDao) {
        this.statusesService = statusesService;
        this.oldNewStatusIdMapDao = oldNewStatusIdMapDao;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("status") != null) {
            int statusMacroId = this.getStatusMacroId(req);
            Optional<StatusDto> statusOptional = this.statusesService.getStatusFromCacheOrDB(statusMacroId);
            if (!statusOptional.isPresent()) {
                this.drawUnknownStatusAsImageIntoResponse(resp);
                this.logStatusMacroParameters(req);
                return;
            }
            StatusDto status = statusOptional.get();
            boolean outline = Boolean.parseBoolean(req.getParameter("outline"));
            int width = Integer.parseInt(req.getParameter("width"));
            this.drawStatusAsImageIntoResponse(status, outline, width, resp);
        } else if (req.getParameter("unknown") != null) {
            this.drawUnknownStatusAsImageIntoResponse(resp);
        } else {
            String name = req.getParameter("name");
            String backgroundColor = req.getParameter("backgroundColor");
            String textColor = req.getParameter("textColor");
            int width = Integer.parseInt(req.getParameter("width"));
            this.drawStatusAsImageIntoResponse(name, backgroundColor, textColor, false, 30, width, 14, resp);
        }
    }

    private int getStatusMacroId(HttpServletRequest req) {
        long status = Long.parseLong(req.getParameter("status"));
        return status > 1328040000000L ? this.oldNewStatusIdMapDao.getNewStatusId(status) : (int)status;
    }

    private void logStatusMacroParameters(HttpServletRequest req) {
        String status = req.getParameter("status");
        int statusMacroId = this.getStatusMacroId(req);
        boolean outline = Boolean.parseBoolean(req.getParameter("outline"));
        int width = Integer.parseInt(req.getParameter("width"));
        log.error("Cannot find and render status macro with parameters: status = {}, statusMacroId = {}, outline = {}, width = {}.", new Object[]{status, statusMacroId, outline, width});
    }

    private void drawUnknownStatusAsImageIntoResponse(HttpServletResponse resp) throws IOException {
        this.drawStatusAsImageIntoResponse(StatusDto.UNKNOWN_STATUS, false, 100, resp);
    }

    private void drawStatusAsImageIntoResponse(StatusDto statusDto, boolean outline, int width, HttpServletResponse resp) throws IOException {
        this.drawStatusAsImageIntoResponse(statusDto.getName().toUpperCase(), statusDto.getBackgroundColor(), statusDto.getTextColorWithOutline(outline), outline, 18, width, 11, resp);
    }

    private void drawStatusAsImageIntoResponse(String title, String bgColor, String textColor, boolean outline, int height, int width, int fontSize, HttpServletResponse resp) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setComposite(AlphaComposite.Clear);
        graphics.fillRect(0, 0, width, height);
        graphics.setComposite(AlphaComposite.Src);
        StyleSheet styleSheet = new StyleSheet();
        graphics.setColor(styleSheet.stringToColor(bgColor));
        graphics.fillRoundRect(0, 0, width, height, 7, 7);
        if (outline) {
            graphics.setColor(Color.white);
            graphics.fillRoundRect(1, 1, width - 2, height - 2, 4, 4);
        }
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font font = new Font("SansSerif", 1, fontSize);
        graphics.setFont(font);
        graphics.setColor(styleSheet.stringToColor(textColor));
        int txtWidth = graphics.getFontMetrics().stringWidth(title);
        int txtHeight = graphics.getFontMetrics().getHeight();
        int imgWidth = bufferedImage.getWidth();
        int imgHeight = bufferedImage.getHeight();
        int xBuffer = 12;
        int eWidth = graphics.getFontMetrics().stringWidth("...");
        if (txtWidth + xBuffer > imgWidth) {
            String newText = "";
            int pos = 0;
            while (graphics.getFontMetrics().stringWidth(newText) + eWidth + xBuffer <= imgWidth) {
                newText = newText + title.charAt(pos);
                ++pos;
            }
            title = newText + "...";
        }
        int yPos = imgHeight / 2 + txtHeight / 2 - graphics.getFontMetrics().getDescent();
        int xPos = imgWidth / 2 - graphics.getFontMetrics().stringWidth(title) / 2;
        graphics.drawString(title, xPos, yPos);
        resp.setContentType("image/png");
        ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)resp.getOutputStream());
    }
}

