/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status;

import com.atlassian.confluence.content.render.image.ImageDimensions;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroService;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusesService;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusMacroDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusSetDto;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import com.stiltsoft.confluence.handy.macros.util.log.TickCollector;
import com.stiltsoft.confluence.handy.macros.util.log.Ticks;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusMacro
implements Macro,
EditorImagePlaceholder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatusMacro.class);
    private final StatusesService statusesService;
    private final LicenseManager licenseManager;
    private final StatusMacroService statusMacroService;
    private final VelocityHelperService velocityHelperService;
    private final HandyPermissionService handyPermissionService;

    public StatusMacro(StatusesService statusesService, LicenseManager licenseManager, StatusMacroService statusMacroService, VelocityHelperService velocityHelperService, HandyPermissionService handyPermissionService) {
        this.statusesService = statusesService;
        this.licenseManager = licenseManager;
        this.statusMacroService = statusMacroService;
        this.velocityHelperService = velocityHelperService;
        this.handyPermissionService = handyPermissionService;
    }

    public String execute(Map<String, String> params, String body, ConversionContext context) {
        try {
            return this.executeStatusMacro(params, context);
        }
        catch (Throwable t) {
            log.error("Can not render status macro.", t);
            return "Can not render status macro.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeStatusMacro(Map<String, String> params, ConversionContext context) {
        TickCollector collector = Ticks.start("macro.execute");
        Map ctx = MacroUtils.defaultVelocityContext();
        ContentEntityObject ceo = context.getEntity();
        ConfluenceUser currentConfluenceUser = AuthenticatedUserThreadLocal.get();
        log.debug("StatusMacro start params = {} .", params);
        log.debug("confluenceUser = {} .", (Object)currentConfluenceUser);
        boolean isPreview = "preview".equals(context.getOutputType());
        if (isPreview) {
            for (StackTraceElement traceElement : Thread.currentThread().getStackTrace()) {
                if (!traceElement.getClassName().endsWith("DetailsSummaryMacro") && !traceElement.getClassName().endsWith("DetailsSummaryBuilder")) continue;
                isPreview = false;
                break;
            }
        }
        collector.addTick("isPreview");
        Long pageId = ceo == null ? null : (ceo.isLatestVersion() ? Long.valueOf(ceo.getId()) : null);
        pageId = pageId == null || pageId == 0L ? null : pageId;
        int statusMacroId = Integer.parseInt(params.get("id").trim());
        log.debug("statusMacroId = {}, pageId = {}.", (Object)statusMacroId, (Object)pageId);
        Optional<StatusMacroDto> statusMacroOptional = this.statusMacroService.getCachedStatusMacroOrCreateDraftCopyAndCache(statusMacroId, pageId);
        if (!statusMacroOptional.isPresent()) {
            log.warn("Cannot get StatusMacro with parameters: statusMacroId={}, pageId={}, params={}", new Object[]{statusMacroId, pageId, params});
            return this.renderUnknownStatus(ctx, statusMacroId, pageId);
        }
        StatusMacroDto statusMacro = statusMacroOptional.get();
        log.debug("statusMacro = {}.", (Object)statusMacro);
        int statusId = Math.toIntExact(statusMacro.getStatusId());
        Optional<StatusDto> statusOptional = this.statusesService.getStatusFromCacheOrDB(statusId);
        if (!statusOptional.isPresent()) {
            log.warn("Cannot get Status for statusId={}, macroId={}, pageId={}, params={}", new Object[]{statusMacro.getStatusId(), statusMacroId, pageId, params});
            return this.renderUnknownStatus(ctx, statusMacroId, pageId);
        }
        StatusDto status = statusOptional.get();
        log.debug("status = {}.", (Object)status);
        collector.addTick("statusesService");
        ctx.put("licensed", this.licenseManager.isActive());
        ctx.put("status", status);
        ctx.put("outline", statusMacro.isOutline());
        ctx.put("macroId", statusMacroId);
        ctx.put("pageId", statusMacro.getConfluencePageIdOrNegativeValue());
        ctx.put("email", "email".equals(context.getOutputDeviceType()) || "email".equals(context.getOutputType()));
        ctx.put("export", StatusMacro.isExportOutputType(context));
        log.debug("ctx filled.");
        collector.addTick("baseContext");
        ctx.put("editable", context.getEntity() != null && !isPreview && this.handyPermissionService.hasEntityEditPermission((User)currentConfluenceUser, context.getEntity()));
        collector.addTick("permission");
        Optional<StatusSetDto> statusSetOptional = this.statusesService.getStatusSetFromCacheOrDB(status.getStatusSetId());
        if (statusSetOptional.isPresent()) {
            StatusSetDto statusSet = statusSetOptional.get();
            ctx.put("view", statusSet.getViewType());
            ctx.put("width", statusSet.getWidth());
        }
        collector.addTick("getSet");
        try {
            String string = this.velocityHelperService.getRenderedTemplate("vm/status/status-macro.vm", ctx);
            return string;
        }
        finally {
            collector.addTick("render");
            Ticks.log(log, collector);
            log.debug("StatusMacro end params = {} .", params);
        }
    }

    private String renderUnknownStatus(Map<String, Object> ctx, int statusMacroId, Long confluencePageId) {
        ctx.put("licensed", this.licenseManager.isActive());
        ctx.put("status", StatusDto.UNKNOWN_STATUS);
        ctx.put("outline", false);
        ctx.put("macroId", statusMacroId);
        ctx.put("pageId", Optional.ofNullable(confluencePageId).orElse(0L));
        ctx.put("editable", false);
        return this.velocityHelperService.getRenderedTemplate("vm/status/status-macro.vm", ctx);
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> map, ConversionContext context) {
        int macroId = Integer.parseInt(map.get("id").trim());
        ContentEntityObject ceo = context.getEntity();
        Long pageId = ceo == null ? null : (ceo.isLatestVersion() ? Long.valueOf(ceo.getId()) : null);
        return this.statusMacroService.getCachedStatusMacroOrFindWithMapping(macroId, pageId).map(statusMacro -> {
            int width = this.statusesService.getCachedStatusSetWidthOrDefault(statusMacro.getStatusSetId());
            return this.getStatusImagePlaceholder((StatusMacroDto)statusMacro, width);
        }).orElseGet(this::getUnknownStatusImagePlaceholder);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    private ImagePlaceholder getUnknownStatusImagePlaceholder() {
        ImageDimensions imageDimensions = new ImageDimensions(100, 18);
        String url = "/plugins/servlet/status-handy/placeholder?unknown=true";
        return new DefaultImagePlaceholder(url, false, imageDimensions);
    }

    private ImagePlaceholder getStatusImagePlaceholder(StatusMacroDto statusMacro, int width) {
        ImageDimensions imageDimensions = new ImageDimensions(width, 18);
        String url = "/plugins/servlet/status-handy/placeholder?set=" + statusMacro.getStatusSetId() + "&outline=" + statusMacro.isOutline() + "&status=" + statusMacro.getStatusId() + "&width=" + width;
        return new DefaultImagePlaceholder(url, false, imageDimensions);
    }

    private static boolean isExportOutputType(ConversionContext context) {
        if (context.hasProperty("tei-static")) {
            return false;
        }
        return "pdf".equals(context.getOutputType()) || "word".equals(context.getOutputType());
    }
}

