/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.reminder.mail;

import com.atlassian.confluence.core.DataSourceFactory;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.mail.template.MailNotificationQueueItem;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.user.User;
import java.util.Date;
import java.util.Map;
import javax.activation.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MailSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MailSender.class);
    private final MultiQueueTaskManager taskManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;
    private final FormatSettingsManager formatSettingsManager;
    private final DataSourceFactory dataSourceFactory;

    public MailSender(MultiQueueTaskManager taskManager, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, FormatSettingsManager formatSettingsManager, DataSourceFactory dataSourceFactory) {
        this.taskManager = taskManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.formatSettingsManager = formatSettingsManager;
        this.dataSourceFactory = dataSourceFactory;
    }

    public void send(AbstractPage page, ConfluenceUser user, ConfluenceUser author, String textHtml, int id) throws Exception {
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)user));
        if (textHtml.isEmpty()) {
            ConfluenceUserPreferences userPreferences = MailNotificationQueueItem.getUserAccessor().getConfluenceUserPreferences((User)user);
            DateFormatter dateFormatter = userPreferences.getDateFormatter(this.formatSettingsManager, this.localeManager);
            textHtml = i18n.getText("handy.reminder.mail.default-text", new Object[]{author.getFullName(), dateFormatter.format(new Date())});
        }
        DataSource avatar = this.dataSourceFactory.getAvatar((User)author);
        Map context = MacroUtils.defaultVelocityContext();
        context.put("author", author);
        context.put("avatar", avatar.getName());
        context.put("page", page);
        context.put("textHtml", textHtml);
        context.put("id", id);
        context.put("i18n", i18n);
        String subject = i18n.getText("handy.reminder.mail.subject") + page.getSpace().getDisplayTitle() + " > " + page.getTitle();
        log.debug("Handy MailSender -- author = {}, avatar = {}, pageID = {}, textHtml = {}, id = {}, subject = {}.", new Object[]{author.getKey(), avatar.getName(), page.getId(), textHtml, id, subject});
        PreRenderedMailNotificationQueueItem item = PreRenderedMailNotificationQueueItem.with((User)user, (String)"handy-reminder-mail-template.vm", (String)subject).andContext(context).andSender((User)author).andRelatedBodyPart(avatar).andReplyTo(author.getEmail()).andRelatedBodyPart(this.dataSourceFactory.getServletContainerResource("/images/icons/contenttypes/page_16.png", "email-view.png")).build();
        item.render();
        this.taskManager.addTask("mail", (Task)item);
        log.debug("Handy MailSender -- task added.");
    }
}

