/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.reminder.job;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.macro.reminder.ReminderMacroManager;
import com.stiltsoft.confluence.handy.macros.macro.reminder.ReminderMacroService;
import com.stiltsoft.confluence.handy.macros.macro.reminder.dto.ReminderMacroParams;
import com.stiltsoft.confluence.handy.macros.macro.reminder.mail.MailSender;
import com.stiltsoft.confluence.handy.macros.storage.StorageService;
import com.stiltsoft.confluence.handy.macros.tracking.dao.ReminderMacroUsageDao;
import com.stiltsoft.confluence.handy.macros.workbox.WorkboxManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ReminderJob
implements JobRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReminderJob.class);
    private static final int LIMIT = 500;
    private final MailSender mailSender;
    private final ReminderMacroManager reminderMacroManager;
    private final UserAccessor userAccessor;
    private final StorageService storageService;
    private final LicenseManager licenseManager;
    private final TransactionTemplate transactionTemplate;
    private final ContentEntityManager contentEntityManager;
    private final WorkboxManager workboxManager;
    private final WikiStyleRenderer wikiStyleRenderer;
    private final PageTemplateManager pageTemplateManager;
    private final ReminderMacroService reminderMacroService;
    private final ReminderMacroUsageDao reminderMacroUsageDao;

    public ReminderJob(MailSender mailSender, ReminderMacroManager reminderMacroManager, UserAccessor userAccessor, StorageService storageService, LicenseManager licenseManager, TransactionTemplate transactionTemplate, WorkboxManager workboxManager, WikiStyleRenderer wikiStyleRenderer, PageTemplateManager pageTemplateManager, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, ReminderMacroService reminderMacroService, ReminderMacroUsageDao reminderMacroUsageDao) {
        this.mailSender = mailSender;
        this.reminderMacroManager = reminderMacroManager;
        this.userAccessor = userAccessor;
        this.storageService = storageService;
        this.licenseManager = licenseManager;
        this.transactionTemplate = transactionTemplate;
        this.contentEntityManager = contentEntityManager;
        this.workboxManager = workboxManager;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.pageTemplateManager = pageTemplateManager;
        this.reminderMacroService = reminderMacroService;
        this.reminderMacroUsageDao = reminderMacroUsageDao;
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        List<ReminderMacroParams> reminders;
        log.debug("Handy Reminder Job started!");
        if (!this.licenseManager.isActive()) {
            return null;
        }
        log.debug("Handy Reminder - license active");
        do {
            reminders = this.reminderMacroManager.findActiveRemindersWithExpiredNextDate(500);
            reminders = this.reminderMacroService.updateNextDateAndGetForNotifying(reminders);
            log.debug("Handy Reminder -- reminderMacroEntities size = {}", (Object)reminders.size());
            for (ReminderMacroParams reminder : reminders) {
                log.debug("Handy Reminder -- entity, ID = {}, Page ID = {}", (Object)reminder.getId(), (Object)reminder.getPageId());
                this.transactionTemplate.execute(() -> this.remindUsers(reminder));
            }
        } while (reminders.size() == 500);
        return null;
    }

    private Object remindUsers(ReminderMacroParams reminderMacroParams) {
        try {
            ContentEntityObject ceo = this.contentEntityManager.getById(reminderMacroParams.getPageId().longValue());
            boolean isMacroPresent = this.checkIfMacroPresents(ceo, reminderMacroParams);
            AbstractPage page = this.getReminderMacroPage(ceo);
            int macroId = reminderMacroParams.getId();
            log.debug("Handy Reminder -- CEO == null {}.", (Object)(ceo == null ? 1 : 0));
            log.debug("Handy Reminder -- isMacroPresent = {}.", (Object)isMacroPresent);
            if (isMacroPresent) {
                Set<ConfluenceUser> users = this.getConfluenceUsers(reminderMacroParams);
                ConfluenceUser author = reminderMacroParams.getAuthor() == null ? null : this.userAccessor.getUserByKey(new UserKey(reminderMacroParams.getAuthor()));
                String textHtml = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new PageContext((ContentEntityObject)page), reminderMacroParams.getDescription());
                log.debug("Handy Reminder -- macro present.");
                log.debug("Handy Reminder -- all users size = {}", (Object)users.size());
                log.debug("Handy Reminder -- author = {}", (Object)author);
                log.debug("Handy Reminder -- textHtml = {}", (Object)textHtml);
                this.sendMailAndAddNotification(page, macroId, users, author, textHtml);
            } else {
                log.debug("Handy Reminder -- macro is not present.");
                if (ceo != null) {
                    log.debug("Handy Reminder -- ceo is NOT null, make a pause for entity");
                    this.reminderMacroManager.setReminderMacroPaused(macroId);
                } else {
                    log.debug("Handy Reminder -- ceo is null, delete reminder");
                    this.reminderMacroManager.deleteReminderMacro(macroId);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to send remind notification", (Throwable)e);
        }
        return null;
    }

    private boolean checkIfMacroPresents(ContentEntityObject ceo, ReminderMacroParams macroParams) {
        if (ceo != null && !ceo.isDeleted()) {
            return this.storageService.isReminderMacroPresentInContentStorage(ceo, macroParams.getId());
        }
        if (ceo == null && this.pageTemplateManager.getPageTemplate(macroParams.getPageId().longValue()) != null) {
            log.debug("Handy Reminder -- pageTemplateManager.getPageTemplate(entity.getPageId()) != null.");
        }
        return false;
    }

    private AbstractPage getReminderMacroPage(ContentEntityObject ceo) {
        if (ceo instanceof AbstractPage) {
            log.debug("Handy Reminder -- AbstractPage");
            return (AbstractPage)ceo;
        }
        if (ceo instanceof Comment) {
            log.debug("Handy Reminder -- Comment");
            Comment comment = (Comment)ceo;
            log.debug("Handy Reminder -- Comment -> Page");
            return (AbstractPage)comment.getContainer();
        }
        return null;
    }

    private Set<ConfluenceUser> getConfluenceUsers(ReminderMacroParams reminderMacroParams) {
        HashSet<ConfluenceUser> users = new HashSet<ConfluenceUser>();
        for (String group : reminderMacroParams.getGroups()) {
            for (ConfluenceUser user : this.userAccessor.getMembers(this.userAccessor.getGroup(group))) {
                users.add(user);
            }
        }
        log.debug("Handy Reminder -- users from groups size = {}", (Object)users.size());
        for (String key : reminderMacroParams.getUserKeys()) {
            ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(key));
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    private void sendMailAndAddNotification(AbstractPage page, int macroId, Set<ConfluenceUser> users, ConfluenceUser author, String textHtml) throws Exception {
        this.reminderMacroUsageDao.addRemindersNumber(users.size());
        for (ConfluenceUser user : users) {
            log.debug("Handy Reminder -- mailSender.send userKey = {}", (Object)user.getKey());
            this.mailSender.send(page, user, author, textHtml, macroId);
            log.debug("Handy Reminder -- workboxManager.addNotification userKey = {}", (Object)user.getKey());
            this.workboxManager.addReminderNotification(user, author, page, textHtml, macroId);
        }
    }
}

