/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.reminder.impl;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.macro.reminder.ReminderMacroManager;
import com.stiltsoft.confluence.handy.macros.macro.reminder.ReminderMacroService;
import com.stiltsoft.confluence.handy.macros.macro.reminder.ReminderPreviewHelper;
import com.stiltsoft.confluence.handy.macros.macro.reminder.dto.ReminderMacroParams;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceContentManager;
import com.stiltsoft.confluence.handy.macros.rest.entity.UserRestEntity;
import com.stiltsoft.confluence.handy.macros.rest.reminder.entity.ReminderMacroRestEntity;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import com.stiltsoft.confluence.handy.macros.storage.StorageService;
import com.stiltsoft.confluence.handy.macros.util.AuthenticatedUserUtil;
import com.stiltsoft.confluence.handy.macros.util.ContentEntityUtil;
import com.stiltsoft.confluence.handy.macros.util.ServiceResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultReminderMacroService
implements ReminderMacroService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultReminderMacroService.class);
    private final ConfluenceContentManager confluenceContentManager;
    private final LicenseManager licenseManager;
    private final HandyPermissionService handyPermissionService;
    private final ReminderMacroManager reminderMacroManager;
    private final UserAccessor userAccessor;
    private final StorageService storageService;

    @Override
    public void createReminderMacrosForCreatedContent(ContentEntityObject ceo) {
        this.storageService.handleReminderMacroDefinition(ceo, macroDefinition -> {
            int reminderMacroId = Integer.parseInt(macroDefinition.getParameter("id"));
            long contentId = ceo.getId();
            log.debug("reminderMacroId = {}, pageId = {}.", (Object)reminderMacroId, (Object)contentId);
            this.reminderMacroManager.getReminderMacroParams(reminderMacroId).filter(reminder -> reminder.getPageId() != contentId).ifPresent(reminder -> {
                ConfluenceUser author = ContentEntityUtil.getContentCreator(ceo);
                String authorKey = Objects.nonNull(author) ? author.getKey().getStringValue() : "";
                ReminderMacroParams clonedReminderMacro = this.reminderMacroManager.cloneReminderMacro((ReminderMacroParams)reminder, contentId, authorKey);
                this.storageService.updateReminderId(contentId, Integer.toString(reminderMacroId), Integer.toString(clonedReminderMacro.getId()));
            });
        });
    }

    @Override
    public Optional<ReminderMacroParams> getGetReminderMacroOrCopy(int id, @Nullable Long pageId) {
        return this.reminderMacroManager.getReminderMacroParams(id).map(reminder -> {
            if (Objects.isNull(pageId)) {
                return reminder;
            }
            if (Objects.nonNull(reminder.getPageId())) {
                if (reminder.getPageId().equals(pageId)) {
                    return reminder;
                }
                if (!AuthenticatedUserUtil.getAuthenticatedUser().isPresent()) {
                    return null;
                }
                if (this.confluenceContentManager.isContentPresent(reminder.getPageId()) && !this.handyPermissionService.hasCurrentUserContentReadPermission(reminder.getPageId())) {
                    return null;
                }
            }
            return this.reminderMacroManager.cloneReminderMacro((ReminderMacroParams)reminder, pageId, reminder.getAuthor());
        });
    }

    @Override
    public ReminderMacroRestEntity getReminderMacroRestEntity(ReminderMacroParams reminderMacroParams) {
        List<UserRestEntity> userEntities = this.getUserEntities(reminderMacroParams.getUserKeys());
        return this.toReminderMacroRestEntity(reminderMacroParams, userEntities);
    }

    @Override
    public ReminderMacroRestEntity createCopyReminderMacroForPage(ReminderMacroParams reminder, long pageId) {
        List<UserRestEntity> userEntities = this.getUserEntities(reminder.getUserKeys());
        ReminderMacroParams copy = this.reminderMacroManager.cloneReminderMacro(reminder, pageId, reminder.getAuthor());
        return this.toReminderMacroRestEntity(copy, userEntities);
    }

    @Override
    public ServiceResult<ReminderMacroParams> validateAndCreateReminderMacroParams(@Nullable Long pageId, Set<String> userKeys, Set<String> groups, long nextDate, int type, String description, boolean paused, boolean showDesc, boolean showDate, @Nullable Integer dayOfWeek, @Nullable Integer dayNumber) {
        if (!this.licenseManager.isActive()) {
            return ServiceResult.ERROR("The license is not active");
        }
        Optional<ConfluenceUser> authenticatedUser = AuthenticatedUserUtil.getAuthenticatedUser();
        if (!authenticatedUser.isPresent()) {
            return ServiceResult.ERROR("Anonymous cannot create a new Reminder Macro");
        }
        ConfluenceUser user = authenticatedUser.get();
        if (this.confluenceContentManager.isContentPresent(pageId) && !this.handyPermissionService.hasCurrentUserContentEditPermission(pageId)) {
            return ServiceResult.ERROR("No permitted");
        }
        String authorKey = user.getKey().getStringValue();
        if (userKeys.isEmpty() && groups.isEmpty()) {
            userKeys.add(authorKey);
        }
        ReminderMacroParams reminderMacroParams = this.reminderMacroManager.createReminderMacroParams(pageId, userKeys, groups, nextDate, null, type, description, paused, authorKey, showDesc, showDate, dayOfWeek, dayNumber);
        return ServiceResult.SUCCESS(reminderMacroParams);
    }

    @Override
    public ServiceResult<Boolean> validateAndUpdateReminderMacro(@Nullable Long pageId, int macroId, Set<String> userKeys, Set<String> groupNames, long nextDate, @Nullable Long lastDate, int type, String description, boolean paused, boolean showDesc, boolean showDate, int amount, @Nullable Integer dayOfWeek, @Nullable Integer dayNumber) {
        if (!this.licenseManager.isActive()) {
            return ServiceResult.ERROR("The license is not active");
        }
        Optional<ConfluenceUser> authenticatedUser = AuthenticatedUserUtil.getAuthenticatedUser();
        if (!authenticatedUser.isPresent()) {
            return ServiceResult.ERROR("Anonymous cannot update Reminder Macro");
        }
        ConfluenceUser user = authenticatedUser.get();
        if (amount < 1) {
            return ServiceResult.ERROR("The parameter amount should be positive.");
        }
        if (pageId != null && pageId != 0L) {
            Optional<ReminderMacroParams> reminderMacroParamsOptional = this.reminderMacroManager.getReminderMacroParams(macroId, pageId);
            if (!reminderMacroParamsOptional.isPresent()) {
                return ServiceResult.ERROR("Reminder Macro not found.");
            }
            if (!this.confluenceContentManager.isContentPresent(pageId)) {
                return ServiceResult.ERROR("Content is not found.");
            }
            if (!this.handyPermissionService.hasCurrentUserContentEditPermission(pageId)) {
                return ServiceResult.ERROR("You do not have a permission to edit a content.");
            }
        } else if (this.reminderMacroManager.hasReminderMacroPageId(macroId)) {
            return ServiceResult.ERROR("Reminder Macro already has PageId.");
        }
        if (userKeys.isEmpty() && groupNames.isEmpty()) {
            userKeys.add(user.getKey().getStringValue());
        }
        this.reminderMacroManager.updateReminderMacro(macroId, userKeys, groupNames, nextDate, lastDate, type, description, paused, showDesc, showDate, amount, dayOfWeek, dayNumber);
        return ServiceResult.SUCCESS(Boolean.TRUE);
    }

    @Override
    public ServiceResult<Boolean> validateAndUpdateNextDateAndPaused(int macroId, long pageId, long nextDate) {
        if (!this.licenseManager.isActive()) {
            return ServiceResult.ERROR("The license is not active");
        }
        Optional<ConfluenceUser> authenticatedUser = AuthenticatedUserUtil.getAuthenticatedUser();
        if (!authenticatedUser.isPresent()) {
            return ServiceResult.ERROR("Anonymous cannot update Reminder Macro");
        }
        if (!this.confluenceContentManager.isContentPresent(pageId)) {
            return ServiceResult.ERROR("Content is not found.");
        }
        if (!this.handyPermissionService.hasCurrentUserContentEditPermission(pageId)) {
            return ServiceResult.ERROR("You do not have a permission to edit a content.");
        }
        this.reminderMacroManager.updateNextDateAndPaused(macroId, pageId, nextDate);
        return ServiceResult.SUCCESS(Boolean.TRUE);
    }

    @Override
    public ServiceResult<ReminderMacroRestEntity> validateAndGetReminderMacroOrCopy(int macroId, @Nullable Long pageId) {
        if (!this.licenseManager.isActive()) {
            return ServiceResult.ERROR("The license is not active");
        }
        ConfluenceUser user = AuthenticatedUserUtil.getAuthenticatedUser().orElse(null);
        if (Objects.isNull(pageId)) {
            Optional<ReminderMacroParams> reminderOptional = this.reminderMacroManager.getReminderMacroParams(macroId);
            if (!reminderOptional.isPresent()) {
                return ServiceResult.ERROR("Reminder Macro does not exist.[1]");
            }
            ReminderMacroParams reminder = reminderOptional.get();
            Long reminderPageId = reminder.getPageId();
            if (Objects.nonNull(reminderPageId)) {
                if (!this.confluenceContentManager.isContentPresent(reminderPageId)) {
                    return ServiceResult.ERROR(String.format("Cannot get a content with ID = %d.[2]", reminderPageId));
                }
                if (!this.handyPermissionService.hasCurrentUserContentReadPermission(reminderPageId)) {
                    return ServiceResult.ERROR("You do not have a permission to view a content.[3]");
                }
            }
            return ServiceResult.SUCCESS(this.getReminderMacroRestEntity(reminder));
        }
        if (!this.confluenceContentManager.isContentPresent(pageId)) {
            return ServiceResult.ERROR(String.format("Cannot get a content with ID = %d.[4]", pageId));
        }
        if (!this.handyPermissionService.hasCurrentUserContentReadPermission(pageId)) {
            return ServiceResult.ERROR("You do not have a permission to view a content.[5]");
        }
        Optional<ReminderMacroParams> reminderOptional = this.reminderMacroManager.getReminderMacroParams(macroId, pageId);
        if (reminderOptional.isPresent()) {
            return ServiceResult.SUCCESS(this.getReminderMacroRestEntity(reminderOptional.get()));
        }
        reminderOptional = this.reminderMacroManager.getReminderMacroParams(macroId);
        if (!reminderOptional.isPresent()) {
            return ServiceResult.ERROR("Reminder Macro does not exist.[6]");
        }
        ReminderMacroParams reminder = reminderOptional.get();
        Long reminderPageId = reminder.getPageId();
        if (Objects.nonNull(reminderPageId)) {
            if (!this.confluenceContentManager.isContentPresent(reminderPageId)) {
                return ServiceResult.ERROR(String.format("Cannot get a content with ID = %d.[7]", reminderPageId));
            }
            if (!this.handyPermissionService.hasCurrentUserContentReadPermission(reminderPageId)) {
                return ServiceResult.ERROR("You do not have a permission to view a content.[8]");
            }
        }
        if (Objects.nonNull(user)) {
            reminder.setAuthor(user.getKey().getStringValue());
        }
        return ServiceResult.SUCCESS(this.createCopyReminderMacroForPage(reminder, pageId));
    }

    @Override
    public ServiceResult<ReminderMacroParams> validateAndCloneReminderMacro(int macroId, @Nullable Long pageId) {
        if (!this.licenseManager.isActive()) {
            return ServiceResult.ERROR("The license is not active");
        }
        Optional<ConfluenceUser> authenticatedUser = AuthenticatedUserUtil.getAuthenticatedUser();
        if (!authenticatedUser.isPresent()) {
            return ServiceResult.ERROR("Anonymous cannot update Reminder Macro");
        }
        Optional<ReminderMacroParams> reminderOptional = this.reminderMacroManager.getReminderMacroParams(macroId);
        if (!reminderOptional.isPresent()) {
            return ServiceResult.ERROR("Reminder Macro does not exist.[1]");
        }
        ConfluenceUser user = authenticatedUser.get();
        String userKey = user.getKey().getStringValue();
        ReminderMacroParams reminder = reminderOptional.get();
        Long reminderPageId = reminder.getPageId();
        if (Objects.nonNull(reminderPageId)) {
            if (!this.confluenceContentManager.isContentPresent(reminderPageId)) {
                return ServiceResult.ERROR(String.format("Cannot get a content with ID = %d.[2]", reminderPageId));
            }
            if (!this.handyPermissionService.hasCurrentUserContentEditPermission(reminderPageId)) {
                return ServiceResult.ERROR("You do not have a permission to edit a content.[3]");
            }
        }
        if (Objects.nonNull(pageId)) {
            if (!this.confluenceContentManager.isContentPresent(pageId)) {
                return ServiceResult.ERROR(String.format("Cannot get a content with ID = %d.[4]", pageId));
            }
            if (!this.handyPermissionService.hasCurrentUserContentEditPermission(pageId)) {
                return ServiceResult.ERROR("You do not have a permission to edit a content.[5]");
            }
        }
        return ServiceResult.SUCCESS(this.reminderMacroManager.cloneReminderMacro(reminder, pageId, userKey));
    }

    @Override
    public List<ReminderMacroParams> updateNextDateAndGetForNotifying(List<ReminderMacroParams> reminders) {
        ArrayList<ReminderMacroParams> notifications = new ArrayList<ReminderMacroParams>(reminders.size());
        for (ReminderMacroParams reminder : reminders) {
            long nextDate = ReminderPreviewHelper.getNextDate(reminder, System.currentTimeMillis());
            if (nextDate == 0L) {
                this.reminderMacroManager.updateReminderMacro(reminder);
                continue;
            }
            this.reminderMacroManager.updateReminderMacro(reminder);
            notifications.add(reminder);
        }
        return notifications;
    }

    private List<UserRestEntity> getUserEntities(List<String> userKeys) {
        return userKeys.stream().map(userKey -> this.userAccessor.getUserByKey(new UserKey(userKey))).filter(Objects::nonNull).map(user -> new UserRestEntity(user.getKey().getStringValue(), user.getName(), user.getFullName(), this.userAccessor.getUserProfilePicture((User)user).getUriReference())).collect(Collectors.toList());
    }

    private ReminderMacroRestEntity toReminderMacroRestEntity(ReminderMacroParams params, List<UserRestEntity> userEntities) {
        return new ReminderMacroRestEntity(this.licenseManager.isActive(), params.getId(), params.getNextDate(), params.getLastDate(), params.getType(), params.getAmount(), params.getDescription(), params.isPaused(), params.getGroups(), userEntities, params.isShowDescription(), params.isShowDate(), params.getDayOfWeek(), params.getDayNumber());
    }

    @Generated
    public DefaultReminderMacroService(ConfluenceContentManager confluenceContentManager, LicenseManager licenseManager, HandyPermissionService handyPermissionService, ReminderMacroManager reminderMacroManager, UserAccessor userAccessor, StorageService storageService) {
        this.confluenceContentManager = confluenceContentManager;
        this.licenseManager = licenseManager;
        this.handyPermissionService = handyPermissionService;
        this.reminderMacroManager = reminderMacroManager;
        this.userAccessor = userAccessor;
        this.storageService = storageService;
    }
}

