/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.reminder.impl;

import com.stiltsoft.confluence.handy.macros.macro.reminder.ReminderMacroManager;
import com.stiltsoft.confluence.handy.macros.macro.reminder.dao.ReminderMacroDao;
import com.stiltsoft.confluence.handy.macros.macro.reminder.dao.activeobjects.ReminderMacroEntity;
import com.stiltsoft.confluence.handy.macros.macro.reminder.dto.ReminderMacroParams;
import com.stiltsoft.confluence.handy.macros.util.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;

@Component
public class DefaultReminderMacroManager
implements ReminderMacroManager {
    private static final String GROUPS_SPLITTER = "@%";
    private static final String USERS_SPLITTER = ",";
    private final ReminderMacroDao dao;

    public DefaultReminderMacroManager(ReminderMacroDao dao) {
        this.dao = dao;
    }

    @Override
    public boolean hasReminderMacroPageId(int macroId) {
        return this.dao.hasPageId(macroId);
    }

    @Override
    public ReminderMacroParams createReminderMacroParams(@Nullable Long pageId, Set<String> userKeys, Set<String> groups, long nextDate, @Nullable Long lastDate, int type, String description, boolean paused, String authorKey, boolean showDesc, Boolean showDate, @Nullable Integer dayOfWeek, @Nullable Integer dayNumber) {
        String joinedUserKeys = String.join((CharSequence)USERS_SPLITTER, userKeys);
        String joinedGroups = String.join((CharSequence)GROUPS_SPLITTER, groups);
        ReminderMacroEntity reminderMacroEntity = this.dao.create(pageId, nextDate, lastDate, type, joinedUserKeys, joinedGroups, description, paused, authorKey, showDesc, showDate, dayOfWeek, dayNumber);
        return this.toReminderMacroParams(reminderMacroEntity);
    }

    @Override
    public Optional<ReminderMacroParams> getReminderMacroParams(int macroId) {
        return this.dao.findById(macroId).map(this::toReminderMacroParams);
    }

    @Override
    public Optional<ReminderMacroParams> getReminderMacroParams(int macroId, Long pageId) {
        return Optional.ofNullable(pageId).flatMap(nonNullPageId -> this.dao.findByIdAndPageId(macroId, pageId)).map(this::toReminderMacroParams);
    }

    @Override
    public List<ReminderMacroParams> findActiveRemindersWithExpiredNextDate(int limit) {
        return this.dao.findActiveExpiredNextDate(limit).stream().map(this::toReminderMacroParams).collect(Collectors.toList());
    }

    @Override
    public void updateReminderMacro(int macroId, Set<String> userKeys, Set<String> groupNames, long nextDate, @Nullable Long lastDate, int type, String description, boolean paused, boolean showDesc, boolean showDate, int amount, @Nullable Integer dayOfWeek, @Nullable Integer dayNumber) {
        String joinedUserKeys = String.join((CharSequence)USERS_SPLITTER, userKeys);
        String joinedGroups = String.join((CharSequence)GROUPS_SPLITTER, groupNames);
        this.dao.update(macroId, joinedUserKeys, joinedGroups, nextDate, lastDate, type, description, paused, showDesc, showDate, amount, dayOfWeek, dayNumber);
    }

    @Override
    public void updateNextDateAndPaused(int macroId, long pageId, long nextDate) {
        this.dao.updateNextDateAndPaused(macroId, pageId, nextDate);
    }

    @Override
    public void deleteReminderMacro(int macroId) {
        this.dao.deleteById(macroId);
    }

    @Override
    public ReminderMacroParams cloneReminderMacro(ReminderMacroParams reminder, @Nullable Long pageId, String authorUserKey) {
        return this.createReminderMacroParams(pageId, new HashSet<String>(reminder.getUserKeys()), new HashSet<String>(reminder.getGroups()), reminder.getNextDate(), reminder.getLastDate(), reminder.getType(), reminder.getDescription(), reminder.isPaused(), authorUserKey, reminder.isShowDescription(), reminder.isShowDate(), reminder.getDayOfWeek(), reminder.getDayNumber());
    }

    @Override
    public void setReminderMacroPaused(int macroId) {
        this.dao.setPaused(macroId);
    }

    @Override
    public void updateReminderMacro(ReminderMacroParams reminder) {
        HashSet<String> userKeys = new HashSet<String>(reminder.getUserKeys());
        HashSet<String> groups = new HashSet<String>(reminder.getGroups());
        this.updateReminderMacro(reminder.getId(), userKeys, groups, reminder.getNextDate(), reminder.getLastDate(), reminder.getType(), reminder.getDescription(), reminder.isPaused(), reminder.isShowDescription(), reminder.isShowDate(), reminder.getAmount(), reminder.getDayOfWeek(), reminder.getDayNumber());
    }

    private ReminderMacroParams toReminderMacroParams(ReminderMacroEntity entity) {
        return ReminderMacroParams.builder().id(entity.getID()).pageId(entity.getPageId()).nextDate(entity.getNextDate()).lastDate(entity.getLastDate()).leftDays(entity.getLeftDays()).paused(Objects.nonNull(entity.getPaused()) && entity.getPaused() != false).type(entity.getType()).amount(Optional.ofNullable(entity.getAmount()).orElse(1)).dayOfWeek(entity.getDayOfWeek()).dayNumber(entity.getDayNumber()).author(entity.getAuthor()).userKeys(StringUtil.splitString(entity.getUsers(), USERS_SPLITTER)).groups(StringUtil.splitString(entity.getGroups(), GROUPS_SPLITTER)).description(Optional.ofNullable(entity.getDescription()).orElse("")).showDescription(entity.getShowDesc()).showDate(Objects.nonNull(entity.getShowDate()) && entity.getShowDate() != false).build();
    }
}

