/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.reminder.dto;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.template.ContentTemplate;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class ConfluenceContent {
    private final Content content;
    private final ContentTemplate contentTemplate;

    private ConfluenceContent(Content content, ContentTemplate contentTemplate) {
        this.content = content;
        this.contentTemplate = contentTemplate;
    }

    public static ConfluenceContent getInstance(@Nullable Content content, @Nullable ContentTemplate contentTemplate) {
        if (Objects.isNull(content) && Objects.isNull(contentTemplate)) {
            return null;
        }
        return new ConfluenceContent(content, contentTemplate);
    }

    public Optional<Content> getContentOptional() {
        return Optional.ofNullable(this.content);
    }

    public Optional<ContentTemplate> getContentTemplateOptional() {
        return Optional.ofNullable(this.contentTemplate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfluenceContent)) {
            return false;
        }
        ConfluenceContent that = (ConfluenceContent)o;
        if (!Objects.equals(this.content, that.content)) {
            return false;
        }
        return Objects.equals(this.contentTemplate, that.contentTemplate);
    }

    public int hashCode() {
        int result = this.content != null ? this.content.hashCode() : 0;
        result = 31 * result + (this.contentTemplate != null ? this.contentTemplate.hashCode() : 0);
        return result;
    }
}

