/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.reminder.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.handy.macros.macro.reminder.dao.ReminderMacroDao;
import com.stiltsoft.confluence.handy.macros.macro.reminder.dao.activeobjects.ReminderMacroEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.springframework.stereotype.Component;

@Component
public class ReminderMacroDaoImpl
implements ReminderMacroDao {
    private final ActiveObjects ao;

    public ReminderMacroDaoImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public boolean hasPageId(int id) {
        String clause = String.format("%s = ? AND %s IS NOT NULL", "ID", "PAGE_ID");
        Query query = Query.select().where(clause, new Object[]{id}).limit(1);
        return this.ao.count(ReminderMacroEntity.class, query) > 0;
    }

    @Override
    public Optional<ReminderMacroEntity> findById(int id) {
        Query query = Query.select().where("ID = ?", new Object[]{id}).limit(1);
        ReminderMacroEntity[] result = (ReminderMacroEntity[])this.ao.find(ReminderMacroEntity.class, query);
        return result.length == 0 ? Optional.empty() : Optional.of(result[0]);
    }

    @Override
    public Optional<ReminderMacroEntity> findByIdAndPageId(int id, long pageId) {
        String clause = String.format("%s = ? AND %s = ?", "ID", "PAGE_ID");
        Query query = Query.select().where(clause, new Object[]{id, pageId}).limit(1);
        ReminderMacroEntity[] result = (ReminderMacroEntity[])this.ao.find(ReminderMacroEntity.class, query);
        return result.length == 0 ? Optional.empty() : Optional.of(result[0]);
    }

    @Override
    public List<ReminderMacroEntity> findActiveExpiredNextDate(int limit) {
        String clause = String.format("%s <= ? AND %s = ? AND %s IS NOT NULL", "NEXT_DATE", "PAUSED", "PAGE_ID");
        Query query = Query.select().where(clause, new Object[]{System.currentTimeMillis(), Boolean.FALSE}).limit(limit);
        return Arrays.asList((ReminderMacroEntity[])this.ao.find(ReminderMacroEntity.class, query));
    }

    @Override
    public ReminderMacroEntity create(@Nullable Long pageId, long nextDate, @Nullable Long lastDate, int type, String userKeys, String groups, String description, boolean paused, String authorKey, boolean showDesc, boolean showDate, Integer dayOfWeek, Integer dayNumber) {
        return (ReminderMacroEntity)this.ao.create(ReminderMacroEntity.class, new DBParam[]{new DBParam("PAGE_ID", (Object)pageId), new DBParam("NEXT_DATE", (Object)nextDate), new DBParam("LAST_DATE", (Object)lastDate), new DBParam("TYPE", (Object)type), new DBParam("USERS", (Object)userKeys), new DBParam("GROUPS", (Object)groups), new DBParam("DESCRIPTION", (Object)description), new DBParam("PAUSED", (Object)paused), new DBParam("AUTHOR", (Object)authorKey), new DBParam("SHOW_DESC", (Object)showDesc), new DBParam("SHOW_DATE", (Object)showDate), new DBParam("DAY_OF_WEEK", (Object)dayOfWeek), new DBParam("DAY_NUMBER", (Object)dayNumber)});
    }

    @Override
    public void update(int id, String userKeys, String groups, long nextDate, @Nullable Long lastDate, int type, String description, boolean paused, boolean showDesc, boolean showDate, int amount, Integer dayOfWeek, Integer dayNumber) {
        this.findById(id).ifPresent(entity -> {
            entity.setUsers(userKeys);
            entity.setGroups(groups);
            entity.setNextDate(nextDate);
            entity.setLastDate(lastDate);
            entity.setType(type);
            entity.setDescription(description);
            entity.setPaused(paused);
            entity.setShowDesc(showDesc);
            entity.setShowDate(showDate);
            entity.setLeftDays(0);
            entity.setAmount(amount);
            entity.setDayOfWeek(dayOfWeek);
            entity.setDayNumber(dayNumber);
            entity.save();
        });
    }

    @Override
    public void updateNextDateAndPaused(int id, long pageId, long nextDate) {
        this.findByIdAndPageId(id, pageId).ifPresent(entity -> {
            entity.setNextDate(nextDate);
            entity.setPaused(false);
            entity.save();
        });
    }

    @Override
    public void deleteById(int id) {
        this.ao.deleteWithSQL(ReminderMacroEntity.class, "ID = ?", new Object[]{id});
    }

    @Override
    public void setPaused(int id) {
        this.findById(id).ifPresent(entity -> {
            entity.setPaused(true);
            entity.save();
        });
    }
}

