/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.reminder;

import com.stiltsoft.confluence.handy.macros.macro.reminder.dto.ReminderMacroParams;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ReminderPreviewHelper {
    public static final Integer RUN_ONCE_TYPE = 0;
    public static final Integer DAILY_TYPE = 1;
    public static final Integer WORKDAY_TYPE = 2;
    public static final Integer WEEKLY_TYPE = 3;
    public static final Integer MONTHLY_TYPE = 4;
    public static final Integer YEARLY_TYPE = 5;

    public static long getNextDate(ReminderMacroParams reminder, long currentDate) {
        if (reminder.getLastDate() != null && reminder.getLastDate() < currentDate || reminder.isPaused()) {
            reminder.setPaused(true);
            return -1L;
        }
        int amount = reminder.getAmount();
        if (amount < 1) {
            reminder.setPaused(true);
            return -1L;
        }
        if (RUN_ONCE_TYPE.equals(reminder.getType())) {
            reminder.setPaused(true);
            return currentDate;
        }
        if (WEEKLY_TYPE.equals(reminder.getType())) {
            while (reminder.getNextDate() <= currentDate) {
                reminder.setNextDate(reminder.getNextDate() + TimeUnit.DAYS.toMillis(7L * (long)amount));
            }
        } else if (MONTHLY_TYPE.equals(reminder.getType())) {
            GregorianCalendar calendar = new GregorianCalendar();
            Integer dayOfWeek = reminder.getDayOfWeek();
            while (reminder.getNextDate() <= currentDate) {
                for (int i = 0; i < amount; ++i) {
                    calendar.setTime(new Date(reminder.getNextDate()));
                    if (dayOfWeek == null) {
                        int currentMonth = calendar.get(2);
                        int daysInMonth = ((Calendar)calendar).getActualMaximum(5);
                        if (reminder.getLeftDays() != null) {
                            daysInMonth += reminder.getLeftDays().intValue();
                            reminder.setLeftDays(0);
                        }
                        ((Calendar)calendar).add(6, daysInMonth);
                        int nextMonth = calendar.get(2);
                        if (currentMonth < nextMonth && nextMonth - currentMonth > 1 || currentMonth > nextMonth && currentMonth - nextMonth < 11) {
                            reminder.setLeftDays(calendar.get(5));
                            daysInMonth -= calendar.get(5);
                        }
                        reminder.setNextDate(reminder.getNextDate() + TimeUnit.DAYS.toMillis(daysInMonth));
                        continue;
                    }
                    ((Calendar)calendar).add(2, 1);
                    calendar.set(7, dayOfWeek);
                    calendar.set(8, reminder.getDayNumber() > 4 ? -1 : reminder.getDayNumber());
                    reminder.setNextDate(calendar.getTimeInMillis());
                }
            }
        } else if (DAILY_TYPE.equals(reminder.getType())) {
            while (reminder.getNextDate() <= currentDate) {
                reminder.setNextDate(reminder.getNextDate() + TimeUnit.DAYS.toMillis(amount));
            }
        } else if (WORKDAY_TYPE.equals(reminder.getType())) {
            GregorianCalendar calendar = new GregorianCalendar();
            while (reminder.getNextDate() <= currentDate) {
                for (int i = 0; i < amount; ++i) {
                    calendar.setTime(new Date(reminder.getNextDate()));
                    int dayOfWeek = calendar.get(7);
                    int days = 1;
                    if (dayOfWeek == 6) {
                        days = 3;
                    } else if (dayOfWeek == 7) {
                        days = 2;
                    }
                    reminder.setNextDate(reminder.getNextDate() + TimeUnit.DAYS.toMillis(days));
                }
            }
        } else if (YEARLY_TYPE.equals(reminder.getType())) {
            GregorianCalendar calendar = new GregorianCalendar();
            while (reminder.getNextDate() <= currentDate) {
                for (int i = 0; i < amount; ++i) {
                    calendar.setTime(new Date(reminder.getNextDate()));
                    int daysInYear = calendar.getActualMaximum(6);
                    int currentMonth = calendar.get(2);
                    if (reminder.getLeftDays() != null) {
                        daysInYear += reminder.getLeftDays().intValue();
                        reminder.setLeftDays(0);
                    }
                    calendar.add(6, daysInYear);
                    int nextMonth = calendar.get(2);
                    if (nextMonth != currentMonth) {
                        reminder.setLeftDays(1);
                        --daysInYear;
                    }
                    reminder.setNextDate(reminder.getNextDate() + TimeUnit.DAYS.toMillis(daysInYear));
                }
            }
        }
        if (reminder.getLastDate() != null && reminder.getLastDate() < reminder.getNextDate()) {
            reminder.setPaused(true);
            return -1L;
        }
        return reminder.getNextDate();
    }

    public static Set<Long> getDatesForPreview(ReminderMacroParams reminder) {
        LinkedHashSet<Long> dates = new LinkedHashSet<Long>();
        long nextDate = Math.max(System.currentTimeMillis(), reminder.getNextDate());
        if (reminder.getLastDate() != null && reminder.getLastDate() < nextDate || reminder.isPaused()) {
            return dates;
        }
        dates.add(nextDate);
        for (int i = 0; i < 16 && (nextDate = ReminderPreviewHelper.getNextDate(reminder, nextDate)) > 0L; ++i) {
            dates.add(nextDate);
        }
        return dates;
    }
}

