/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.reminder;

import com.atlassian.confluence.api.service.datetime.DateFormatService;
import com.atlassian.confluence.content.render.image.ImageDimensions;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.model.time.Time;
import com.atlassian.confluence.content.render.xhtml.storage.time.TimeModelDecorator;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.macro.reminder.ReminderMacroManager;
import com.stiltsoft.confluence.handy.macros.macro.reminder.ReminderPreviewHelper;
import com.stiltsoft.confluence.handy.macros.macro.reminder.dto.ReminderMacroParams;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import com.stiltsoft.confluence.handy.macros.util.DateTimeUtil;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReminderMacro
implements Macro,
EditorImagePlaceholder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReminderMacro.class);
    private final LicenseManager licenseManager;
    private final ReminderMacroManager reminderMacroManager;
    private final HandyPermissionService handyPermissionService;
    private final FormatSettingsManager formatSettingsManager;
    private final LocaleManager localeManager;
    private final UserAccessor userAccessor;
    private final TimeModelDecorator timeModelDecorator;
    private final DateFormatService dateFormatService;
    private final VelocityHelperService velocityHelperService;

    public String execute(Map<String, String> params, String body, ConversionContext context) {
        Map ctx = MacroUtils.defaultVelocityContext();
        boolean isPPR = false;
        for (StackTraceElement traceElement : Thread.currentThread().getStackTrace()) {
            if (!traceElement.getClassName().endsWith("DetailsSummaryMacro")) continue;
            isPPR = true;
            break;
        }
        ContentEntityObject ceo = context.getEntity();
        Long pageId = isPPR || ceo == null ? null : (ceo.isLatestVersion() ? Long.valueOf(ceo.getId()) : null);
        int reminderId = Integer.parseInt(params.get("id"));
        Optional<ReminderMacroParams> reminderOptional = this.reminderMacroManager.getReminderMacroParams(reminderId, pageId);
        if (!reminderOptional.isPresent()) {
            return this.velocityHelperService.getRenderedTemplate("vm/reminder-macro-inactive.vm", ctx);
        }
        ReminderMacroParams reminder = reminderOptional.get();
        boolean isPreview = "preview".equals(context.getOutputType());
        ctx.put("pageId", pageId);
        ctx.put("macroId", reminderId);
        ctx.put("editable", !isPreview && ceo != null && this.handyPermissionService.hasCurrentUserEntityEditPermission(ceo));
        ctx.put("inactive", !this.licenseManager.isActive() || reminder.isPaused() ? "inactive" : "");
        ctx.put("preview", isPreview);
        ctx.put("email", "email".equals(context.getOutputDeviceType()) || "email".equals(context.getOutputType()));
        ctx.put("description", reminder.getDescription());
        ctx.put("showDesc", reminder.isShowDescription());
        ctx.put("showDate", reminder.isShowDate() && ReminderPreviewHelper.RUN_ONCE_TYPE.equals(reminder.getType()));
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        ConfluenceUserPreferences userPreferences = this.userAccessor.getConfluenceUserPreferences((User)user);
        TimeZone timeZone = userPreferences.getTimeZone();
        Time time = DateTimeUtil.convertToTime(reminder.getNextDate(), timeZone);
        ctx.put("date", this.dateFormatService.getFormattedDateByUserLocale(time.getLocalDate()));
        ZonedDateTime oneDayBefore = DateTimeUtil.getZonedDateTime(reminder.getNextDate(), timeZone).minusDays(1L);
        time = DateTimeUtil.convertZonedDateTimeToTime(oneDayBefore);
        this.timeModelDecorator.decorate(time);
        ctx.put("dateClass", time.getCssClasses());
        if (isPreview) {
            DateFormatter dateFormatter = userPreferences.getDateFormatter(this.formatSettingsManager, this.localeManager);
            ArrayList<String> dates = new ArrayList<String>();
            for (long timeStamp : ReminderPreviewHelper.getDatesForPreview(reminder)) {
                dates.add(dateFormatter.formatDateFull(new Date(timeStamp)));
            }
            ctx.put("dates", dates);
        }
        return this.velocityHelperService.getRenderedTemplate("vm/reminder-macro.vm", ctx);
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> map, ConversionContext context) {
        int reminderId = Integer.parseInt(map.get("id"));
        String imagesResourcePath = "/download/resources/com.stiltsoft.confluence.handy.macros/images/reminder/";
        ImageDimensions dimensions = new ImageDimensions(16, 17);
        return (ImagePlaceholder)this.reminderMacroManager.getReminderMacroParams(reminderId).map(reminder -> new DefaultImagePlaceholder(imagesResourcePath + (!this.licenseManager.isActive() || reminder.isPaused() ? "reminder-inactive.png" : "reminder-active.png"), false, dimensions)).orElseGet(() -> new DefaultImagePlaceholder(imagesResourcePath + "reminder-inactive.png", false, dimensions));
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    @Generated
    public ReminderMacro(LicenseManager licenseManager, ReminderMacroManager reminderMacroManager, HandyPermissionService handyPermissionService, FormatSettingsManager formatSettingsManager, LocaleManager localeManager, UserAccessor userAccessor, TimeModelDecorator timeModelDecorator, DateFormatService dateFormatService, VelocityHelperService velocityHelperService) {
        this.licenseManager = licenseManager;
        this.reminderMacroManager = reminderMacroManager;
        this.handyPermissionService = handyPermissionService;
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.userAccessor = userAccessor;
        this.timeModelDecorator = timeModelDecorator;
        this.dateFormatService = dateFormatService;
        this.velocityHelperService = velocityHelperService;
    }
}

