/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.card.search;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.stiltsoft.confluence.handy.macros.macro.card.search.query.AbstractLabelsLucineQuery;
import com.stiltsoft.confluence.handy.macros.macro.card.search.query.AndLabelsLucineQuery;
import com.stiltsoft.confluence.handy.macros.macro.card.search.query.OrLabelsLucineQuery;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class PagesSearcher {
    private final SearchManager searchManager;
    private final HandyPermissionService handyPermissionService;
    private final PredefinedSearchBuilder predefinedSearchBuilder;

    public PagesSearcher(SearchManager searchManager, HandyPermissionService handyPermissionService, PredefinedSearchBuilder predefinedSearchBuilder) {
        this.searchManager = searchManager;
        this.handyPermissionService = handyPermissionService;
        this.predefinedSearchBuilder = predefinedSearchBuilder;
    }

    public Set<ContentEntityObject> getChildPages(ContentEntityObject ceo) {
        LinkedHashSet<ContentEntityObject> pages = new LinkedHashSet<ContentEntityObject>();
        if (ceo instanceof Page) {
            pages.addAll(this.filterPermittedPages(((Page)ceo).getSortedChildren()));
        }
        return pages;
    }

    public Set<ContentEntityObject> findPages(String spaceKey, String[] labels, boolean labelsLogicAnd, boolean searchPages, boolean searchBlogs, String sortType, int limit) throws InvalidSearchException {
        SearchQueryParameters searchQueryParameters = new SearchQueryParameters();
        HashSet<ContentTypeEnum> contentTypes = new HashSet<ContentTypeEnum>();
        if (searchPages) {
            contentTypes.add(ContentTypeEnum.PAGE);
        }
        if (searchBlogs) {
            contentTypes.add(ContentTypeEnum.BLOG);
        }
        searchQueryParameters.setContentTypes(contentTypes);
        if (!spaceKey.isEmpty()) {
            searchQueryParameters.setSpaceKey(spaceKey);
        }
        if (this.hasLabels(labels)) {
            AbstractLabelsLucineQuery labelsLucineQuery = labelsLogicAnd ? new AndLabelsLucineQuery() : new OrLabelsLucineQuery();
            searchQueryParameters.setQuery(labelsLucineQuery.getQuery(labels));
        }
        Object sort = "title".equals(sortType) ? TitleSort.ASCENDING : ("modified".equals(sortType) ? ModifiedSort.DESCENDING : CreatedSort.DESCENDING);
        searchQueryParameters.setSort((SearchSort)sort);
        ISearch iSearch = this.predefinedSearchBuilder.buildSiteSearch(searchQueryParameters, 0, limit);
        SearchResults searchResults = this.searchManager.search(iSearch);
        List searchables = this.searchManager.convertToEntities(searchResults, SearchManager.EntityVersionPolicy.LATEST_VERSION);
        return new LinkedHashSet<ContentEntityObject>(searchables);
    }

    private List<Page> filterPermittedPages(List<Page> pages) {
        ArrayList<Page> permittedPages = new ArrayList<Page>();
        for (Page page : pages) {
            if (!this.handyPermissionService.hasCurrentUserEntityReadPermission((ContentEntityObject)page)) continue;
            permittedPages.add(page);
        }
        return permittedPages;
    }

    private boolean hasLabels(String[] labels) {
        return labels.length > 0 && Arrays.stream(labels).anyMatch(label -> !label.isEmpty());
    }
}

