/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.card;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.stiltsoft.confluence.handy.macros.manager.HandyDateFormatter;
import com.stiltsoft.confluence.handy.macros.manager.HandyLinkResolver;
import com.stiltsoft.confluence.handy.macros.storage.StorageConverter;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HandyPostOrganizerContentMacro
implements Macro {
    private final HandyLinkResolver linkResolver;
    private final HandyDateFormatter handyDateFormatter;
    private final VelocityHelperService velocityHelperService;

    public HandyPostOrganizerContentMacro(HandyLinkResolver linkResolver, HandyDateFormatter handyDateFormatter, VelocityHelperService velocityHelperService) {
        this.linkResolver = linkResolver;
        this.handyDateFormatter = handyDateFormatter;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map<String, String> params, String body, ConversionContext context) {
        Map ctx = MacroUtils.defaultVelocityContext();
        ctx.put("handyDateFormatter", this.handyDateFormatter);
        String link = StringUtils.defaultString((String)params.get("link")).trim();
        HandyLinkResolver.HandyLink handyLink = this.linkResolver.getURL(link, context);
        ctx.put("urlHtml", handyLink.getUrl());
        ctx.put("content", handyLink.getContent());
        ctx.put("body", StorageConverter.sanitize(body));
        return this.velocityHelperService.getRenderedTemplate("vm/post-organizer-card.vm", ctx);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

