/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.card;

import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.renderer.RenderContext;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.macro.card.search.PagesSearcher;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceSpaceManager;
import com.stiltsoft.confluence.handy.macros.manager.HandyDateFormatter;
import com.stiltsoft.confluence.handy.macros.storage.StorageConverter;
import com.stiltsoft.confluence.handy.macros.storage.StorageService;
import com.stiltsoft.confluence.handy.macros.util.StringUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandyCardsMacro
implements Macro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HandyCardsMacro.class);
    private static final int PAGE_LIMIT = 50;
    private static final int TEXT_LIMIT = 500;
    private final LicenseManager licenseManager;
    private final PagesSearcher pagesSearcher;
    private final StorageService storageService;
    private final StorageConverter converter;
    private final HandyDateFormatter handyDateFormatter;
    private final GlobalSettingsManager settingsManager;
    private final VelocityHelperService velocityHelperService;
    private final ConfluenceSpaceManager confluenceSpaceManager;

    public HandyCardsMacro(LicenseManager licenseManager, PagesSearcher pagesSearcher, StorageService storageService, StorageConverter converter, HandyDateFormatter handyDateFormatter, GlobalSettingsManager settingsManager, VelocityHelperService velocityHelperService, ConfluenceSpaceManager confluenceSpaceManager) {
        this.licenseManager = licenseManager;
        this.pagesSearcher = pagesSearcher;
        this.storageService = storageService;
        this.converter = converter;
        this.handyDateFormatter = handyDateFormatter;
        this.settingsManager = settingsManager;
        this.velocityHelperService = velocityHelperService;
        this.confluenceSpaceManager = confluenceSpaceManager;
    }

    public String execute(Map<String, String> params, String body, ConversionContext context) {
        Map ctx = MacroUtils.defaultVelocityContext();
        StringBuilder bodyBuilder = new StringBuilder();
        try {
            Set<ContentEntityObject> pages = this.getPages(context.getEntity(), params);
            for (ContentEntityObject page : pages) {
                Map cardContext = MacroUtils.defaultVelocityContext();
                this.setContent(page, params, context, cardContext);
                cardContext.put("handyDateFormatter", this.handyDateFormatter);
                cardContext.put("page", page);
                cardContext.put("showDate", params.get("show-date"));
                cardContext.put("showCreated", params.get("show-created"));
                cardContext.put("stretchCards", params.get("stretch-cards"));
                Optional<Integer> maxImageHeight = StringUtil.parseInteger(params.get("max-image-height"));
                maxImageHeight.ifPresent(integer -> cardContext.put("maxImageHeight", integer));
                bodyBuilder.append(this.velocityHelperService.getRenderedTemplate("vm/post-organizer-card.vm", cardContext));
            }
        }
        catch (InvalidSearchException e) {
            log.error("Failed to get data  from pages", (Throwable)e);
        }
        bodyBuilder.append(body);
        String cardsBody = bodyBuilder.toString();
        String cardWidth = "fixed".equals(params.get("view")) ? 100 / StringUtil.parsePositiveInt(params.get("columns-number"), 3, 20) + "%" : StringUtil.parsePositiveInt(params.get("column-width"), 300, 3000) + "px";
        cardsBody = StringUtils.defaultString((String)params.get("stretch-cards")).equals("true") ? cardsBody.replace("${hpo-width}", "flex: 1 1 " + cardWidth + ";") : cardsBody.replace("${hpo-width}", "width: " + cardWidth + ";");
        ctx.put("licensed", this.licenseManager.isActive());
        ctx.put("body", cardsBody);
        ctx.put("view", params.get("view"));
        ctx.put("columnsNumber", StringUtil.parsePositiveInt(params.get("columns-number"), 3, 20));
        ctx.put("columnWidth", StringUtil.parsePositiveInt(params.get("column-width"), 300, 3000));
        ctx.put("showAuthor", params.get("show-author"));
        ctx.put("showDate", params.get("show-date"));
        ctx.put("showCreated", params.get("show-created"));
        return this.velocityHelperService.getRenderedTemplate("vm/post-organizer-macro.vm", ctx);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private void setContent(ContentEntityObject page, Map<String, String> params, ConversionContext context, Map<String, Object> cardContext) {
        if (this.excerptMacroContent(page, params, cardContext)) {
            return;
        }
        this.confluenceSpaceManager.getSpaceByPageId(page.getId()).ifPresent(space -> {
            cardContext.put("space", space);
            cardContext.put("spaceLink", ((Link)space.getLinks().get(LinkType.WEB_UI)).getPath());
        });
        String storage = page.getBodyAsString();
        String imageSource = StringUtils.defaultString((String)params.get("image-source"));
        String textSource = StringUtils.defaultString((String)params.get("text-source"));
        if ("name".equals(imageSource)) {
            cardContext.put("imageUrl", this.getImageURLByName(page, params));
        } else if ("first".equals(imageSource) && !"excerpt".equals(textSource)) {
            cardContext.put("imageUrl", this.converter.getFirstImageUrl(storage, context, page));
        } else if ("first-or-empty".equals(imageSource) && !"excerpt".equals(textSource)) {
            cardContext.put("imageUrl", this.converter.getFirstImageUrl(storage, context, page));
        }
        if (!textSource.equals("excerpt")) {
            cardContext.put("imageSource", imageSource);
        }
        int textLength = StringUtil.parsePositiveInt(params.get("text-length"), 250, 500);
        cardContext.put("text", this.converter.convertToPlainText(storage, textLength));
    }

    private boolean excerptMacroContent(ContentEntityObject page, Map<String, String> params, Map<String, Object> cardContext) {
        String storage;
        String textSource = StringUtils.defaultString((String)params.get("text-source"));
        if ("excerpt".equals(textSource) && (storage = this.storageService.getExcerptMacroBodyStorage(page)) != null) {
            cardContext.put("body", StorageConverter.sanitize(this.converter.convertToView(storage, (ConversionContext)new DefaultConversionContext((RenderContext)page.toPageContext()))));
            cardContext.put("showPageTitle", params.get("show-page-title"));
            return true;
        }
        return false;
    }

    private String getImageURLByName(ContentEntityObject page, Map<String, String> params) {
        Attachment attachment;
        String imageName = StringUtils.defaultString((String)params.get("image-name"));
        if (!imageName.isEmpty() && (attachment = page.getAttachmentNamed(imageName)) != null) {
            return this.settingsManager.getGlobalSettings().getBaseUrl() + ((Attachment)attachment.getLatestVersion()).getDownloadPath();
        }
        return null;
    }

    private Set<ContentEntityObject> getPages(ContentEntityObject ceo, Map<String, String> params) throws InvalidSearchException {
        String type = params.get("type");
        if ("custom".equals(type)) {
            return new HashSet<ContentEntityObject>();
        }
        if ("child-pages".equals(type)) {
            return this.pagesSearcher.getChildPages(ceo);
        }
        String[] labels = StringUtils.defaultString((String)params.get("labels")).split(",");
        String spaceKey = StringUtils.defaultString((String)params.get("space"));
        String contentType = params.get("content-type");
        boolean searchPages = !"blog-posts".equals(contentType);
        boolean searchBlogs = !"pages".equals(contentType);
        String sort = params.get("sort");
        int limit = StringUtil.parsePositiveInt(params.get("limit"), 50, 1000);
        boolean labelsLogicAnd = StringUtils.defaultString((String)params.get("labels-logic")).equals("and");
        return this.pagesSearcher.findPages(spaceKey, labels, labelsLogicAnd, searchPages, searchBlogs, sort, limit);
    }
}

