/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import java.util.Map;

public class HandyTipMacro
implements Macro {
    private final LicenseManager licenseManager;
    private final VelocityHelperService velocityHelperService;

    public HandyTipMacro(LicenseManager licenseManager, VelocityHelperService velocityHelperService) {
        this.licenseManager = licenseManager;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map<String, String> params, String body, ConversionContext context) {
        if ("pdf".equals(context.getOutputType()) || "word".equals(context.getOutputType())) {
            return " ";
        }
        Map ctx = MacroUtils.defaultVelocityContext();
        ctx.put("licensed", this.licenseManager.isActive());
        ctx.put("body", body);
        ctx.put("id", params.get("id"));
        return this.velocityHelperService.getRenderedTemplate("vm/tip-macro.vm", ctx);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

