/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CarouselMacro
implements Macro {
    private final LicenseManager licenseManager;
    private final VelocityHelperService velocityHelperService;

    public CarouselMacro(LicenseManager licenseManager, VelocityHelperService velocityHelperService) {
        this.licenseManager = licenseManager;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map<String, String> params, String body, ConversionContext context) {
        Map ctx = MacroUtils.defaultVelocityContext();
        ctx.put("licensed", this.licenseManager.isActive());
        ctx.put("body", body);
        ctx.put("preset", StringUtils.defaultString((String)params.get("preset"), (String)"carousel"));
        ctx.put("controls", StringUtils.defaultString((String)params.get("controls"), (String)"Center"));
        ctx.put("ratio", StringUtils.defaultString((String)params.get("ratio"), (String)"2"));
        ctx.put("delay", StringUtils.defaultString((String)params.get("delay"), (String)"5"));
        ctx.put("items", StringUtils.defaultString((String)params.get("items"), (String)"auto"));
        ctx.put("random", Boolean.valueOf(params.get("random")));
        return this.velocityHelperService.getRenderedTemplate("vm/carousel-macro.vm", ctx);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

