/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro;

import com.atlassian.confluence.content.render.image.ImageDimensions;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.HtmlUtil;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.manager.ColorHelper;
import com.stiltsoft.confluence.handy.macros.manager.HandyLinkResolver;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ButtonMacro
implements Macro,
EditorImagePlaceholder {
    private final HandyLinkResolver linkResolver;
    private final LicenseManager licenseManager;
    private final VelocityHelperService velocityHelperService;

    public ButtonMacro(LicenseManager licenseManager, HandyLinkResolver linkResolver, VelocityHelperService velocityHelperService) {
        this.licenseManager = licenseManager;
        this.linkResolver = linkResolver;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map<String, String> params, String body, ConversionContext context) {
        Map ctx = MacroUtils.defaultVelocityContext();
        String backgroundColor = this.getHexColor(params.get("color"));
        String link = StringUtils.defaultString((String)params.get("link")).trim();
        ctx.put("licensed", this.licenseManager.isActive());
        ctx.put("name", params.get("name"));
        ctx.put("width", params.get("width"));
        ctx.put("blank", Boolean.valueOf(params.get("blank")));
        ctx.put("linkHtml", this.linkResolver.getURL(link, context).getUrl());
        ctx.put("backgroundColor", backgroundColor);
        ctx.put("textColor", ColorHelper.getContrastColor(backgroundColor));
        return this.velocityHelperService.getRenderedTemplate("vm/button-macro.vm", ctx);
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> map, ConversionContext conversionContext) {
        String backgroundColor = this.getHexColor(map.get("color"));
        BufferedImage bufferedImage = new BufferedImage(88, 1000, 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        Font font = new Font("Arial", 1, 14);
        graphics.setFont(font);
        int txtWidth = graphics.getFontMetrics().stringWidth(map.get("name")) + 12;
        if (map.get("width") != null && StringUtils.isNumeric((CharSequence)map.get("width"))) {
            txtWidth = Integer.valueOf(map.get("width"));
        }
        return new DefaultImagePlaceholder("/plugins/servlet/status-handy/placeholder?name=" + HtmlUtil.urlEncode((String)map.get("name")) + "&backgroundColor=" + HtmlUtil.urlEncode((String)backgroundColor) + "&textColor=" + HtmlUtil.urlEncode((String)ColorHelper.getContrastColor(backgroundColor)) + "&width=" + txtWidth, false, new ImageDimensions(txtWidth, 30));
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    private String getHexColor(String color) {
        switch (color) {
            case "Gray": {
                return "#f5f5f5";
            }
            case "Red": {
                return "#d04437";
            }
            case "Green": {
                return "#14892c";
            }
            case "Blue": {
                return "#3572b0";
            }
            case "Yellow": {
                return "#f6c342";
            }
        }
        return "#ffffff";
    }
}

