/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.license.dao.impl;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.stiltsoft.confluence.handy.macros.license.dao.LicenseDao;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultLicenseDao
implements LicenseDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultLicenseDao.class);
    public static final String LICENSE_STORE_KEY = "com.atlassian.confluence.plugins.confluence-inline:build";
    private final BandanaManager bandanaManager;
    private final BandanaContext bandanaContext;
    private final CachedReference<Set<Integer>> licenseCache;

    public DefaultLicenseDao(BandanaManager bandanaManager, CacheManager cacheManager) {
        this.bandanaManager = bandanaManager;
        this.bandanaContext = new ConfluenceBandanaContext();
        this.licenseCache = cacheManager.getCachedReference(this.getClass().getName(), this::getAllLicensesFromStore, new CacheSettingsBuilder().remote().replicateViaCopy().maxEntries(20).build());
    }

    @Override
    public boolean isLicenseStored(String sen) {
        return this.getAllLicenses().contains(sen.hashCode());
    }

    @Override
    public void storeLicense(String sen) {
        Set<Integer> licenseCache = this.getAllLicenses();
        licenseCache.add(sen.hashCode());
        this.bandanaManager.setValue(this.bandanaContext, LICENSE_STORE_KEY, licenseCache);
    }

    @Override
    public int getEvalSenNumber() {
        return this.getAllLicenses().size();
    }

    private Set<Integer> getAllLicensesFromStore() {
        HashSet licenseStore = (HashSet)this.bandanaManager.getValue(this.bandanaContext, LICENSE_STORE_KEY);
        if (Objects.isNull(licenseStore)) {
            licenseStore = new HashSet();
            this.bandanaManager.setValue(this.bandanaContext, LICENSE_STORE_KEY, licenseStore);
        }
        return licenseStore;
    }

    private Set<Integer> getAllLicenses() {
        return (Set)this.licenseCache.get();
    }
}

