/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.license;

import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.google.common.base.Supplier;
import com.stiltsoft.confluence.handy.macros.license.LicenseInfo;
import com.stiltsoft.confluence.handy.macros.license.dao.LicenseDao;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LicenseManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseManager.class);
    private static final int EVAL_LICENSE_LIMIT = 7;
    private final LicenseService licenseService;
    private final PluginLicenseManager pluginLicenseManager;
    private final ConfluenceSidManager confluenceSidManager;
    private final LicenseDao licenseDao;

    public LicenseManager(LicenseService licenseService, PluginLicenseManager pluginLicenseManager, ConfluenceSidManager confluenceSidManager, LicenseDao licenseDao) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseService = licenseService;
        this.confluenceSidManager = confluenceSidManager;
        this.licenseDao = licenseDao;
    }

    private boolean isNoPluginLicense() {
        try {
            Option pluginLicenseOption = this.pluginLicenseManager.getLicense();
            if (pluginLicenseOption.isDefined() && !((PluginLicense)pluginLicenseOption.get()).getError().isDefined()) {
                return false;
            }
        }
        catch (Exception e) {
            log.error("Unable to get license", (Throwable)e);
        }
        return true;
    }

    public boolean isLicensedForDataCenter() {
        return this.licenseService.isLicensedForDataCenter();
    }

    public LicenseInfo getLicenseInfo() {
        String sid;
        try {
            sid = this.confluenceSidManager.getSid();
        }
        catch (ConfigurationException e) {
            return LicenseInfo.EMPTY;
        }
        String serverHash = DigestUtils.sha256Hex((String)sid);
        Option licenseOptional = this.pluginLicenseManager.getLicense();
        return (LicenseInfo)licenseOptional.map(license -> {
            Integer userCount = (Integer)license.getEdition().getOrElse((Object)-1);
            String licenseType = license.isEvaluation() ? "EVALUATION" : (String)Option.option((Object)license.getLicenseType()).map(Enum::name).getOrElse((Object)"NONE");
            return new LicenseInfo(serverHash, userCount, licenseType);
        }).getOrElse((java.util.function.Supplier)((Supplier)() -> new LicenseInfo(serverHash, null, "NONE")));
    }

    public boolean isActive() {
        int evalSenNumber;
        if (this.isNoPluginLicense()) {
            return false;
        }
        Option pluginLicenseOption = this.pluginLicenseManager.getLicense();
        PluginLicense license = (PluginLicense)pluginLicenseOption.get();
        boolean isEvaluation = license.isEvaluation();
        if (!isEvaluation) {
            return true;
        }
        Option senOption = license.getSupportEntitlementNumber();
        if (!senOption.isDefined()) {
            return false;
        }
        String sen = (String)senOption.get();
        if (!this.licenseDao.isLicenseStored(sen)) {
            this.licenseDao.storeLicense(sen);
        }
        return (evalSenNumber = this.licenseDao.getEvalSenNumber()) < 7;
    }

    public boolean isEvalLicense() {
        if (this.isNoPluginLicense()) {
            return false;
        }
        Option pluginLicenseOption = this.pluginLicenseManager.getLicense();
        PluginLicense license = (PluginLicense)pluginLicenseOption.get();
        return license.isEvaluation();
    }
}

