/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.event;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.stiltsoft.confluence.handy.macros.diff.PageDiffManager;
import com.stiltsoft.confluence.handy.macros.macro.reminder.ReminderMacroService;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroService;
import com.stiltsoft.confluence.handy.macros.macro.status.cache.PageReindexationCacheManager;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusMacroDto;
import com.stiltsoft.confluence.handy.macros.macro.status.impl.DefaultStatusLabelManager;
import com.stiltsoft.confluence.handy.macros.pagestatus.property.PageStatusPropertiesManager;
import com.stiltsoft.confluence.handy.macros.storage.StorageService;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class HandyEventListener
implements InitializingBean,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HandyEventListener.class);
    private final EventPublisher eventPublisher;
    private final PageDiffManager pageDiffManager;
    private final StorageService storageService;
    private final StatusMacroService statusMacroService;
    private final PageReindexationCacheManager cacheManager;
    private final ReminderMacroService reminderMacroService;
    private final PageStatusPropertiesManager propertiesManager;

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onPageCreateEvent(PageCreateEvent event) {
        this.onContentCreateEvent(event.getContent());
    }

    @EventListener
    public void onBlogPostCreateEvent(BlogPostCreateEvent event) {
        this.onContentCreateEvent(event.getContent());
    }

    @EventListener
    public void onCommentCreateEvent(CommentCreateEvent event) {
        this.onContentCreateEvent(event.getContent());
    }

    @EventListener
    public void onPageUpdateEvent(PageUpdateEvent event) {
        AbstractPage original = event.getOriginalPage();
        ContentEntityObject ceo = event.getContent();
        ConfluenceUser lastModifier = event.getNew().getLastModifier();
        this.onUpdateContent(original, ceo, lastModifier);
    }

    @EventListener
    public void onBlogPostUpdateEvent(BlogPostUpdateEvent event) {
        BlogPost original = event.getOriginalBlogPost();
        ContentEntityObject ceo = event.getContent();
        ConfluenceUser lastModifier = event.getNew().getLastModifier();
        this.onUpdateContent((AbstractPage)original, ceo, lastModifier);
    }

    @EventListener
    public void onCommentUpdateEvent(CommentUpdateEvent event) {
        ContentEntityObject ceo = event.getContent();
        ConfluenceUser lastModifier = event.getComment().getLastModifier();
        this.statusMacroService.publishStatusMacrosForUpdatedContent(ceo, lastModifier);
    }

    @EventListener
    public void onLabelAddEvent(LabelAddEvent event) {
        if (event.getLabelled() instanceof AbstractPage) {
            String label = event.getLabel().getName();
            ContentEntityObject page = (ContentEntityObject)event.getLabelled();
            this.update(page, label);
        }
    }

    private void onUpdateContent(AbstractPage original, ContentEntityObject ceo, ConfluenceUser lastModifier) {
        this.update(original);
        this.statusMacroService.publishStatusMacrosForUpdatedContent(ceo, lastModifier);
    }

    private void onContentCreateEvent(ContentEntityObject ceo) {
        this.statusMacroService.createStatusMacrosForCreatedContent(ceo);
        this.reminderMacroService.createReminderMacrosForCreatedContent(ceo);
        if (this.propertiesManager.isPageStatusPropertyExists(ceo.getId())) {
            this.propertiesManager.deletePageStatusProperties(ceo.getId());
        }
    }

    private void update(AbstractPage original) {
        if (original != null) {
            AbstractPage page = original.getLatestVersion();
            String confluenceUserKey = page.getLastModifier().getKey().getStringValue();
            this.pageDiffManager.setVersion(page.getId(), confluenceUserKey, page.getVersion());
            this.cacheManager.remove(page.getId());
        }
    }

    private void update(ContentEntityObject page, String label) {
        if (page.isDraft()) {
            return;
        }
        for (StackTraceElement traceElement : Thread.currentThread().getStackTrace()) {
            if (!traceElement.getClassName().equals(DefaultStatusLabelManager.class.getCanonicalName())) continue;
            return;
        }
        Map<String, Map<StatusMacroDto, List<Integer>>> idsMap = this.statusMacroService.updateLabelAndRefreshCache(page.getId(), label);
        for (Map.Entry<String, Map<StatusMacroDto, List<Integer>>> labelIds : idsMap.entrySet()) {
            for (Map.Entry<StatusMacroDto, List<Integer>> entry : labelIds.getValue().entrySet()) {
                for (Integer id : entry.getValue()) {
                    try {
                        this.storageService.updateStatusName(page.getId(), id, labelIds.getKey(), true);
                    }
                    catch (Exception e) {
                        log.error("Failed to update Handy Status on label change", (Throwable)e);
                    }
                }
            }
        }
    }

    @Generated
    public HandyEventListener(EventPublisher eventPublisher, PageDiffManager pageDiffManager, StorageService storageService, StatusMacroService statusMacroService, PageReindexationCacheManager cacheManager, ReminderMacroService reminderMacroService, PageStatusPropertiesManager propertiesManager) {
        this.eventPublisher = eventPublisher;
        this.pageDiffManager = pageDiffManager;
        this.storageService = storageService;
        this.statusMacroService = statusMacroService;
        this.cacheManager = cacheManager;
        this.reminderMacroService = reminderMacroService;
        this.propertiesManager = propertiesManager;
    }
}

