/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.diff.impl;

import com.stiltsoft.confluence.handy.macros.diff.PageDiffSettingsManager;
import com.stiltsoft.confluence.handy.macros.diff.dao.PageDiffSettingsDao;
import com.stiltsoft.confluence.handy.macros.util.ConfigLevels;
import org.springframework.stereotype.Component;

@Component
public class DefaultPageDiffSettingsManager
implements PageDiffSettingsManager {
    private final PageDiffSettingsDao pageDiffSettingsDao;

    public DefaultPageDiffSettingsManager(PageDiffSettingsDao pageDiffSettingsDao) {
        this.pageDiffSettingsDao = pageDiffSettingsDao;
    }

    @Override
    public boolean isEnabledGlobally() {
        return this.pageDiffSettingsDao.isEnabled("global");
    }

    @Override
    public boolean isEnabledForSpace(String spaceKey) {
        return this.pageDiffSettingsDao.isEnabled(ConfigLevels.getSpaceSettingsKey(spaceKey));
    }

    @Override
    public boolean isEnabledForUser(String confluenceUserKey) {
        return this.pageDiffSettingsDao.isEnabled(ConfigLevels.getPersonalSettingsKey(confluenceUserKey));
    }

    @Override
    public void setEnabled(String globalOrSpaceOrPersonal, boolean enabled) {
        this.pageDiffSettingsDao.setEnabled(globalOrSpaceOrPersonal, enabled);
    }
}

