/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.diff.impl;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.stiltsoft.confluence.handy.macros.diff.PageDiffManager;
import com.stiltsoft.confluence.handy.macros.diff.PageDiffService;
import com.stiltsoft.confluence.handy.macros.rest.diff.entity.PageContributorRestEntity;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DefaultPageDiffService
implements PageDiffService {
    private final PageManager pageManager;
    private final UserAccessor userAccessor;
    private final PageDiffManager pageDiffManager;

    public DefaultPageDiffService(PageManager pageManager, UserAccessor userAccessor, PageDiffManager pageDiffManager) {
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
        this.pageDiffManager = pageDiffManager;
    }

    @Override
    public int checkVersion(AbstractPage page, int userLastViewedPageVersion, ConfluenceUser user) {
        List descOrderSummaries;
        Optional<Integer> latestUserVersionNumberOptional;
        int currentVersion = page.getVersion();
        if (userLastViewedPageVersion > currentVersion) {
            this.pageDiffManager.setVersion(page.getId(), user.getKey().getStringValue(), currentVersion);
            return currentVersion;
        }
        if (userLastViewedPageVersion < currentVersion && (latestUserVersionNumberOptional = this.getLatestUserVersionNumber(descOrderSummaries = this.pageManager.getVersionHistorySummaries((ContentEntityObject)page), user)).isPresent()) {
            Integer latestUserVersionNumber = latestUserVersionNumberOptional.get();
            this.pageDiffManager.setVersion(page.getId(), user.getKey().getStringValue(), latestUserVersionNumber);
            return latestUserVersionNumber;
        }
        return userLastViewedPageVersion;
    }

    @Override
    public List<PageContributorRestEntity> getPageContributors(long contentId, int sinceVersion) {
        return Optional.ofNullable(this.pageManager.getAbstractPage(contentId)).map(arg_0 -> ((PageManager)this.pageManager).getVersionHistorySummaries(arg_0)).map(summaries -> this.getPageContributorsFromSummaries(sinceVersion, (List<VersionHistorySummary>)summaries)).orElseGet(Collections::emptyList);
    }

    private List<PageContributorRestEntity> getPageContributorsFromSummaries(int sinceVersion, List<VersionHistorySummary> summaries) {
        HashMap userByKey = new HashMap();
        HashMap changesCountByUserKey = new HashMap();
        summaries.stream().filter(versionHistorySummary -> versionHistorySummary.getVersion() > sinceVersion).map(VersionHistorySummary::getContributorSet).forEach(confluenceUsers -> confluenceUsers.forEach(user -> {
            UserKey userKey = user.getKey();
            userByKey.putIfAbsent(userKey, user);
            changesCountByUserKey.put(userKey, changesCountByUserKey.getOrDefault(userKey, 0) + 1);
        }));
        return userByKey.entrySet().stream().map(entry -> {
            int changesCount = changesCountByUserKey.getOrDefault(entry.getKey(), 1);
            String avatarUrl = this.userAccessor.getUserProfilePicture((User)entry.getValue()).getUriReference();
            return new PageContributorRestEntity((ConfluenceUser)entry.getValue(), avatarUrl, changesCount);
        }).sorted().collect(Collectors.toList());
    }

    private Optional<Integer> getLatestUserVersionNumber(List<VersionHistorySummary> summaries, ConfluenceUser user) {
        return summaries.stream().filter(summary -> summary.getContributorSet().contains(user)).max(Comparator.comparingInt(VersionHistorySummary::getVersion)).map(VersionHistorySummary::getVersion);
    }
}

