/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.diff.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.stiltsoft.confluence.handy.macros.diff.dao.PageDiffSettingsDao;
import com.stiltsoft.confluence.handy.macros.diff.dao.activeobjects.PageDiffSettingsEntity;
import java.util.Optional;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.springframework.stereotype.Component;

@Component
public class DefaultPageDiffSettingsDao
implements PageDiffSettingsDao {
    private final ActiveObjects ao;
    private final Cache<String, Boolean> cache;

    public DefaultPageDiffSettingsDao(ActiveObjects ao, CacheManager cacheManager) {
        this.ao = ao;
        this.cache = cacheManager.getCache(this.getClass().getName());
    }

    @Override
    public boolean isEnabled(String owner) {
        return this.getValueOrTrue(owner);
    }

    @Override
    public void setEnabled(String owner, boolean enabled) {
        this.setValue(owner, enabled);
    }

    public boolean getValueOrTrue(String key) {
        if (this.isCached(key)) {
            return this.getFromCacheOrTrue(key);
        }
        boolean value = this.findAndGetOrTrue(key);
        this.cache.put((Object)key, (Object)value);
        return value;
    }

    public void setValue(String key, boolean value) {
        PageDiffSettingsEntity entity = this.findOrCreateNewEntity(key);
        entity.setEnabled(value);
        entity.save();
        this.cache.put((Object)key, (Object)value);
    }

    private boolean findAndGetOrTrue(String key) {
        return this.find(key).map(PageDiffSettingsEntity::getEnabled).orElse(true);
    }

    private PageDiffSettingsEntity findOrCreateNewEntity(String key) {
        return this.find(key).orElseGet(() -> {
            PageDiffSettingsEntity newEntity = (PageDiffSettingsEntity)this.ao.create(PageDiffSettingsEntity.class, new DBParam[0]);
            newEntity.setOwner(key);
            return newEntity;
        });
    }

    private Optional<PageDiffSettingsEntity> find(String key) {
        Query query = Query.select().where("OWNER = ?", new Object[]{key}).limit(1);
        PageDiffSettingsEntity[] result = (PageDiffSettingsEntity[])this.ao.find(PageDiffSettingsEntity.class, query);
        return result.length == 0 ? Optional.empty() : Optional.of(result[0]);
    }

    private boolean isCached(String key) {
        return this.cache.containsKey((Object)key);
    }

    private boolean getFromCacheOrTrue(String key) {
        return Optional.ofNullable((Boolean)this.cache.get((Object)key)).orElse(true);
    }
}

