/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.diff.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.handy.macros.diff.dao.PageDiffDao;
import com.stiltsoft.confluence.handy.macros.diff.dao.activeobjects.PageDiffEntity;
import java.util.Arrays;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.springframework.stereotype.Component;

@Component
public class DefaultPageDiffDao
implements PageDiffDao {
    private final ActiveObjects ao;

    public DefaultPageDiffDao(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public Integer getVersion(Long pageId, String userKey) {
        List<PageDiffEntity> entities = this.find(pageId, userKey);
        if (entities.isEmpty()) {
            return -1;
        }
        return entities.get(0).getPageVersion();
    }

    @Override
    public void setVersion(Long pageId, String userKey, Integer version) {
        List<PageDiffEntity> entities = this.find(pageId, userKey);
        PageDiffEntity entity = entities.isEmpty() ? (PageDiffEntity)this.ao.create(PageDiffEntity.class, new DBParam[]{new DBParam("USER_KEY", (Object)userKey), new DBParam("PAGE_ID", (Object)pageId)}) : entities.get(0);
        entity.setPageVersion(version);
        entity.save();
    }

    private List<PageDiffEntity> find(Long pageId, String userKey) {
        return Arrays.asList((PageDiffEntity[])this.ao.find(PageDiffEntity.class, Query.select().where("PAGE_ID = ? AND USER_KEY = ?", new Object[]{pageId, userKey})));
    }
}

