/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.diff.condition;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.user.ConfluenceUser;
import com.stiltsoft.confluence.handy.macros.diff.PageDiffManager;
import com.stiltsoft.confluence.handy.macros.diff.PageDiffService;
import com.stiltsoft.confluence.handy.macros.diff.PageDiffSettingsManager;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;

public class PageDiffViewCondition
extends BaseConfluenceCondition {
    private final LicenseManager licenseManager;
    private final PageDiffManager pageDiffManager;
    private final PageDiffService pageDiffService;
    private final PageDiffSettingsManager pageDiffSettingsManager;

    public PageDiffViewCondition(LicenseManager licenseManager, PageDiffManager pageDiffManager, PageDiffService pageDiffService, PageDiffSettingsManager pageDiffSettingsManager) {
        this.licenseManager = licenseManager;
        this.pageDiffManager = pageDiffManager;
        this.pageDiffService = pageDiffService;
        this.pageDiffSettingsManager = pageDiffSettingsManager;
    }

    public boolean shouldDisplay(WebInterfaceContext context) {
        ConfluenceUser user = context.getCurrentUser();
        if (user == null) {
            return false;
        }
        if (!this.licenseManager.isActive()) {
            return false;
        }
        String userKey = user.getKey().getStringValue();
        String spaceKey = context.getSpace().getKey();
        if (!(this.pageDiffSettingsManager.isEnabledGlobally() && this.pageDiffSettingsManager.isEnabledForSpace(spaceKey) && this.pageDiffSettingsManager.isEnabledForUser(userKey))) {
            return false;
        }
        AbstractPage page = context.getPage();
        Integer version = this.pageDiffManager.getVersion(page.getId(), userKey);
        if (version == -1) {
            version = page.getVersion();
            this.pageDiffManager.setVersion(page.getId(), userKey, version);
        } else {
            version = this.pageDiffService.checkVersion(page, version, user);
        }
        return page.isLatestVersion() && version.intValue() != page.getVersion();
    }
}

