/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.diff.condition;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.stiltsoft.confluence.handy.macros.diff.PageDiffManager;
import com.stiltsoft.confluence.handy.macros.diff.PageDiffSettingsManager;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;

public class PageDiffHistoryPageCondition
extends BaseConfluenceCondition {
    private final LicenseManager licenseManager;
    private final PageDiffManager pageDiffManager;
    private final PageDiffSettingsManager pageDiffSettingsManager;

    public PageDiffHistoryPageCondition(LicenseManager licenseManager, PageDiffManager pageDiffManager, PageDiffSettingsManager pageDiffSettingsManager) {
        this.licenseManager = licenseManager;
        this.pageDiffManager = pageDiffManager;
        this.pageDiffSettingsManager = pageDiffSettingsManager;
    }

    public boolean shouldDisplay(WebInterfaceContext context) {
        Object param = ServletContextThreadLocal.getRequest().getParameterMap().get("handyDiff");
        if (param == null) {
            return false;
        }
        if (!this.licenseManager.isActive()) {
            return false;
        }
        String spaceKey = context.getSpace().getKey();
        String userKey = context.getCurrentUser().getKey().getStringValue();
        if (!(this.pageDiffSettingsManager.isEnabledGlobally() && this.pageDiffSettingsManager.isEnabledForSpace(spaceKey) && this.pageDiffSettingsManager.isEnabledForUser(userKey))) {
            return false;
        }
        Long pageId = Long.valueOf(((String[])param)[0]);
        Integer version = this.pageDiffManager.getVersion(pageId, userKey);
        param = ServletContextThreadLocal.getRequest().getParameterMap().get("selectedPageVersions");
        if (param == null) {
            return false;
        }
        Integer diffVersion1 = Integer.valueOf(((String[])param)[0]);
        Integer diffVersion2 = Integer.valueOf(((String[])param)[1]);
        return diffVersion1.equals(version) && diffVersion2 > version || diffVersion2.equals(version) && diffVersion1 > version;
    }
}

