/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.condition;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.pagestatus.PageStatusSettingsManager;
import com.stiltsoft.confluence.handy.macros.pagestatus.property.PageStatusPropertiesManager;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import java.util.Objects;
import lombok.Generated;

public class PageStatusCondition
extends BaseConfluenceCondition {
    private final LicenseManager licenseManager;
    private final PageStatusSettingsManager pageStatusSettingsManager;
    private final HandyPermissionService handyPermissionService;
    private final PageStatusPropertiesManager pageStatusPropertiesManager;

    protected boolean shouldDisplay(WebInterfaceContext context) {
        ConfluenceUser user = context.getCurrentUser();
        if (user == null) {
            return false;
        }
        if (!this.pageStatusSettingsManager.getPageStatusEnabled().orElse(true).booleanValue()) {
            return false;
        }
        AbstractPage page = context.getPage();
        if (Objects.isNull(page)) {
            return false;
        }
        return this.hasActiveLicenseAndEditPermission(user, page) || this.hasPageStatusProperty(page);
    }

    private boolean hasPageStatusProperty(AbstractPage page) {
        Objects.requireNonNull(page);
        return this.pageStatusPropertiesManager.isPageStatusPropertyExists(page.getId());
    }

    private boolean hasActiveLicenseAndEditPermission(ConfluenceUser user, AbstractPage page) {
        return this.licenseManager.isActive() && this.handyPermissionService.hasEntityEditPermission((User)user, (ContentEntityObject)page);
    }

    @Generated
    public PageStatusCondition(LicenseManager licenseManager, PageStatusSettingsManager pageStatusSettingsManager, HandyPermissionService handyPermissionService, PageStatusPropertiesManager pageStatusPropertiesManager) {
        this.licenseManager = licenseManager;
        this.pageStatusSettingsManager = pageStatusSettingsManager;
        this.handyPermissionService = handyPermissionService;
        this.pageStatusPropertiesManager = pageStatusPropertiesManager;
    }
}

