/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.action;

import com.atlassian.confluence.user.ConfluenceUser;
import com.stiltsoft.confluence.handy.macros.action.AbstractSettingsAction;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetManager;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusSetDto;
import java.util.List;

public class UserSettingsAction
extends AbstractSettingsAction {
    private StatusSetManager statusSetManager;

    @Override
    public String getOwnerType() {
        return "user:";
    }

    @Override
    public boolean isDiffAvailable() {
        return this.pageDiffSettingsManager.isEnabledGlobally();
    }

    @Override
    public boolean isHeaderAvailable() {
        return this.handyHeaderSettingsService.isEnabled("global");
    }

    @Override
    public boolean isTasksAvailable() {
        return this.handyTasksSettingsService.isEnabled("global");
    }

    @Override
    public boolean isPageStatusAvailable() {
        return false;
    }

    @Override
    public String getOwner() {
        return this.getOwnerType() + this.getAuthenticatedUser().getKey().getStringValue();
    }

    @Override
    public List<StatusSetDto> getStatusSets() {
        String authenticatedUserKey = this.getAuthenticatedUserKey();
        return this.statusSetManager.getPersonalStatusSets(authenticatedUserKey);
    }

    @Override
    public boolean getPageDiffEnabled() {
        String confluenceUserKey = this.getAuthenticatedUser().getKey().getStringValue();
        return this.pageDiffSettingsManager.isEnabledForUser(confluenceUserKey);
    }

    public void setStatusSetManager(StatusSetManager statusSetManager) {
        this.statusSetManager = statusSetManager;
    }

    private String getAuthenticatedUserKey() {
        ConfluenceUser authenticatedUser = this.getAuthenticatedUser();
        return authenticatedUser.getKey().getStringValue();
    }
}

