define('com/ehpFreeDefaults/plugins', ['ajs', 'jquery'], function (AJS, $){
    "use strict";

    function updateFreeParameters(oldParams, proParas) {
        var freeParams = $.extend({}, oldParams);

        // Special handle for difference between free and pro versions
        if (proParas.expandCollapseOption == "expand-all") proParas.expandCollapseOption = "expand-all-by-default";
        if (proParas.expandCollapseOption == "collapse-all") proParas.expandCollapseOption = "collapse-all-by-default";
        if (proParas.expandCollapseOption == "no-expand-collapse") proParas.expandCollapseOption = "disable-expand-collapse";

        if (proParas.expandCollapseNavOption == "expand-all") proParas.expandCollapseNavOption = "expand-all-by-default";
        if (proParas.expandCollapseNavOption == "collapse-all") proParas.expandCollapseNavOption = "collapse-all-by-default";
        if (proParas.expandCollapseNavOption == "no-expand-collapse") proParas.expandCollapseNavOption = "disable-expand-collapse";

        freeParams.selector = proParas.selector;
        freeParams.headingIndent = proParas.headingIndent;
        freeParams.expandOption = proParas.expandCollapseOption;
        freeParams.titleExpandClickable = proParas.titleExpandClickable;
        freeParams.useNavigation = proParas.useNavigation;
        freeParams.useNavigationHiddenMode = proParas.navigationMode == "right-popup";
        freeParams.wrapNavigationText = proParas.wrapNavigationText;
        freeParams.navigationTitle = proParas.navigationTitle;
        freeParams.navigationTop = proParas.navigationTop;
        freeParams.navigationWidth = proParas.navigationWidth;
        freeParams.navigationIndent = proParas.navigationIndent;
        freeParams.disableNavLinksUnder = proParas.disableNavLinksUnder;
        freeParams.navigationExpandOption = proParas.expandCollapseNavOption;
        freeParams.labelsAppDisabled = proParas.labelsAppDisabled;
        freeParams.macrosAppDisabled = proParas.macrosAppDisabled;
        freeParams.macrosTOCDisabled = proParas.macrosTOCDisabled;

        // Set flag to indicate the macro has been edited once
        freeParams.hiddenEditedFlag = "true";

        return freeParams;
    }

    function convertParamValueToString(parameters) {
        for (var paramName in parameters) {
            parameters[paramName] = String(parameters[paramName]);
        }
        return parameters;
    }

    // Common
    function showMessage(type, message) {
        AJS.flag({
            type: type,
            body: message,
            close: "auto"
        });
    }

    return {
        init : function(ed) {
            AJS.bind("macro-browser.macro-inserted", function(a,b){

                console.log("pro event macro-browser.macro-inserted");
                var currentNode = tinymce.confluence.macrobrowser.getCurrentNode();
                var macroNode = currentNode.find("[data-macro-name='easy-heading-free']");
                if (macroNode.length == 0) {
                    return;
                }

                var paramsText = macroNode.attr("data-macro-parameters") || "";
                var params = Confluence.MacroParameterSerializer.deserialize(paramsText);
                if (params.hiddenEditedFlag == "true") {
                    return;
                }

                // Apply pro defaults to the macro
                var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/page-editor-parameter";
                var data = {
                    action: "getSpaceSettings",
                    spaceKey: AJS.params.spaceKey
                };

                $.ajax({
                    url: url,
                    type: "GET",
                    data: data,
                    success: function (data, textStatus, XMLHttpRequest) {
                        var freeParams = convertParamValueToString(updateFreeParameters(params, data));
                        var updatedParamsText = Confluence.MacroParameterSerializer.serialize(freeParams);
                        macroNode.attr("data-macro-parameters", updatedParamsText);
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        showMessage("error", jqXHR.responseText);
                    }
                });

            });

        },
        getInfo : function() {
            //console.log("tinymce version: " + tinymce.majorVersion + "." + tinymce.minorVersion);
            return {
                longname : 'ehpNavigationView',
                author : 'Shinetech Software',
                authorurl : 'https://www.shinetechsoftware.com',
                version : tinymce.majorVersion + "." + tinymce.minorVersion
            };
        }
    }
});

require('confluence/module-exporter')
    .safeRequire('com/ehpFreeDefaults/plugins', function(MyPlugin) {
        var tinymce = require('tinymce');
        //console.log("> tinymce version: " + tinymce.majorVersion + "." + tinymce.minorVersion);
        tinymce.create('tinymce.plugins.ehpFreeDefaults', MyPlugin);

        // Register plugin
        tinymce.PluginManager.add('ehpFreeDefaults', tinymce.plugins.ehpFreeDefaults);
        require('confluence-editor/loader/tinymce-bootstrap').addTinyMcePluginInit(function(settings) {
            settings.plugins += ",ehpFreeDefaults";
        });
    });
