AJS.toInit(function ($){
    var ACTION_GET_DEFAULT_SETTING = "default";
    var ACTION_GET_STYLE_TEMPLATE = "template";
    var ACTION_UPDATE_SETTING_FOR_DISPLAY = "update-setting-display";
    var ACTION_UPDATE_SETTING_FOR_EDITOR = "update-setting-editor";
    var ACTION_UPDATE_SETTING_FOR_STYLE = "update-setting-style";
    var ACTION_ENABLE_SETTING = "enable";
    var ACTION_ENABLE_FOR_HOME_SETTING = "enable-for-home";
    var ACTION_GET_DEACTIVATION_SEARCH = "deactivation-search";
    var ACTION_GET_ALL_DEACTIVATION = "deactivation-get-all";
    var ACTION_UPDATE_DEACTIVATE_CONTENT = "deactivate-content";

    var SELECTOR_PREVIEW_NAV = "#ehp-navigation-wrapper-preview";
    var navInitialTop;
    var navInitialLeft;

    init();

    function init() {
        AJS.tabs.setup();

        // Toggle to enable/disable macro for current space
        var toggle = document.getElementById("ehp-toggleEnableForSpace");

        // This element is not available if global setting is enabled
        if (!toggle) {
            return;
        }

        toggle.addEventListener("change", function(e) {
            e.preventDefault();
            toggleEnabled();
        });

        // Toggle to enable/disable macro for homepage of current space
        var toggleForSpaceHome = document.getElementById("ehp-toggleEnableForSpaceHome");
        toggleForSpaceHome.addEventListener("change", function(e) {
            e.preventDefault();
            toggleEnabledForSpaceHome();
        });

        setupEditForm();
        setupDeactivatePages();
    }

    function setupEditForm() {
        AJS.$('#ehp-formSettings').on('aui-valid-submit', function(event) {
            event.preventDefault();
            updateSettingForDisplay();
        });
        AJS.$('#ehp-formSettings-editor').on('aui-valid-submit', function(event) {
            event.preventDefault();
            updateSettingForEditor();
        });
        AJS.$('#ehp-formSettings-style').on('aui-valid-submit', function(event) {
            event.preventDefault();
            updateSettingForStyle();
        });

        $("#ehp-buttonResetSetting").off("click").on("click", function(e) {
            e.preventDefault();
            // Load default values without saving
            resetSettingForDisplay();
        });
        $("#ehp-buttonResetSettingEditor").off("click").on("click", function(e) {
            e.preventDefault();
            // Load default values without saving
            resetSettingForEditor();
        });
        $("#ehp-buttonResetStyle").off("click").on("click", function(e) {
            e.preventDefault();
            // Load default values without saving
            resetStyle();
        });

        $(".aui-tabs").on("tabSelect", function(e){
            e.preventDefault();

            if (e.target.href.indexOf("#tab-settings-style") > 0) {
                if ($("head>#ehp-style").length == 0) {
                    $("head").append('<style id="ehp-style" type="text/css"></style>');
                    refreshStyle();
                }
                setupPreview();
            }
        });


        $("#ehp-navigation-refresh").off("click").on("click", function(e) {
            e.preventDefault();
            refreshStyle();
        });
        $("#ehp-navigation-refresh").hover(function(event) {
            $(this).toggleClass("nav-refresh-hover", true).toggleClass("nav-refresh", false);
        }, function(event) {
            $(this).toggleClass("nav-refresh", true).toggleClass("nav-refresh-hover", false);
        });

        // set up color pickers
        $(".ehp-color").each(function(){
            $(this).css("background-color", $(this).val());
            var picker = new CP(this);
            picker.on("drag", function(v){
                this.source.value = "#" + v;
                $(this.source).css("background-color", "#" + v);
            })
        });
        $(".ehp-color").change(function(){
            $(this).css("background-color", $(this).val());
        });
    }

    function setupPreview() {
        // Get top and left offsets of the navigation
        $(SELECTOR_PREVIEW_NAV).show();
        var navMarginLeft = Number($(SELECTOR_PREVIEW_NAV).css("margin-left").replace("px", ""));
        navInitialTop = $(SELECTOR_PREVIEW_NAV).offset().top;
        // navInitialLeft = $(SELECTOR_PREVIEW_NAV).offset().left - navMarginLeft;
        navInitialLeft = $("#ehp-formSettings-style").offset().left + $("#ehp-formSettings-style").outerWidth();

        updateNavigationPosition();
        $(document).scroll(function(){
            updateNavigationPosition();
        });

        // Bind expand/collapse event
        $("#ehp-navigation-list").find(".nav-arrow").click(function(event){
            event.preventDefault();
            $(this).toggleClass("fa-chevron-right").toggleClass("fa-chevron-down");
            $(this).parent().next(".nav-expand-body").toggle();

            updateNavigationPosition();
        });
        $("#ehp-navigation-list").find(".nav-arrow-hover, .nav-arrow").hover(function() {
            $(this).toggleClass("nav-arrow-hover", true).toggleClass("nav-arrow", false);
        }, function() {
            $(this).toggleClass("nav-arrow-hover", false).toggleClass("nav-arrow", true);
        });

        // Hover on the switcher button
        $("#ehp-navigation-switcher").hover(function(event) {
            $(this).toggleClass("nav-switcher-hover", true).toggleClass("nav-switcher", false);
        }, function(event) {
            $(this).toggleClass("nav-switcher", true).toggleClass("nav-switcher-hover", false);
        });

        // Allow user to load style from system templates
        $("#ehp-selectTemplate").on("change", function(e){
            e.preventDefault();
            if (this.value == "none") return;
            loadStyleTemplate(this.value);
        });
    }

    function setupDeactivatePages() {
        AJS.$('#ehp-form-deactivation-search').on('aui-valid-submit', function(event) {
            event.preventDefault();
            searchDeactivationPages();
        });

        $("#ehp-linkLoadDeactivatedPages").off("click").on("click", function(e){
            event.preventDefault();
            $(this).hide();
            $("#ehp-deactivation-load-all-panel").show();

            loadDeactivatedPages();
        });

        $("#ehp-linkRefreshDeactivatedPages").off("click").on("click", function(e){
            event.preventDefault();
            loadDeactivatedPages();
        });
    }

    function bindEventsForDeactivationButtons() {
        $(".ehp-linkReactivate,.ehp-linkDeactivate").off("click").on("click", function(e){
            e.preventDefault();

            var button = $(this);
            var contentId = Number(button.parent().find(".hid-search-content-id").val());
            var beingDeactivated = $(this).hasClass("ehp-linkDeactivate");
            var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/space-setting";

            var data = {
                action: ACTION_UPDATE_DEACTIVATE_CONTENT,
                spaceId: Number($("#ehp-hidSpaceId").val()),
                contentId: contentId,
                beingDeactivated: beingDeactivated
            };

            $.ajax({
                url: url,
                type: "POST",
                contentType: "application/json; charset=utf-8",
                data: JSON.stringify(data),
                processData: false,
                success: function (data, textStatus, XMLHttpRequest) {
                    button.toggleClass("ehp-linkReactivate", data.deactivated);
                    button.toggleClass("aui-button-primary", !data.deactivated);
                    button.toggleClass("ehp-linkDeactivate", !data.deactivated);
                    button.text(data.deactivated ? "Reactivate" : "Deactivate");
                    button.parent().parent().find("td:eq(3)").text(data.deactivated ? "Inactive" : "Active");
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    showMessage("error", jqXHR.responseText);
                }
            });
        });
    }

    function searchDeactivationPages() {
        var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/space-setting";
        var title = $("#search-title").val();
        var data = {
            action: ACTION_GET_DEACTIVATION_SEARCH,
            spaceId: Number($("#ehp-hidSpaceId").val()),
            title: title
        };

        $.ajax({
            url: url,
            type: "GET",
            data: data,
            success: function (data, textStatus, XMLHttpRequest) {
                $("#ehp-deactivation-search-result-container").empty().append(data);
                bindEventsForDeactivationButtons();
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function loadDeactivatedPages() {
            var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/space-setting";
            var spaceKey = $("#ehp-deactivation-sel-space").val();
            var data = {
                action: ACTION_GET_ALL_DEACTIVATION,
                spaceId: Number($("#ehp-hidSpaceId").val()),
            };

            $.ajax({
                url: url,
                type: "GET",
                data: data,
                success: function (data, textStatus, XMLHttpRequest) {
                    $("#ehp-deactivation-load-all-container").empty().append(data);
                    bindEventsForDeactivationButtons();
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    showMessage("error", jqXHR.responseText);
                }
            });
        }

    function updateNavigationPosition() {
        let marginTop = $("#ehp-formSettings-style").offset().top - $(window).scrollTop();
        if (marginTop < 100) {
            $(SELECTOR_PREVIEW_NAV).toggleClass("nav-sticky", true)
                .css("left", navInitialLeft + "px")
                .css("top", 100 + "px");
        } else {
            $(SELECTOR_PREVIEW_NAV).toggleClass("nav-sticky", false)
        }
    }

    function toggleEnabled() {
        var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/space-setting";
        var toggle = document.getElementById("ehp-toggleEnableForSpace");
        var enabled = toggle.checked;
        var data = {
            action: ACTION_ENABLE_SETTING,
            spaceId: Number($("#ehp-hidSpaceId").val()),
            enabled: enabled
        };

        $.ajax({
            url: url,
            type: "POST",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            processData: false,
            success: function (data, textStatus, XMLHttpRequest) {
                if (data.enabled) {
                    showMessage("success", AJS.I18n.getText("com.shineatlas.confluence.headingpro.space.admin.success-message.setting-enabled"));
                } else {
                    showMessage("success", AJS.I18n.getText("com.shineatlas.confluence.headingpro.space.admin.success-message.setting-disabled"));
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function toggleEnabledForSpaceHome() {
        var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/space-setting";
        var toggle = document.getElementById("ehp-toggleEnableForSpaceHome");
        var enabled = toggle.checked;
        var data = {
            action: ACTION_ENABLE_FOR_HOME_SETTING,
            spaceId: Number($("#ehp-hidSpaceId").val()),
            enabledForSpaceHome: enabled
        };

        $.ajax({
            url: url,
            type: "POST",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            processData: false,
            success: function (data, textStatus, XMLHttpRequest) {
                if (enabled) {
                    showMessage("success", AJS.I18n.getText("com.shineatlas.confluence.headingpro.space.admin.success-message.setting-enabled-for-home"));
                } else {
                    showMessage("success", AJS.I18n.getText("com.shineatlas.confluence.headingpro.space.admin.success-message.setting-disabled-for-home"));
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function updateSettingForDisplay() {
        var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/space-setting";
        var data = {
            action: ACTION_UPDATE_SETTING_FOR_DISPLAY,
            spaceId: Number($("#ehp-hidSpaceId").val()),
            selector: $("#field-selector").val(),
            headingIndent: Number($("#field-headingIndent").val()),
            numberOption: $("#field-numberOption").val(),
            expandCollapseOption: $("#field-expandCollapseOption").val(),
            titleExpandClickable: $("#field-titleExpandClickable").is(":checked"),
            useNavigation: $("#field-useNavigation").is(":checked"),
            navigationMode: $("#field-navigationMode").val(),
            wrapNavigationText: $("#field-wrapNavigationText").is(":checked"),
            navigationTitle: $("#field-navigationTitle").val(),
            navigationTop: Number($("#field-navigationTop").val()),
            navigationWidth: Number($("#field-navigationWidth").val()),
            navigationIndent: Number($("#field-navigationIndent").val()),
            disableNavLinksUnder: Number($("#field-disableNavLinksUnder").val()),
            expandCollapseNavOption: $("#field-expandCollapseNavOption").val(),
            labelsAppDisabled: $("#field-labelsAppDisabled").val(),
            macrosAppDisabled: $("#field-macrosAppDisabled").val(),
            macrosTOCDisabled: $("#field-macrosTOCDisabled").val()
        };

        $.ajax({
            url: url,
            type: "POST",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            processData: false,
            success: function (data, textStatus, XMLHttpRequest) {
                loadSettingForDisplay(data);
                showMessage("success", AJS.I18n.getText("com.shineatlas.confluence.headingpro.space.admin.success-message.setting-display-updated"));
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function updateSettingForEditor() {
        var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/space-setting";
        var data = {
            action: ACTION_UPDATE_SETTING_FOR_EDITOR,
            spaceId: Number($("#ehp-hidSpaceId").val()),
            navigationEditMode: $("#field-navigationEditMode").val()
        };

        $.ajax({
            url: url,
            type: "POST",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            processData: false,
            success: function (data, textStatus, XMLHttpRequest) {
                loadSettingForEditor(data);
                showMessage("success", AJS.I18n.getText("com.shineatlas.confluence.headingpro.space.admin.success-message.setting-editor-updated"));
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function updateSettingForStyle() {
        var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/space-setting";
        var data = {
            action: ACTION_UPDATE_SETTING_FOR_STYLE,
            spaceId: Number($("#ehp-hidSpaceId").val()),
            navBackgroundColor: $("#field-navBackgroundColor").val(),
            navOpacity: Number($("#field-navOpacity").val()),
            navBorderWidth: Number($("#field-navBorderWidth").val()),
            navBorderRadius: Number($("#field-navBorderRadius").val()),
            navBorderStyle: $("#field-navBorderStyle").val(),
            navBorderColor: $("#field-navBorderColor").val(),
            navPadding: $("#field-navPadding").val(),
            navTitleBackgroundColor: $("#field-navTitleBackgroundColor").val(),
            navTitleColor: $("#field-navTitleColor").val(),
            navTitleFontSize: Number($("#field-navTitleFontSize").val()),
            navTitleFontWeight: $("#field-navTitleFontWeight").val(),
            navLinkColor: $("#field-navLinkColor").val(),
            navLinkFontSize: Number($("#field-navLinkFontSize").val()),
            navLinkFontWeight: $("#field-navLinkFontWeight").val(),
            navLinkDecoration: $("#field-navLinkDecoration").val(),
            navLinkDecorationColor: $("#field-navLinkDecorationColor").val(),
            navLinkHoverColor: $("#field-navLinkHoverColor").val(),
            navLinkHoverDecoration: $("#field-navLinkHoverDecoration").val(),
            navLinkHoverDecorationColor: $("#field-navLinkHoverDecorationColor").val(),
            navLinkHighlightColor: $("#field-navLinkHighlightColor").val(),
            navLinkHighlightFontWeight: $("#field-navLinkHighlightFontWeight").val(),
            navLinkHighlightDecoration: $("#field-navLinkHighlightDecoration").val(),
            navLinkHighlightDecorationColor: $("#field-navLinkHighlightDecorationColor").val(),
            navExpandButtonColor: $("#field-navExpandButtonColor").val(),
            navExpandButtonHoverColor: $("#field-navExpandButtonHoverColor").val(),
            navSwitcherButtonColor: $("#field-navSwitcherButtonColor").val(),
            navSwitcherButtonHoverColor: $("#field-navSwitcherButtonHoverColor").val(),
            useCustomColors: $("#field-useCustomColors").val() == "true"
        };

        $.ajax({
            url: url,
            type: "POST",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            processData: false,
            success: function (data, textStatus, XMLHttpRequest) {
                loadStyle(data);
                showMessage("success", AJS.I18n.getText("com.shineatlas.confluence.headingpro.space.admin.success-message.style-updated"));
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function resetSettingForDisplay() {
        var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/space-setting";
        var data = {
            action: ACTION_GET_DEFAULT_SETTING,
            spaceId: Number($("#ehp-hidSpaceId").val())
        };

        $.ajax({
            url: url,
            type: "GET",
            data: data,
            success: function (data, textStatus, XMLHttpRequest) {
                loadSettingForDisplay(data);

                // This is to remove the previous validation errors
                $("#ehp-formSettings").find("input,select").trigger("change");
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function resetSettingForEditor() {
        var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/space-setting";
        var data = {
            action: ACTION_GET_DEFAULT_SETTING,
            spaceId: Number($("#ehp-hidSpaceId").val())
        };

        $.ajax({
            url: url,
            type: "GET",
            data: data,
            success: function (data, textStatus, XMLHttpRequest) {
                loadSettingForEditor(data);

                // This is to remove the previous validation errors
                $("#ehp-formSettings-editor").find("input,select").trigger("change");
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function resetStyle() {
        var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/space-setting";
        var data = {
            action: ACTION_GET_DEFAULT_SETTING,
            spaceId: Number($("#ehp-hidSpaceId").val())
        };

        $.ajax({
            url: url,
            type: "GET",
            data: data,
            success: function (data, textStatus, XMLHttpRequest) {
                loadStyle(data);
                refreshStyle();
                $("#ehp-selectTemplate").val("none");

                // This is to remove the previous validation errors
                $("#ehp-formSettings-style").find("input,select").trigger("change");
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function loadStyleTemplate(templateName) {
        var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/space-setting";
        var data = {
            action: ACTION_GET_STYLE_TEMPLATE,
            spaceId: Number($("#ehp-hidSpaceId").val()),
            template: templateName
        };

        $.ajax({
            url: url,
            type: "GET",
            data: data,
            success: function (data, textStatus, XMLHttpRequest) {
                loadStyle(data);
                refreshStyle();

                // This is to remove the previous validation errors
                $("#ehp-formSettings-style").find("input,select").trigger("change");
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function refreshStyle() {
        var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/style";
        var data = {
            selector: $("#field-selector").val(),
            headingIndent: Number($("#field-headingIndent").val()),
            numberOption: $("#field-numberOption").val(),
            expandCollapseOption: $("#field-expandCollapseOption").val(),
            titleExpandClickable: $("#field-titleExpandClickable").is(":checked"),
            useNavigation: $("#field-useNavigation").is(":checked"),
            navigationMode: $("#field-navigationMode").val(),
            wrapNavigationText: $("#field-wrapNavigationText").is(":checked"),
            navigationTitle: $("#field-navigationTitle").val(),
            navigationTop: Number($("#field-navigationTop").val()),
            navigationWidth: Number($("#field-navigationWidth").val()),
            navigationIndent: Number($("#field-navigationIndent").val()),
            disableNavLinksUnder: Number($("#field-disableNavLinksUnder").val()),
            expandCollapseNavOption: $("#field-expandCollapseNavOption").val(),
            labelsAppDisabled: $("#field-labelsAppDisabled").val(),
            macrosAppDisabled: $("#field-macrosAppDisabled").val(),
            macrosTOCDisabled: $("#field-macrosTOCDisabled").val(),
            navigationEditMode: $("#field-navigationEditMode").val(),
            navBackgroundColor: $("#field-navBackgroundColor").val(),
            navOpacity: Number($("#field-navOpacity").val()),
            navBorderWidth: Number($("#field-navBorderWidth").val()),
            navBorderRadius: Number($("#field-navBorderRadius").val()),
            navBorderStyle: $("#field-navBorderStyle").val(),
            navBorderColor: $("#field-navBorderColor").val(),
            navPadding: $("#field-navPadding").val(),
            navTitleBackgroundColor: $("#field-navTitleBackgroundColor").val(),
            navTitleColor: $("#field-navTitleColor").val(),
            navTitleFontSize: Number($("#field-navTitleFontSize").val()),
            navTitleFontWeight: $("#field-navTitleFontWeight").val(),
            navLinkColor: $("#field-navLinkColor").val(),
            navLinkFontSize: Number($("#field-navLinkFontSize").val()),
            navLinkFontWeight: $("#field-navLinkFontWeight").val(),
            navLinkDecoration: $("#field-navLinkDecoration").val(),
            navLinkDecorationColor: $("#field-navLinkDecorationColor").val(),
            navLinkHoverColor: $("#field-navLinkHoverColor").val(),
            navLinkHoverDecoration: $("#field-navLinkHoverDecoration").val(),
            navLinkHoverDecorationColor: $("#field-navLinkHoverDecorationColor").val(),
            navLinkHighlightColor: $("#field-navLinkHighlightColor").val(),
            navLinkHighlightFontWeight: $("#field-navLinkHighlightFontWeight").val(),
            navLinkHighlightDecoration: $("#field-navLinkHighlightDecoration").val(),
            navLinkHighlightDecorationColor: $("#field-navLinkHighlightDecorationColor").val(),
            navExpandButtonColor: $("#field-navExpandButtonColor").val(),
            navExpandButtonHoverColor: $("#field-navExpandButtonHoverColor").val(),
            navSwitcherButtonColor: $("#field-navSwitcherButtonColor").val(),
            navSwitcherButtonHoverColor: $("#field-navSwitcherButtonHoverColor").val(),
            useCustomColors: $("#field-useCustomColors").val() == "true"
        };

        $.ajax({
            url: url,
            type: "POST",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            processData: false,
            success: function (data, textStatus, XMLHttpRequest) {
                $("#ehp-style").html(data.navigationCssStyle);
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function loadSettingForDisplay(setting) {
        // For Page
        $("#field-selector").val(setting.selector);
        $("#field-headingIndent").val(setting.headingIndent);
        $("#field-numberOption").val(setting.numberOption);
        $("#field-expandCollapseOption").val(setting.expandCollapseOption);

        // For Navigation
        $("#field-useNavigation").prop("checked", setting.useNavigation);
        $("#field-navigationMode").val(setting.navigationMode);
        $("#field-navigationTitle").val(setting.navigationTitle);
        $("#field-navigationTop").val(setting.navigationTop);
        $("#field-navigationWidth").val(setting.navigationWidth);
        $("#field-navigationIndent").val(setting.navigationIndent);
        $("#field-disableNavLinksUnder").val(setting.disableNavLinksUnder);
        $("#field-expandCollapseNavOption").val(setting.expandCollapseNavOption);
        $("#field-labelsAppDisabled").val(setting.labelsAppDisabled);
        $("#field-macrosAppDisabled").val(setting.macrosAppDisabled);
        $("#field-macrosTOCDisabled").val(setting.macrosTOCDisabled);
    }

    function loadSettingForEditor(setting) {
        // For Navigation (edit-mode)
        $("#field-navigationEditMode").val(setting.navigationEditMode);
    }

    function loadStyle(setting) {
        // For Navigation Style
        $("#field-navBackgroundColor").val(setting.navBackgroundColor);
        $("#field-navOpacity").val(setting.navOpacity);
        $("#field-navBorderWidth").val(setting.navBorderWidth);
        $("#field-navBorderRadius").val(setting.navBorderRadius);
        $("#field-navBorderStyle").val(setting.navBorderStyle);
        $("#field-navBorderColor").val(setting.navBorderColor);
        $("#field-navPadding").val(setting.navPadding);
        $("#field-navTitleBackgroundColor").val(setting.navTitleBackgroundColor);
        $("#field-navTitleColor").val(setting.navTitleColor);
        $("#field-navTitleFontSize").val(setting.navTitleFontSize);
        $("#field-navTitleFontWeight").val(setting.navTitleFontWeight);
        $("#field-navLinkColor").val(setting.navLinkColor);
        $("#field-navLinkFontSize").val(setting.navLinkFontSize);
        $("#field-navLinkFontWeight").val(setting.navLinkFontWeight);
        $("#field-navLinkDecoration").val(setting.navLinkDecoration);
        $("#field-navLinkDecorationColor").val(setting.navLinkDecorationColor);
        $("#field-navLinkHoverColor").val(setting.navLinkHoverColor);
        $("#field-navLinkHoverDecoration").val(setting.navLinkHoverDecoration);
        $("#field-navLinkHoverDecorationColor").val(setting.navLinkHoverDecorationColor);
        $("#field-navLinkHighlightColor").val(setting.navLinkHighlightColor);
        $("#field-navLinkHighlightFontWeight").val(setting.navLinkHighlightFontWeight);
        $("#field-navLinkHighlightDecoration").val(setting.navLinkHighlightDecoration);
        $("#field-navLinkHighlightDecorationColor").val(setting.navLinkHighlightDecorationColor);
        $("#field-navExpandButtonColor").val(setting.navExpandButtonColor);
        $("#field-navExpandButtonHoverColor").val(setting.navExpandButtonHoverColor);
        $("#field-navSwitcherButtonColor").val(setting.navSwitcherButtonColor);
        $("#field-navSwitcherButtonHoverColor").val(setting.navSwitcherButtonHoverColor);
        $("#field-useCustomColors").val(setting.useCustomColors ? "true" : "false");
    }

    // Common
    function showMessage(type, message) {
        AJS.flag({
            type: type,
            body: message,
            close: "auto"
        });
    }
});
