/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.servlet;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.shineatlas.confluence.headingpro.exception.EasyHeadingException;
import com.shineatlas.confluence.headingpro.service.ContentDeactivationService;
import com.shineatlas.confluence.headingpro.service.SystemAdminService;
import com.shineatlas.confluence.headingpro.viewmodel.ContentDeactivationViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSettingViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.SystemSettingViewModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemSettingServlet
extends HttpServlet {
    private static final String ACTION_GET_SETTING = "get";
    private static final String ACTION_GET_DEFAULT_SETTING = "default";
    private static final String ACTION_GET_STYLE_TEMPLATE = "template";
    private static final String ACTION_UPDATE_SETTING_FOR_DISPLAY = "update-setting-display";
    private static final String ACTION_UPDATE_SETTING_FOR_EDITOR = "update-setting-editor";
    private static final String ACTION_UPDATE_SETTING_FOR_STYLE = "update-setting-style";
    private static final String ACTION_ENABLE_SETTING = "enable";
    private static final String ACTION_ENABLE_FOR_HOME_SETTING = "enable-for-home";
    private static final String ACTION_UPDATE_USE_GLOBAL_SETTING = "update-use-global";
    private static final String ACTION_UPDATE_ENABLE_SPACE_BY_DEFAULT = "update-enable-space-by-default";
    private static final String ACTION_GET_DEACTIVATION_SEARCH = "deactivation-search";
    private static final String ACTION_GET_DEACTIVATION = "deactivation-get";
    private static final String ACTION_GET_ALL_DEACTIVATION = "deactivation-get-all";
    private static final String ACTION_UPDATE_DEACTIVATE_CONTENT = "deactivate-content";
    private static final Logger log = LoggerFactory.getLogger(SystemSettingServlet.class);
    private final I18nResolver i18nResolver;
    private final AccessModeService accessModeService;
    private final UserManager userManager;
    private final SoyTemplateRenderer soyRenderer;
    private final SystemAdminService systemAdminService;
    private final ContentDeactivationService contentDeactivationService;

    @Inject
    public SystemSettingServlet(@ComponentImport I18nResolver i18nResolver, @ComponentImport AccessModeService accessModeService, @ComponentImport UserManager userManager, @ComponentImport SoyTemplateRenderer soyRenderer, SystemAdminService systemAdminService, ContentDeactivationService contentDeactivationService) {
        this.i18nResolver = i18nResolver;
        this.accessModeService = accessModeService;
        this.userManager = userManager;
        this.soyRenderer = soyRenderer;
        this.systemAdminService = systemAdminService;
        this.contentDeactivationService = contentDeactivationService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserProfile user = this.userManager.getRemoteUser(request);
        if (user == null || !this.userManager.isSystemAdmin(user.getUserKey())) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-no-permission"));
            response.getWriter().flush();
            return;
        }
        String action = request.getParameter("action");
        try {
            if (action.equals(ACTION_GET_DEFAULT_SETTING)) {
                SystemSettingViewModel systemSetting = this.systemAdminService.getSystemDefaultSetting();
                SpaceSettingViewModel result = systemSetting.getGlobalSetting();
                JSONObject jsonObject = new JSONObject((Object)result);
                response.setContentType("application/json");
                response.getWriter().write(jsonObject.toString());
            } else if (action.equals(ACTION_GET_STYLE_TEMPLATE)) {
                String template = Optional.ofNullable(request.getParameter(ACTION_GET_STYLE_TEMPLATE)).orElse("blue");
                SystemSettingViewModel systemSetting = this.systemAdminService.getSettingByTemplate(template);
                SpaceSettingViewModel result = systemSetting.getGlobalSetting();
                JSONObject jsonObject = new JSONObject((Object)result);
                response.setContentType("application/json");
                response.getWriter().write(jsonObject.toString());
            } else if (action.equals(ACTION_GET_SETTING)) {
                SystemSettingViewModel systemSetting = this.systemAdminService.getSystemSetting();
                SpaceSettingViewModel result = systemSetting.getGlobalSetting();
                JSONObject jsonObject = new JSONObject((Object)result);
                response.setContentType("application/json");
                response.getWriter().write(jsonObject.toString());
            } else if (action.equals(ACTION_GET_DEACTIVATION_SEARCH)) {
                String searchTitle = Optional.ofNullable(request.getParameter("title")).orElse("").trim();
                List<ContentDeactivationViewModel> result = this.contentDeactivationService.searchContentForDeactivation(searchTitle);
                List modelList = result.stream().map(vm -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("spaceName", vm.getSpaceName());
                    map.put("spaceUrl", vm.getSpaceUrl());
                    map.put("contentType", vm.getContentType());
                    map.put("title", vm.getTitle());
                    map.put("url", vm.getUrl());
                    map.put("status", vm.getStatus());
                    map.put("contentId", vm.getContentId());
                    map.put("deactivated", vm.isDeactivated());
                    return map;
                }).collect(Collectors.toList());
                HashMap context = new HashMap();
                context.put("models", modelList != null ? modelList : Collections.emptyList());
                String html = this.soyRenderer.render("com.shineatlas.confluence.headingpro.easy-heading-pro:soy-templates", String.format("com.shineatlas.confluence.headingpro.templates.%s", "deactivationSearch"), context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(html);
            } else if (action.equals(ACTION_GET_DEACTIVATION)) {
                String strContentId = Optional.ofNullable(request.getParameter("contentId")).orElse("-1");
                long contentId = Long.parseLong(strContentId);
                ArrayList<ContentDeactivationViewModel> result = new ArrayList<ContentDeactivationViewModel>();
                ContentDeactivationViewModel model = this.contentDeactivationService.getContentDeactivation(contentId);
                if (model != null) {
                    result.add(model);
                }
                JSONObject jsonObject = new JSONObject(result);
                response.setContentType("application/json");
                response.getWriter().write(jsonObject.toString());
            } else if (action.equals(ACTION_GET_ALL_DEACTIVATION)) {
                String spaceKey = Optional.ofNullable(request.getParameter("spaceKey")).orElse("").trim();
                List<ContentDeactivationViewModel> result = this.contentDeactivationService.getAllContentDeactivations(spaceKey);
                List modelList = result.stream().map(vm -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("spaceName", vm.getSpaceName());
                    map.put("spaceUrl", vm.getSpaceUrl());
                    map.put("contentType", vm.getContentType());
                    map.put("title", vm.getTitle());
                    map.put("url", vm.getUrl());
                    map.put("status", vm.getStatus());
                    map.put("contentId", vm.getContentId());
                    map.put("deactivated", vm.isDeactivated());
                    return map;
                }).collect(Collectors.toList());
                HashMap context = new HashMap();
                context.put("models", modelList != null ? modelList : Collections.emptyList());
                String html = this.soyRenderer.render("com.shineatlas.confluence.headingpro.easy-heading-pro:soy-templates", String.format("com.shineatlas.confluence.headingpro.templates.%s", "deactivationLoadAll"), context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(html);
            } else {
                log.error("the parameter action %s is invalid", (Object)action);
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
                response.getWriter().flush();
                return;
            }
            response.setStatus(200);
            response.getWriter().close();
        }
        catch (Exception e) {
            log.error(String.format("Error getting global space setting with action: %s", action), (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONObject jsonObjectResult;
        block19: {
            UserProfile user = this.userManager.getRemoteUser(request);
            if (user == null || !this.userManager.isSystemAdmin(user.getUserKey())) {
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-no-permission"));
                response.getWriter().flush();
                return;
            }
            if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-read-only-mode"));
                response.getWriter().flush();
                return;
            }
            String licenseError = this.systemAdminService.getSystemSetting().getGlobalSetting().getLicenseError();
            if (licenseError != null) {
                response.setStatus(400);
                response.getWriter().print(licenseError);
                response.getWriter().flush();
                return;
            }
            String action = "";
            StringBuffer jb = new StringBuffer();
            String line = null;
            try {
                BufferedReader reader = request.getReader();
                while ((line = reader.readLine()) != null) {
                    jb.append(line);
                }
            }
            catch (Exception e) {
                log.error("Error reading value from request with BufferedReader", (Throwable)e);
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
                response.getWriter().flush();
                return;
            }
            JSONObject jsonObject = null;
            try {
                jsonObject = new JSONObject(jb.toString());
                action = jsonObject.getString("action");
            }
            catch (JSONException e) {
                log.error("Error extracting json object from StringBuffer", (Throwable)e);
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
                response.getWriter().flush();
                return;
            }
            SystemSettingViewModel systemSetting = this.systemAdminService.getSystemSetting();
            SpaceSettingViewModel globalSetting = systemSetting.getGlobalSetting();
            jsonObjectResult = null;
            try {
                if (action.equals(ACTION_UPDATE_USE_GLOBAL_SETTING)) {
                    boolean useGlobalSetting = jsonObject.getBoolean("useGlobalSetting");
                    SpaceSettingViewModel result = this.systemAdminService.saveSystemSettingUseGlobal(useGlobalSetting);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block19;
                }
                if (action.equals(ACTION_UPDATE_ENABLE_SPACE_BY_DEFAULT)) {
                    boolean enableSpaceByDefault = jsonObject.getBoolean("enableSpaceByDefault");
                    SpaceSettingViewModel result = this.systemAdminService.saveSystemSettingEnableSpaceByDefault(enableSpaceByDefault);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block19;
                }
                if (action.equals(ACTION_ENABLE_SETTING)) {
                    globalSetting.setEnabled(jsonObject.getBoolean("enabled"));
                    SystemSettingViewModel viewModel = new SystemSettingViewModel(systemSetting.isUseGlobalSetting(), systemSetting.isEnableSpaceByDefault(), globalSetting);
                    SpaceSettingViewModel result = this.systemAdminService.saveSystemSetting(viewModel);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block19;
                }
                if (action.equals(ACTION_ENABLE_FOR_HOME_SETTING)) {
                    globalSetting.setEnabledForHome(jsonObject.getBoolean("enabledForSpaceHome"));
                    SystemSettingViewModel viewModel = new SystemSettingViewModel(systemSetting.isUseGlobalSetting(), systemSetting.isEnableSpaceByDefault(), globalSetting);
                    SpaceSettingViewModel result = this.systemAdminService.saveSystemSetting(viewModel);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block19;
                }
                if (action.equals(ACTION_UPDATE_SETTING_FOR_DISPLAY)) {
                    globalSetting.setSelector(jsonObject.getString("selector"));
                    globalSetting.setHeadingIndent(jsonObject.getInt("headingIndent"));
                    globalSetting.setNumberOption(jsonObject.getString("numberOption"));
                    globalSetting.setExpandCollapseOption(jsonObject.getString("expandCollapseOption"));
                    globalSetting.setTitleExpandClickable(jsonObject.getBoolean("titleExpandClickable"));
                    globalSetting.setUseNavigation(jsonObject.getBoolean("useNavigation"));
                    globalSetting.setNavigationMode(jsonObject.getString("navigationMode"));
                    globalSetting.setWrapNavigationText(jsonObject.getBoolean("wrapNavigationText"));
                    globalSetting.setNavigationTitle(jsonObject.getString("navigationTitle"));
                    globalSetting.setNavigationTop(jsonObject.getInt("navigationTop"));
                    globalSetting.setNavigationWidth(jsonObject.getInt("navigationWidth"));
                    globalSetting.setNavigationIndent(jsonObject.getInt("navigationIndent"));
                    globalSetting.setDisableNavLinksUnder(jsonObject.getInt("disableNavLinksUnder"));
                    globalSetting.setExpandCollapseNavOption(jsonObject.getString("expandCollapseNavOption"));
                    globalSetting.setLabelsAppDisabled(jsonObject.getString("labelsAppDisabled"));
                    globalSetting.setMacrosAppDisabled(jsonObject.getString("macrosAppDisabled"));
                    globalSetting.setMacrosTOCDisabled(jsonObject.getString("macrosTOCDisabled"));
                    SystemSettingViewModel viewModel = new SystemSettingViewModel(systemSetting.isUseGlobalSetting(), systemSetting.isEnableSpaceByDefault(), globalSetting);
                    SpaceSettingViewModel result = this.systemAdminService.saveSystemSetting(viewModel);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block19;
                }
                if (action.equals(ACTION_UPDATE_SETTING_FOR_EDITOR)) {
                    globalSetting.setNavigationEditMode(jsonObject.getString("navigationEditMode"));
                    SystemSettingViewModel viewModel = new SystemSettingViewModel(systemSetting.isUseGlobalSetting(), systemSetting.isEnableSpaceByDefault(), globalSetting);
                    SpaceSettingViewModel result = this.systemAdminService.saveSystemSetting(viewModel);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block19;
                }
                if (action.equals(ACTION_UPDATE_SETTING_FOR_STYLE)) {
                    globalSetting.setNavBackgroundColor(jsonObject.getString("navBackgroundColor"));
                    globalSetting.setNavOpacity(jsonObject.getDouble("navOpacity"));
                    globalSetting.setNavBorderWidth(jsonObject.getInt("navBorderWidth"));
                    globalSetting.setNavBorderRadius(jsonObject.getInt("navBorderRadius"));
                    globalSetting.setNavBorderStyle(jsonObject.getString("navBorderStyle"));
                    globalSetting.setNavBorderColor(jsonObject.getString("navBorderColor"));
                    globalSetting.setNavPadding(jsonObject.getInt("navPadding"));
                    globalSetting.setNavTitleBackgroundColor(jsonObject.getString("navTitleBackgroundColor"));
                    globalSetting.setNavTitleColor(jsonObject.getString("navTitleColor"));
                    globalSetting.setNavTitleFontSize(jsonObject.getInt("navTitleFontSize"));
                    globalSetting.setNavTitleFontWeight(jsonObject.getString("navTitleFontWeight"));
                    globalSetting.setNavLinkColor(jsonObject.getString("navLinkColor"));
                    globalSetting.setNavLinkFontSize(jsonObject.getInt("navLinkFontSize"));
                    globalSetting.setNavLinkFontWeight(jsonObject.getString("navLinkFontWeight"));
                    globalSetting.setNavLinkDecoration(jsonObject.getString("navLinkDecoration"));
                    globalSetting.setNavLinkDecorationColor(jsonObject.getString("navLinkDecorationColor"));
                    globalSetting.setNavLinkHoverColor(jsonObject.getString("navLinkHoverColor"));
                    globalSetting.setNavLinkHoverDecoration(jsonObject.getString("navLinkHoverDecoration"));
                    globalSetting.setNavLinkHoverDecorationColor(jsonObject.getString("navLinkHoverDecorationColor"));
                    globalSetting.setNavLinkHighlightColor(jsonObject.getString("navLinkHighlightColor"));
                    globalSetting.setNavLinkHighlightFontWeight(jsonObject.getString("navLinkHighlightFontWeight"));
                    globalSetting.setNavLinkHighlightDecoration(jsonObject.getString("navLinkHighlightDecoration"));
                    globalSetting.setNavLinkHighlightDecorationColor(jsonObject.getString("navLinkHighlightDecorationColor"));
                    globalSetting.setNavExpandButtonColor(jsonObject.getString("navExpandButtonColor"));
                    globalSetting.setNavExpandButtonHoverColor(jsonObject.getString("navExpandButtonHoverColor"));
                    globalSetting.setNavSwitcherButtonColor(jsonObject.getString("navSwitcherButtonColor"));
                    globalSetting.setNavSwitcherButtonHoverColor(jsonObject.getString("navSwitcherButtonHoverColor"));
                    globalSetting.setUseCustomColors(jsonObject.getString("useCustomColors") == "true");
                    SystemSettingViewModel viewModel = new SystemSettingViewModel(systemSetting.isUseGlobalSetting(), systemSetting.isEnableSpaceByDefault(), globalSetting);
                    SpaceSettingViewModel result = this.systemAdminService.saveSystemSetting(viewModel);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block19;
                }
                if (action.equals(ACTION_UPDATE_DEACTIVATE_CONTENT)) {
                    long contentId = jsonObject.getLong("contentId");
                    boolean beingDeactivated = jsonObject.getBoolean("beingDeactivated");
                    ContentDeactivationViewModel result = this.contentDeactivationService.deactivateContent(contentId, beingDeactivated);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block19;
                }
                log.error("the parameter action %s is invalid", (Object)action);
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
                response.getWriter().flush();
                return;
            }
            catch (EasyHeadingException e) {
                log.error(String.format("Error save setting with action: %s", action), (Throwable)e);
                response.setStatus(400);
                response.getWriter().print(e.getMessage());
                response.getWriter().flush();
            }
            catch (Exception e) {
                log.error(String.format("Error save setting with action: %s", action), (Throwable)e);
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
                response.getWriter().flush();
            }
        }
        response.setStatus(200);
        response.setContentType("application/json");
        response.getWriter().write(jsonObjectResult.toString());
        response.getWriter().close();
    }
}

