/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSettingViewModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(StyleServlet.class);
    private final I18nResolver i18nResolver;
    private final SoyTemplateRenderer soyRenderer;

    @Inject
    public StyleServlet(@ComponentImport I18nResolver i18nResolver, @ComponentImport SoyTemplateRenderer soyRenderer) {
        this.i18nResolver = i18nResolver;
        this.soyRenderer = soyRenderer;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser == null || currentUser.getKey().getStringValue().isEmpty()) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-not-authenticated"));
            response.getWriter().flush();
        }
        SpaceSettingViewModel setting = null;
        StringBuffer jb = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
        }
        catch (Exception e) {
            log.error("Error reading value from request with BufferedReader", (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jb.toString());
            setting = new SpaceSettingViewModel(-1L, false, false, jsonObject.getString("selector"), jsonObject.getInt("headingIndent"), jsonObject.getString("numberOption"), jsonObject.getString("expandCollapseOption"), jsonObject.getBoolean("titleExpandClickable"), jsonObject.getBoolean("useNavigation"), jsonObject.getString("navigationMode"), jsonObject.getBoolean("wrapNavigationText"), jsonObject.getString("navigationTitle"), jsonObject.getInt("navigationTop"), jsonObject.getInt("navigationWidth"), jsonObject.getInt("navigationIndent"), jsonObject.getInt("disableNavLinksUnder"), jsonObject.getString("expandCollapseNavOption"), jsonObject.getString("labelsAppDisabled"), jsonObject.getString("macrosAppDisabled"), jsonObject.getString("macrosTOCDisabled"), jsonObject.getString("navigationEditMode"), jsonObject.getString("navBackgroundColor"), jsonObject.getDouble("navOpacity"), jsonObject.getInt("navBorderWidth"), jsonObject.getInt("navBorderRadius"), jsonObject.getString("navBorderStyle"), jsonObject.getString("navBorderColor"), jsonObject.getInt("navPadding"), jsonObject.getString("navTitleBackgroundColor"), jsonObject.getString("navTitleColor"), jsonObject.getInt("navTitleFontSize"), jsonObject.getString("navTitleFontWeight"), jsonObject.getString("navLinkColor"), jsonObject.getInt("navLinkFontSize"), jsonObject.getString("navLinkFontWeight"), jsonObject.getString("navLinkDecoration"), jsonObject.getString("navLinkDecorationColor"), jsonObject.getString("navLinkHoverColor"), jsonObject.getString("navLinkHoverDecoration"), jsonObject.getString("navLinkHoverDecorationColor"), jsonObject.getString("navLinkHighlightColor"), jsonObject.getString("navLinkHighlightFontWeight"), jsonObject.getString("navLinkHighlightDecoration"), jsonObject.getString("navLinkHighlightDecorationColor"), jsonObject.getString("navExpandButtonColor"), jsonObject.getString("navExpandButtonHoverColor"), jsonObject.getString("navSwitcherButtonColor"), jsonObject.getString("navSwitcherButtonHoverColor"), jsonObject.getBoolean("useCustomColors"));
        }
        catch (JSONException e) {
            log.error("Error extracting json object from StringBuffer", (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        String navigationCssStyle = this.renderNavigationCss(setting);
        setting.setNavigationCssStyle(navigationCssStyle);
        response.setStatus(200);
        JSONObject jsonObject = new JSONObject((Object)setting);
        response.setContentType("application/json");
        response.getWriter().write(jsonObject.toString());
        response.getWriter().close();
    }

    public String renderNavigationCss(SpaceSettingViewModel setting) {
        int navTitleBorderRadius = setting.getNavBorderRadius() - 2;
        if (navTitleBorderRadius < 0) {
            navTitleBorderRadius = 0;
        }
        int navPaddingFix = setting.getNavPadding();
        if (setting.getNavBackgroundColor() != null && setting.getNavBackgroundColor().equals(setting.getNavTitleBackgroundColor())) {
            navPaddingFix = setting.getNavPadding() / 2;
        }
        HashMap<String, Object> settingMap = new HashMap<String, Object>();
        settingMap.put("navBackgroundColor", setting.getNavBackgroundColor());
        settingMap.put("navOpacity", setting.getNavOpacity());
        settingMap.put("navBorderStyle", setting.getNavBorderStyle());
        settingMap.put("navBorderWidth", setting.getNavBorderWidth());
        settingMap.put("navBorderRadius", setting.getNavBorderRadius());
        settingMap.put("navBorderColor", setting.getNavBorderColor());
        settingMap.put("navPadding", setting.getNavPadding());
        settingMap.put("navTitleBackgroundColor", setting.getNavTitleBackgroundColor());
        settingMap.put("navTitleColor", setting.getNavTitleColor());
        settingMap.put("navTitleFontSize", setting.getNavTitleFontSize());
        settingMap.put("navTitleFontWeight", setting.getNavTitleFontWeight());
        settingMap.put("navLinkFontSize", setting.getNavLinkFontSize());
        settingMap.put("navLinkFontWeight", setting.getNavLinkFontWeight());
        settingMap.put("navLinkColor", setting.getNavLinkColor());
        settingMap.put("navLinkDecoration", setting.getNavLinkDecoration());
        settingMap.put("navLinkDecorationColor", setting.getNavLinkDecorationColor());
        settingMap.put("navLinkHoverColor", setting.getNavLinkHoverColor());
        settingMap.put("navLinkHoverDecoration", setting.getNavLinkHoverDecoration());
        settingMap.put("navLinkHoverDecorationColor", setting.getNavLinkHoverDecorationColor());
        settingMap.put("navLinkHighlightColor", setting.getNavLinkHighlightColor());
        settingMap.put("navLinkHighlightFontWeight", setting.getNavLinkHighlightFontWeight());
        settingMap.put("navLinkHighlightDecoration", setting.getNavLinkHighlightDecoration());
        settingMap.put("navLinkHighlightDecorationColor", setting.getNavLinkHighlightDecorationColor());
        settingMap.put("navSwitcherButtonColor", setting.getNavSwitcherButtonColor());
        settingMap.put("navSwitcherButtonHoverColor", setting.getNavSwitcherButtonHoverColor());
        settingMap.put("navExpandButtonColor", setting.getNavExpandButtonColor());
        settingMap.put("navExpandButtonHoverColor", setting.getNavExpandButtonHoverColor());
        settingMap.put("navTitleBorderRadius", navTitleBorderRadius);
        settingMap.put("navPaddingFix", navPaddingFix);
        HashMap<String, HashMap<String, Object>> context = new HashMap<String, HashMap<String, Object>>();
        context.put("setting", settingMap);
        return this.soyRenderer.render("com.shineatlas.confluence.headingpro.easy-heading-pro:soy-templates", String.format("com.shineatlas.confluence.headingpro.templates.%s", "navigationStyle"), context);
    }
}

