/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.servlet;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.shineatlas.confluence.headingpro.exception.EasyHeadingException;
import com.shineatlas.confluence.headingpro.service.ContentDeactivationService;
import com.shineatlas.confluence.headingpro.service.SpaceAdminService;
import com.shineatlas.confluence.headingpro.viewmodel.ContentDeactivationViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSettingViewModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceSettingServlet
extends HttpServlet {
    private static final String ACTION_GET_SETTING = "get";
    private static final String ACTION_GET_DEFAULT_SETTING = "default";
    private static final String ACTION_GET_STYLE_TEMPLATE = "template";
    private static final String ACTION_UPDATE_SETTING_FOR_DISPLAY = "update-setting-display";
    private static final String ACTION_UPDATE_SETTING_FOR_EDITOR = "update-setting-editor";
    private static final String ACTION_UPDATE_SETTING_FOR_STYLE = "update-setting-style";
    private static final String ACTION_ENABLE_SETTING = "enable";
    private static final String ACTION_ENABLE_FOR_HOME_SETTING = "enable-for-home";
    private static final String ACTION_GET_DEACTIVATION_SEARCH = "deactivation-search";
    private static final String ACTION_GET_DEACTIVATION = "deactivation-get";
    private static final String ACTION_GET_ALL_DEACTIVATION = "deactivation-get-all";
    private static final String ACTION_UPDATE_DEACTIVATE_CONTENT = "deactivate-content";
    private static final Logger log = LoggerFactory.getLogger(SpaceSettingServlet.class);
    private final I18nResolver i18nResolver;
    private final PermissionManager permissionManager;
    private final AccessModeService accessModeService;
    private final UserManager userManager;
    private final PageManager pageManager;
    private final SpaceManager spaceManager;
    private final SoyTemplateRenderer soyRenderer;
    private final SpaceAdminService spaceAdminService;
    private final ContentDeactivationService contentDeactivationService;

    @Inject
    public SpaceSettingServlet(@ComponentImport I18nResolver i18nResolver, @ComponentImport PermissionManager permissionManager, @ComponentImport AccessModeService accessModeService, @ComponentImport UserManager userManager, @ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager, @ComponentImport SoyTemplateRenderer soyRenderer, SpaceAdminService spaceAdminService, ContentDeactivationService contentDeactivationService) {
        this.i18nResolver = i18nResolver;
        this.permissionManager = permissionManager;
        this.accessModeService = accessModeService;
        this.userManager = userManager;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.soyRenderer = soyRenderer;
        this.spaceAdminService = spaceAdminService;
        this.contentDeactivationService = contentDeactivationService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String strSpaceId;
        long spaceId;
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser == null || currentUser.getKey().getStringValue().isEmpty()) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-not-authenticated"));
            response.getWriter().flush();
        }
        if ((spaceId = Long.parseLong(strSpaceId = Optional.ofNullable(request.getParameter("spaceId")).orElse("-1"))) == -1L) {
            log.error("Error getting space settings, the space id is invalid");
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        Space space = this.spaceManager.getSpace(spaceId);
        if (!this.permissionManager.hasPermission(currentUser, Permission.ADMINISTER, (Object)space)) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-no-permission"));
            response.getWriter().flush();
        }
        String action = request.getParameter("action");
        try {
            if (action.equals(ACTION_GET_DEFAULT_SETTING)) {
                SpaceSettingViewModel result = this.spaceAdminService.getSpaceDefaultSetting(spaceId);
                JSONObject jsonObject = new JSONObject((Object)result);
                response.setContentType("application/json");
                response.getWriter().write(jsonObject.toString());
            } else if (action.equals(ACTION_GET_STYLE_TEMPLATE)) {
                String template = Optional.ofNullable(request.getParameter(ACTION_GET_STYLE_TEMPLATE)).orElse("blue");
                SpaceSettingViewModel result = this.spaceAdminService.getSettingByTemplate(spaceId, template);
                JSONObject jsonObject = new JSONObject((Object)result);
                response.setContentType("application/json");
                response.getWriter().write(jsonObject.toString());
            } else if (action.equals(ACTION_GET_SETTING)) {
                SpaceSettingViewModel result = this.spaceAdminService.getSpaceSetting(spaceId);
                JSONObject jsonObject = new JSONObject((Object)result);
                response.setContentType("application/json");
                response.getWriter().write(jsonObject.toString());
            } else if (action.equals(ACTION_GET_DEACTIVATION_SEARCH)) {
                String searchTitle = Optional.ofNullable(request.getParameter("title")).orElse("").trim();
                List<ContentDeactivationViewModel> result = this.contentDeactivationService.searchContentForDeactivation(space.getKey(), searchTitle);
                List modelList = result.stream().map(vm -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("spaceName", vm.getSpaceName());
                    map.put("spaceUrl", vm.getSpaceUrl());
                    map.put("contentType", vm.getContentType());
                    map.put("title", vm.getTitle());
                    map.put("url", vm.getUrl());
                    map.put("status", vm.getStatus());
                    map.put("contentId", vm.getContentId());
                    map.put("deactivated", vm.isDeactivated());
                    return map;
                }).collect(Collectors.toList());
                HashMap context = new HashMap();
                context.put("models", modelList != null ? modelList : Collections.emptyList());
                String html = this.soyRenderer.render("com.shineatlas.confluence.headingpro.easy-heading-pro:soy-templates", String.format("com.shineatlas.confluence.headingpro.templates.%s", "deactivationSearch"), context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(html);
            } else if (action.equals(ACTION_GET_DEACTIVATION)) {
                String strContentId = Optional.ofNullable(request.getParameter("contentId")).orElse("-1");
                long contentId = Long.parseLong(strContentId);
                ArrayList<ContentDeactivationViewModel> result = new ArrayList<ContentDeactivationViewModel>();
                ContentDeactivationViewModel model = this.contentDeactivationService.getContentDeactivation(contentId);
                if (model != null) {
                    result.add(model);
                }
                JSONObject jsonObject = new JSONObject(result);
                response.setContentType("application/json");
                response.getWriter().write(jsonObject.toString());
            } else if (action.equals(ACTION_GET_ALL_DEACTIVATION)) {
                List<ContentDeactivationViewModel> result = this.contentDeactivationService.getAllContentDeactivations(space.getKey());
                List modelList = result.stream().map(vm -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("spaceName", vm.getSpaceName());
                    map.put("spaceUrl", vm.getSpaceUrl());
                    map.put("contentType", vm.getContentType());
                    map.put("title", vm.getTitle());
                    map.put("url", vm.getUrl());
                    map.put("status", vm.getStatus());
                    map.put("contentId", vm.getContentId());
                    map.put("deactivated", vm.isDeactivated());
                    return map;
                }).collect(Collectors.toList());
                HashMap context = new HashMap();
                context.put("models", modelList != null ? modelList : Collections.emptyList());
                String html = this.soyRenderer.render("com.shineatlas.confluence.headingpro.easy-heading-pro:soy-templates", String.format("com.shineatlas.confluence.headingpro.templates.%s", "deactivationLoadAll"), context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(html);
            } else {
                log.error("the parameter action %s is invalid", (Object)action);
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
                response.getWriter().flush();
                return;
            }
            response.setStatus(200);
            response.getWriter().close();
        }
        catch (Exception e) {
            log.error(String.format("Error getting space setting with action: %s, spaceId: %s", action, spaceId), (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONObject jsonObjectResult;
        block18: {
            SpaceSettingViewModel spaceSetting;
            String licenseError;
            String action;
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            if (currentUser == null || currentUser.getKey().getStringValue().isEmpty()) {
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-not-authenticated"));
                response.getWriter().flush();
            }
            if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-read-only-mode"));
                response.getWriter().flush();
                return;
            }
            long spaceId = 0L;
            StringBuffer jb = new StringBuffer();
            String line = null;
            try {
                BufferedReader reader = request.getReader();
                while ((line = reader.readLine()) != null) {
                    jb.append(line);
                }
            }
            catch (Exception e) {
                log.error("Error reading value from request with BufferedReader", (Throwable)e);
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
                response.getWriter().flush();
                return;
            }
            JSONObject jsonObject = null;
            try {
                jsonObject = new JSONObject(jb.toString());
                action = jsonObject.getString("action");
                spaceId = jsonObject.getLong("spaceId");
            }
            catch (JSONException e) {
                log.error("Error extracting json object from StringBuffer", (Throwable)e);
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
                response.getWriter().flush();
                return;
            }
            Space space = this.spaceManager.getSpace(spaceId);
            if (!this.permissionManager.hasPermission(currentUser, Permission.ADMINISTER, (Object)space)) {
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-no-permission"));
                response.getWriter().flush();
            }
            if ((licenseError = (spaceSetting = this.spaceAdminService.getSpaceSetting(spaceId)).getLicenseError()) != null) {
                response.setStatus(400);
                response.getWriter().print(licenseError);
                response.getWriter().flush();
                return;
            }
            jsonObjectResult = null;
            try {
                if (action.equals(ACTION_ENABLE_SETTING)) {
                    boolean enabled = jsonObject.getBoolean("enabled");
                    this.spaceAdminService.saveSpaceSetting(spaceId, enabled);
                    SpaceSettingViewModel result = this.spaceAdminService.getSpaceSetting(spaceId);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block18;
                }
                if (action.equals(ACTION_ENABLE_FOR_HOME_SETTING)) {
                    boolean enabledForSpaceHome = jsonObject.getBoolean("enabledForSpaceHome");
                    this.spaceAdminService.saveSpaceSettingEnabledForHome(spaceId, enabledForSpaceHome);
                    SpaceSettingViewModel result = this.spaceAdminService.getSpaceSetting(spaceId);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block18;
                }
                if (action.equals(ACTION_UPDATE_SETTING_FOR_DISPLAY)) {
                    spaceSetting.setSelector(jsonObject.getString("selector"));
                    spaceSetting.setHeadingIndent(jsonObject.getInt("headingIndent"));
                    spaceSetting.setNumberOption(jsonObject.getString("numberOption"));
                    spaceSetting.setExpandCollapseOption(jsonObject.getString("expandCollapseOption"));
                    spaceSetting.setTitleExpandClickable(jsonObject.getBoolean("titleExpandClickable"));
                    spaceSetting.setUseNavigation(jsonObject.getBoolean("useNavigation"));
                    spaceSetting.setNavigationMode(jsonObject.getString("navigationMode"));
                    spaceSetting.setWrapNavigationText(jsonObject.getBoolean("wrapNavigationText"));
                    spaceSetting.setNavigationTitle(jsonObject.getString("navigationTitle"));
                    spaceSetting.setNavigationTop(jsonObject.getInt("navigationTop"));
                    spaceSetting.setNavigationWidth(jsonObject.getInt("navigationWidth"));
                    spaceSetting.setNavigationIndent(jsonObject.getInt("navigationIndent"));
                    spaceSetting.setDisableNavLinksUnder(jsonObject.getInt("disableNavLinksUnder"));
                    spaceSetting.setExpandCollapseNavOption(jsonObject.getString("expandCollapseNavOption"));
                    spaceSetting.setLabelsAppDisabled(jsonObject.getString("labelsAppDisabled"));
                    spaceSetting.setMacrosAppDisabled(jsonObject.getString("macrosAppDisabled"));
                    spaceSetting.setMacrosTOCDisabled(jsonObject.getString("macrosTOCDisabled"));
                    this.spaceAdminService.saveSpaceSetting(spaceSetting);
                    SpaceSettingViewModel result = this.spaceAdminService.getSpaceSetting(spaceId);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block18;
                }
                if (action.equals(ACTION_UPDATE_SETTING_FOR_EDITOR)) {
                    spaceSetting.setNavigationEditMode(jsonObject.getString("navigationEditMode"));
                    this.spaceAdminService.saveSpaceSetting(spaceSetting);
                    SpaceSettingViewModel result = this.spaceAdminService.getSpaceSetting(spaceId);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block18;
                }
                if (action.equals(ACTION_UPDATE_SETTING_FOR_STYLE)) {
                    spaceSetting.setNavBackgroundColor(jsonObject.getString("navBackgroundColor"));
                    spaceSetting.setNavOpacity(jsonObject.getDouble("navOpacity"));
                    spaceSetting.setNavBorderWidth(jsonObject.getInt("navBorderWidth"));
                    spaceSetting.setNavBorderRadius(jsonObject.getInt("navBorderRadius"));
                    spaceSetting.setNavBorderStyle(jsonObject.getString("navBorderStyle"));
                    spaceSetting.setNavBorderColor(jsonObject.getString("navBorderColor"));
                    spaceSetting.setNavPadding(jsonObject.getInt("navPadding"));
                    spaceSetting.setNavTitleBackgroundColor(jsonObject.getString("navTitleBackgroundColor"));
                    spaceSetting.setNavTitleColor(jsonObject.getString("navTitleColor"));
                    spaceSetting.setNavTitleFontSize(jsonObject.getInt("navTitleFontSize"));
                    spaceSetting.setNavTitleFontWeight(jsonObject.getString("navTitleFontWeight"));
                    spaceSetting.setNavLinkColor(jsonObject.getString("navLinkColor"));
                    spaceSetting.setNavLinkFontSize(jsonObject.getInt("navLinkFontSize"));
                    spaceSetting.setNavLinkFontWeight(jsonObject.getString("navLinkFontWeight"));
                    spaceSetting.setNavLinkDecoration(jsonObject.getString("navLinkDecoration"));
                    spaceSetting.setNavLinkDecorationColor(jsonObject.getString("navLinkDecorationColor"));
                    spaceSetting.setNavLinkHoverColor(jsonObject.getString("navLinkHoverColor"));
                    spaceSetting.setNavLinkHoverDecoration(jsonObject.getString("navLinkHoverDecoration"));
                    spaceSetting.setNavLinkHoverDecorationColor(jsonObject.getString("navLinkHoverDecorationColor"));
                    spaceSetting.setNavLinkHighlightColor(jsonObject.getString("navLinkHighlightColor"));
                    spaceSetting.setNavLinkHighlightFontWeight(jsonObject.getString("navLinkHighlightFontWeight"));
                    spaceSetting.setNavLinkHighlightDecoration(jsonObject.getString("navLinkHighlightDecoration"));
                    spaceSetting.setNavLinkHighlightDecorationColor(jsonObject.getString("navLinkHighlightDecorationColor"));
                    spaceSetting.setNavExpandButtonColor(jsonObject.getString("navExpandButtonColor"));
                    spaceSetting.setNavExpandButtonHoverColor(jsonObject.getString("navExpandButtonHoverColor"));
                    spaceSetting.setNavSwitcherButtonColor(jsonObject.getString("navSwitcherButtonColor"));
                    spaceSetting.setNavSwitcherButtonHoverColor(jsonObject.getString("navSwitcherButtonHoverColor"));
                    spaceSetting.setUseCustomColors(jsonObject.getString("useCustomColors") == "true");
                    this.spaceAdminService.saveSpaceSetting(spaceSetting);
                    SpaceSettingViewModel result = this.spaceAdminService.getSpaceSetting(spaceId);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block18;
                }
                if (action.equals(ACTION_UPDATE_DEACTIVATE_CONTENT)) {
                    long contentId = jsonObject.getLong("contentId");
                    boolean beingDeactivated = jsonObject.getBoolean("beingDeactivated");
                    ContentDeactivationViewModel result = this.contentDeactivationService.deactivateContent(contentId, beingDeactivated);
                    jsonObjectResult = new JSONObject((Object)result);
                    break block18;
                }
                log.error("the parameter action %s is invalid", (Object)action);
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
                response.getWriter().flush();
                return;
            }
            catch (EasyHeadingException e) {
                log.error(String.format("Error save setting with action: %s, spaceId: %s", action, spaceId), (Throwable)e);
                response.setStatus(400);
                response.getWriter().print(e.getMessage());
                response.getWriter().flush();
            }
            catch (Exception e) {
                log.error(String.format("Error save setting with action: %s, spaceId: %s", action, spaceId), (Throwable)e);
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
                response.getWriter().flush();
            }
        }
        response.setStatus(200);
        response.setContentType("application/json");
        response.getWriter().write(jsonObjectResult.toString());
        response.getWriter().close();
    }
}

