/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.servlet;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.webresource.api.WebResourceManager;
import com.shineatlas.confluence.headingpro.service.SpaceAdminService;
import com.shineatlas.confluence.headingpro.service.SystemAdminService;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSettingViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.SystemSettingViewModel;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceAdminUIServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SpaceAdminUIServlet.class);
    private final I18nResolver i18nResolver;
    private final UserManager userManager;
    private final SpaceService spaceService;
    private final LoginUriProvider loginUriProvider;
    private final WebResourceManager webResourceManager;
    private final SoyTemplateRenderer soyRenderer;
    private final PluginLicenseManager licenseManager;
    private final SpaceAdminService spaceAdminService;
    private final SystemAdminService systemAdminService;

    @Inject
    public SpaceAdminUIServlet(@ComponentImport I18nResolver i18nResolver, @ComponentImport UserManager userManager, @ComponentImport(value="APISpaceService") SpaceService spaceService, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport WebResourceManager webResourceManager, @ComponentImport SoyTemplateRenderer soyRenderer, @ComponentImport PluginLicenseManager licenseManager, SpaceAdminService spaceAdminService, SystemAdminService systemAdminService) {
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
        this.spaceService = spaceService;
        this.loginUriProvider = loginUriProvider;
        this.webResourceManager = webResourceManager;
        this.soyRenderer = soyRenderer;
        this.licenseManager = licenseManager;
        this.spaceAdminService = spaceAdminService;
        this.systemAdminService = systemAdminService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        UserProfile user = this.userManager.getRemoteUser(request);
        if (userKey == null || user == null) {
            this.redirectToLogin(request, response);
            return;
        }
        this.webResourceManager.requireResourcesForContext("easy-heading-pro-space-admin");
        SystemSettingViewModel systemSetting = this.systemAdminService.getSystemSetting();
        String spaceKey = request.getParameter("spaceKey");
        Optional findSpace = this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetch();
        SpaceSettingViewModel setting = this.spaceAdminService.getSpaceSetting(spaceKey);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("useGlobalSetting", systemSetting.isUseGlobalSetting());
        context.put("setting", setting);
        context.put("spaceId", ((Space)findSpace.get()).getId());
        String html = this.soyRenderer.render("com.shineatlas.confluence.headingpro.easy-heading-pro:soy-templates", String.format("com.shineatlas.confluence.headingpro.templates.%s", "spaceAdmin"), context);
        response.setContentType("text/html;charset=utf-8");
        response.getWriter().write(html);
        response.getWriter().close();
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

