/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.servlet;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.shineatlas.confluence.headingpro.exception.EasyHeadingException;
import com.shineatlas.confluence.headingpro.service.PageParameterService;
import com.shineatlas.confluence.headingpro.service.UserSettingService;
import com.shineatlas.confluence.headingpro.viewmodel.PageParameterViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.UserSettingViewModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageParameterServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(PageParameterServlet.class);
    private final I18nResolver i18nResolver;
    private final PermissionManager permissionManager;
    private final AccessModeService accessModeService;
    private final UserManager userManager;
    private final PageManager pageManager;
    private final PageParameterService pageParameterService;
    private final UserSettingService userSettingService;

    @Inject
    public PageParameterServlet(@ComponentImport I18nResolver i18nResolver, @ComponentImport PermissionManager permissionManager, @ComponentImport AccessModeService accessModeService, @ComponentImport UserManager userManager, @ComponentImport PageManager pageManager, PageParameterService pageParameterService, UserSettingService userSettingService) {
        this.i18nResolver = i18nResolver;
        this.permissionManager = permissionManager;
        this.accessModeService = accessModeService;
        this.userManager = userManager;
        this.pageManager = pageManager;
        this.pageParameterService = pageParameterService;
        this.userSettingService = userSettingService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        String strPageId = Optional.ofNullable(request.getParameter("pageId")).orElse("-1");
        long pageId = Long.parseLong(strPageId);
        if (pageId == -1L) {
            log.error("Error getting page parameters, the page id is invalid");
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        String pageContentType = request.getParameter("pageContentType");
        if (!pageContentType.equals("page") && !pageContentType.equals("blogpost")) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-content-type-error"));
            response.getWriter().flush();
        }
        try {
            String userKey = currentUser == null ? "" : currentUser.getKey().getStringValue();
            PageParameterViewModel result = this.pageParameterService.getPageParameters(userKey, pageId, pageContentType);
            response.setStatus(200);
            JSONObject jsonObject = new JSONObject((Object)result);
            response.setContentType("application/json");
            response.getWriter().write(jsonObject.toString());
            response.getWriter().close();
        }
        catch (Exception e) {
            log.error(String.format("Error getting page parameters with pageId: %s", pageId), (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser == null || currentUser.getKey().getStringValue().isEmpty()) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-not-authenticated"));
            response.getWriter().flush();
            return;
        }
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-read-only-mode"));
            response.getWriter().flush();
            return;
        }
        StringBuffer jb = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
        }
        catch (Exception e) {
            log.error("Error reading value from request with BufferedReader", (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        long pageId = -1L;
        boolean enabledByUser = false;
        try {
            JSONObject jsonObject = new JSONObject(jb.toString());
            pageId = jsonObject.getLong("pageId");
            enabledByUser = jsonObject.getBoolean("enabledByUser");
        }
        catch (JSONException e) {
            log.error("Error extracting json object from StringBuffer", (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        if (pageId == -1L) {
            log.error(String.format("Error getting current user, the page id is invalid", new Object[0]));
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
        }
        try {
            UserSettingViewModel setting = new UserSettingViewModel(currentUser.getKey().getStringValue(), enabledByUser);
            UserSettingViewModel result = this.userSettingService.saveUserSetting(setting);
            response.setStatus(200);
            JSONObject jsonObject = new JSONObject((Object)result);
            response.setContentType("application/json");
            response.getWriter().write(jsonObject.toString());
            response.getWriter().close();
        }
        catch (EasyHeadingException e) {
            log.error(String.format("Error save setting with user key: %s", currentUser.getKey().getStringValue()), (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(e.getMessage());
            response.getWriter().flush();
        }
        catch (Exception e) {
            log.error(String.format("Error save setting with user key: %s", currentUser.getKey().getStringValue()), (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
        }
    }
}

