/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.servlet;

import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.shineatlas.confluence.headingpro.service.PageEditorParameterService;
import com.shineatlas.confluence.headingpro.viewmodel.PageEditorParameterViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSettingViewModel;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageEditorParameterServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(PageEditorParameterServlet.class);
    private final I18nResolver i18nResolver;
    private final PageEditorParameterService pageEditorParameterService;

    @Inject
    public PageEditorParameterServlet(@ComponentImport I18nResolver i18nResolver, PageEditorParameterService pageEditorParameterService) {
        this.i18nResolver = i18nResolver;
        this.pageEditorParameterService = pageEditorParameterService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String action = request.getParameter("action");
        String spaceKey = request.getParameter("spaceKey");
        try {
            if (action != null && action.equals("getEditorParameters")) {
                response.setStatus(200);
                response.setContentType("application/json");
                PageEditorParameterViewModel result = this.pageEditorParameterService.getPageEditorParameters(spaceKey);
                JSONObject jsonObject = new JSONObject((Object)result);
                response.getWriter().write(jsonObject.toString());
            } else {
                response.setStatus(200);
                response.setContentType("application/json");
                SpaceSettingViewModel result = this.pageEditorParameterService.getSpaceSetting(spaceKey);
                JSONObject jsonObject = new JSONObject((Object)result);
                response.getWriter().write(jsonObject.toString());
            }
            response.getWriter().close();
        }
        catch (Exception e) {
            log.error(String.format("Error with action %s and space key: %s", action, spaceKey), (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
        }
    }
}

