/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.servlet;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.webresource.api.WebResourceManager;
import com.shineatlas.confluence.headingpro.service.SystemAdminService;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSimpleViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.SystemSettingViewModel;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminUIServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AdminUIServlet.class);
    private final I18nResolver i18nResolver;
    private final UserManager userManager;
    private final SpaceManager spaceManager;
    private final LoginUriProvider loginUriProvider;
    private final WebResourceManager webResourceManager;
    private final SoyTemplateRenderer soyRenderer;
    private final PluginLicenseManager licenseManager;
    private final SystemAdminService systemAdminService;

    @Inject
    public AdminUIServlet(@ComponentImport I18nResolver i18nResolver, @ComponentImport UserManager userManager, @ComponentImport SpaceManager spaceManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport WebResourceManager webResourceManager, @ComponentImport SoyTemplateRenderer soyRenderer, @ComponentImport PluginLicenseManager licenseManager, SystemAdminService systemAdminService) {
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
        this.spaceManager = spaceManager;
        this.loginUriProvider = loginUriProvider;
        this.webResourceManager = webResourceManager;
        this.soyRenderer = soyRenderer;
        this.licenseManager = licenseManager;
        this.systemAdminService = systemAdminService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        UserProfile user = this.userManager.getRemoteUser(request);
        if (userKey == null || user == null || !this.userManager.isSystemAdmin(user.getUserKey())) {
            this.redirectToLogin(request, response);
            return;
        }
        this.webResourceManager.requireResourcesForContext("easy-heading-pro-system-admin");
        SystemSettingViewModel systemSetting = this.systemAdminService.getSystemSetting();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("useGlobalSetting", systemSetting.isUseGlobalSetting());
        context.put("enableSpaceByDefault", systemSetting.isEnableSpaceByDefault());
        context.put("setting", systemSetting.getGlobalSetting());
        List spaces = this.spaceManager.getAllSpaces();
        List<SpaceSimpleViewModel> spaceModels = SpaceSimpleViewModel.convertToSpaceViewModels(spaces);
        context.put("spaces", spaces);
        String html = this.soyRenderer.render("com.shineatlas.confluence.headingpro.easy-heading-pro:soy-templates", String.format("com.shineatlas.confluence.headingpro.templates.%s", "systemAdmin"), context);
        response.setContentType("text/html;charset=utf-8");
        response.getWriter().write(html);
        response.getWriter().close();
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

