/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.service;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.shineatlas.confluence.headingpro.StyleTemplates;
import com.shineatlas.confluence.headingpro.dao.SpaceSettingDAO;
import com.shineatlas.confluence.headingpro.dao.SystemSettingDAO;
import com.shineatlas.confluence.headingpro.domain.SpaceSettingObject;
import com.shineatlas.confluence.headingpro.domain.SysSettingObject;
import com.shineatlas.confluence.headingpro.exception.EasyHeadingException;
import com.shineatlas.confluence.headingpro.helper.LicenseHelper;
import com.shineatlas.confluence.headingpro.service.SpaceAdminService;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSettingViewModel;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SpaceAdminServiceImpl
implements SpaceAdminService {
    private static final Logger log = LoggerFactory.getLogger(SpaceAdminServiceImpl.class);
    private static final String PLUGIN_KEY = "com.shineatlas.confluence.headingpro.easy-heading-pro";
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager pluginLicenseManager;
    private final SpaceManager spaceManager;
    private final SoyTemplateRenderer soyRenderer;
    private final SpaceSettingDAO spaceSettingDAO;
    private final SystemSettingDAO systemSettingDAO;

    @Inject
    public SpaceAdminServiceImpl(@ComponentImport I18nResolver i18nResolver, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport SpaceManager spaceManager, @ComponentImport SoyTemplateRenderer soyRenderer, SpaceSettingDAO spaceSettingDAO, SystemSettingDAO systemSettingDAO) {
        this.i18nResolver = i18nResolver;
        this.pluginLicenseManager = pluginLicenseManager;
        this.spaceManager = spaceManager;
        this.soyRenderer = soyRenderer;
        this.spaceSettingDAO = spaceSettingDAO;
        this.systemSettingDAO = systemSettingDAO;
    }

    @Override
    public SpaceSettingViewModel getSpaceSetting(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        return this.getSpaceSetting(space.getId());
    }

    @Override
    public SpaceSettingViewModel getSpaceSetting(long spaceId) {
        SpaceSettingViewModel spaceSetting;
        SpaceSettingObject obj = this.spaceSettingDAO.find(spaceId);
        if (obj == null) {
            SysSettingObject sysSettingObject = this.systemSettingDAO.getSystemSetting();
            boolean defaultValue = sysSettingObject.getEnableSpaceByDefault();
            spaceSetting = SpaceSettingViewModel.createDefaultSetting(spaceId, defaultValue, defaultValue);
        } else {
            spaceSetting = SpaceSettingViewModel.convertObjectToViewModel(obj);
        }
        String css = this.renderNavigationCss(spaceSetting);
        spaceSetting.setNavigationCssStyle(css);
        String licenseError = LicenseHelper.getLicenseErrorMessage(this.pluginLicenseManager, this.i18nResolver);
        spaceSetting.setLicenseError(licenseError);
        return spaceSetting;
    }

    @Override
    public SpaceSettingViewModel getSpaceSettingRenderPage(long spaceId) {
        SpaceSettingViewModel spaceSetting;
        SpaceSettingObject obj = this.spaceSettingDAO.find(spaceId);
        if (obj == null) {
            SysSettingObject sysSettingObject = this.systemSettingDAO.getSystemSetting();
            boolean defaultValue = sysSettingObject.getEnableSpaceByDefault();
            spaceSetting = SpaceSettingViewModel.createDefaultSetting(spaceId, defaultValue, defaultValue);
        } else {
            spaceSetting = SpaceSettingViewModel.convertObjectToViewModel(obj);
        }
        if (!spaceSetting.isUseCustomColors()) {
            spaceSetting = StyleTemplates.AtlassianTheme(spaceSetting);
        }
        String css = this.renderNavigationCss(spaceSetting);
        spaceSetting.setNavigationCssStyle(css);
        String licenseError = LicenseHelper.getLicenseErrorMessage(this.pluginLicenseManager, this.i18nResolver);
        spaceSetting.setLicenseError(licenseError);
        return spaceSetting;
    }

    @Override
    public SpaceSettingViewModel getSpaceDefaultSetting(long spaceId) {
        SpaceSettingViewModel model = this.getSpaceSetting(spaceId);
        SpaceSettingViewModel spaceSetting = SpaceSettingViewModel.createDefaultSetting(spaceId, model.isEnabled(), model.isEnabledForHome());
        String licenseError = LicenseHelper.getLicenseErrorMessage(this.pluginLicenseManager, this.i18nResolver);
        spaceSetting.setLicenseError(licenseError);
        return spaceSetting;
    }

    @Override
    public SpaceSettingViewModel getSettingByTemplate(long spaceId, String templateName) {
        SpaceSettingViewModel spaceSetting = this.getSpaceSetting(spaceId);
        switch (templateName) {
            case "orange": {
                spaceSetting = StyleTemplates.OrangeStandard(spaceSetting);
                break;
            }
            case "green": {
                spaceSetting = StyleTemplates.GreenStandard(spaceSetting);
                break;
            }
            default: {
                spaceSetting = StyleTemplates.BlueStandard(spaceSetting);
            }
        }
        String licenseError = LicenseHelper.getLicenseErrorMessage(this.pluginLicenseManager, this.i18nResolver);
        spaceSetting.setLicenseError(licenseError);
        return spaceSetting;
    }

    @Override
    public void saveSpaceSetting(SpaceSettingViewModel setting) throws EasyHeadingException {
        if (setting == null) {
            throw new EasyHeadingException(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.validation.space-required"));
        }
        if (setting.getSpaceId() < 0L) {
            throw new EasyHeadingException(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.validation.space-id-required"));
        }
        this.spaceSettingDAO.save(setting);
    }

    @Override
    public void saveSpaceSetting(long spaceId, boolean enabled) throws EasyHeadingException {
        SpaceSettingViewModel model = this.getSpaceSetting(spaceId);
        if (model == null) {
            model = SpaceSettingViewModel.createDefaultSetting(spaceId, false, false);
        }
        model.setEnabled(enabled);
        this.saveSpaceSetting(model);
    }

    @Override
    public void saveSpaceSettingEnabledForHome(long spaceId, boolean enabledForHome) throws EasyHeadingException {
        SpaceSettingViewModel model = this.getSpaceSetting(spaceId);
        if (model == null) {
            model = SpaceSettingViewModel.createDefaultSetting(spaceId, false, false);
        }
        model.setEnabledForHome(enabledForHome);
        this.saveSpaceSetting(model);
    }

    public String renderNavigationCss(SpaceSettingViewModel setting) {
        int navTitleBorderRadius = setting.getNavBorderRadius() - 2;
        if (navTitleBorderRadius < 0) {
            navTitleBorderRadius = 0;
        }
        int navPaddingFix = setting.getNavPadding();
        if (setting.getNavBackgroundColor() != null && setting.getNavBackgroundColor().equals(setting.getNavTitleBackgroundColor())) {
            navPaddingFix = setting.getNavPadding() / 2;
        }
        HashMap<String, Object> settingMap = new HashMap<String, Object>();
        settingMap.put("navBackgroundColor", setting.getNavBackgroundColor());
        settingMap.put("navOpacity", setting.getNavOpacity());
        settingMap.put("navBorderStyle", setting.getNavBorderStyle());
        settingMap.put("navBorderWidth", setting.getNavBorderWidth());
        settingMap.put("navBorderRadius", setting.getNavBorderRadius());
        settingMap.put("navBorderColor", setting.getNavBorderColor());
        settingMap.put("navPadding", setting.getNavPadding());
        settingMap.put("navTitleBackgroundColor", setting.getNavTitleBackgroundColor());
        settingMap.put("navTitleColor", setting.getNavTitleColor());
        settingMap.put("navTitleFontSize", setting.getNavTitleFontSize());
        settingMap.put("navTitleFontWeight", setting.getNavTitleFontWeight());
        settingMap.put("navLinkFontSize", setting.getNavLinkFontSize());
        settingMap.put("navLinkFontWeight", setting.getNavLinkFontWeight());
        settingMap.put("navLinkColor", setting.getNavLinkColor());
        settingMap.put("navLinkDecoration", setting.getNavLinkDecoration());
        settingMap.put("navLinkDecorationColor", setting.getNavLinkDecorationColor());
        settingMap.put("navLinkHoverColor", setting.getNavLinkHoverColor());
        settingMap.put("navLinkHoverDecoration", setting.getNavLinkHoverDecoration());
        settingMap.put("navLinkHoverDecorationColor", setting.getNavLinkHoverDecorationColor());
        settingMap.put("navLinkHighlightColor", setting.getNavLinkHighlightColor());
        settingMap.put("navLinkHighlightFontWeight", setting.getNavLinkHighlightFontWeight());
        settingMap.put("navLinkHighlightDecoration", setting.getNavLinkHighlightDecoration());
        settingMap.put("navLinkHighlightDecorationColor", setting.getNavLinkHighlightDecorationColor());
        settingMap.put("navSwitcherButtonColor", setting.getNavSwitcherButtonColor());
        settingMap.put("navSwitcherButtonHoverColor", setting.getNavSwitcherButtonHoverColor());
        settingMap.put("navExpandButtonColor", setting.getNavExpandButtonColor());
        settingMap.put("navExpandButtonHoverColor", setting.getNavExpandButtonHoverColor());
        settingMap.put("navTitleBorderRadius", navTitleBorderRadius);
        settingMap.put("navPaddingFix", navPaddingFix);
        HashMap<String, HashMap<String, Object>> context = new HashMap<String, HashMap<String, Object>>();
        context.put("setting", settingMap);
        return this.soyRenderer.render("com.shineatlas.confluence.headingpro.easy-heading-pro:soy-templates", String.format("com.shineatlas.confluence.headingpro.templates.%s", "navigationStyle"), context);
    }
}

