/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.service;

import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.shineatlas.confluence.headingpro.exception.EasyHeadingException;
import com.shineatlas.confluence.headingpro.service.ContentDeactivationService;
import com.shineatlas.confluence.headingpro.service.PageParameterService;
import com.shineatlas.confluence.headingpro.service.SpaceAdminService;
import com.shineatlas.confluence.headingpro.service.SystemAdminService;
import com.shineatlas.confluence.headingpro.service.UserSettingService;
import com.shineatlas.confluence.headingpro.viewmodel.ContentDeactivationViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.PageParameterViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSettingViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.SystemSettingViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.UserSettingViewModel;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class PageParameterServiceImpl
implements PageParameterService {
    private static final Logger log = LoggerFactory.getLogger(PageParameterServiceImpl.class);
    private final I18nResolver i18nResolver;
    private final PageManager pageManager;
    private final TemplateRenderer renderer;
    private final SpaceAdminService spaceAdminService;
    private final SystemAdminService systemAdminService;
    private final UserSettingService userSettingService;
    private final ContentDeactivationService contentDeactivationService;

    @Inject
    public PageParameterServiceImpl(@ComponentImport I18nResolver i18nResolver, @ComponentImport PageManager pageManager, @ComponentImport TemplateRenderer renderer, SpaceAdminService spaceAdminService, SystemAdminService systemAdminService, UserSettingService userSettingService, ContentDeactivationService contentDeactivationService) {
        this.i18nResolver = i18nResolver;
        this.pageManager = pageManager;
        this.renderer = renderer;
        this.spaceAdminService = spaceAdminService;
        this.systemAdminService = systemAdminService;
        this.userSettingService = userSettingService;
        this.contentDeactivationService = contentDeactivationService;
    }

    @Override
    public PageParameterViewModel getPageParameters(String userKey, long pageId, String contentType) throws EasyHeadingException {
        SpaceSettingViewModel spaceSetting;
        Page page = contentType.equals("page") ? this.pageManager.getPage(pageId) : null;
        BlogPost blogPost = contentType.equals("blogpost") ? this.pageManager.getBlogPost(pageId) : null;
        SystemSettingViewModel systemSetting = this.systemAdminService.getSystemSettingRenderPage();
        if (systemSetting.isUseGlobalSetting()) {
            spaceSetting = systemSetting.getGlobalSetting();
        } else {
            long spaceId = contentType.equals("page") ? page.getSpace().getId() : blogPost.getSpace().getId();
            spaceSetting = this.spaceAdminService.getSpaceSettingRenderPage(spaceId);
        }
        UserSettingViewModel userSetting = userKey.isEmpty() ? new UserSettingViewModel("", true) : this.userSettingService.getUserSetting(userKey);
        boolean deactivated = false;
        ContentDeactivationViewModel deactivation = this.contentDeactivationService.getContentDeactivation(pageId);
        if (deactivation != null) {
            deactivated = deactivation.isDeactivated();
        }
        return new PageParameterViewModel(page, blogPost, spaceSetting, userSetting, deactivated);
    }
}

