/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.service;

import com.atlassian.confluence.content.service.BlogPostService;
import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.content.service.SpaceService;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.shineatlas.confluence.headingpro.service.ConfluenceContentService;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ConfluenceContentServiceImpl
implements ConfluenceContentService {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceContentServiceImpl.class);
    private final PageService pageService;
    private final BlogPostService blogPostService;
    private final SpaceService spaceService;

    @Inject
    public ConfluenceContentServiceImpl(@ComponentImport PageService pageService, @ComponentImport BlogPostService blogPostService, @ComponentImport SpaceService spaceService) {
        this.pageService = pageService;
        this.blogPostService = blogPostService;
        this.spaceService = spaceService;
    }

    @Override
    public Space getSpace(String spaceKey) {
        return this.spaceService.getKeySpaceLocator(spaceKey).getSpace();
    }

    @Override
    public Page getPage(long pageId) {
        return this.pageService.getIdPageLocator(pageId).getPage();
    }

    @Override
    public BlogPost getBlogPost(long blogPostId) {
        return this.blogPostService.getIdBlogPostLocator(blogPostId).getBlogPost();
    }
}

