/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.helper;

import com.shineatlas.confluence.headingpro.helper.HeadingNumberUpdate;
import com.shineatlas.confluence.headingpro.helper.RomanNumber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HeadingNumberHelper {
    public static HeadingNumberUpdate addHeadingNumbers(String html, String selector, String numberType) {
        Boolean hasChanged = false;
        String[] arrSelector = selector.split(",");
        ArrayList<Object> parts = new ArrayList<Integer>();
        Document document = Jsoup.parse((String)html);
        Elements headers = document.select("h1,h2,h3,h4,h5,h6");
        for (Element header : headers) {
            String newText;
            if (header.text().trim().equals("")) continue;
            String tag = header.tagName().toLowerCase();
            int level = Arrays.asList(arrSelector).indexOf(tag) + 1;
            Object numberText = "";
            String oldText = header.text();
            if (level > 0) {
                if (parts.size() == level) {
                    parts.set(level - 1, (Integer)parts.get(level - 1) + 1);
                } else if (parts.size() > level) {
                    Integer[] arrOld = new Integer[level + 1];
                    Integer[] arrNew = Arrays.copyOfRange(parts.toArray(arrOld), 0, level);
                    parts = new ArrayList<Integer>(Arrays.asList(arrNew));
                    parts.set(level - 1, (Integer)parts.get(level - 1) + 1);
                } else if (parts.size() < level) {
                    for (int i = 0; i < level - parts.size(); ++i) {
                        parts.add(1);
                    }
                }
                List strParts = parts.stream().map(s -> {
                    if (numberType.equals("upper-case-roman-numbers")) {
                        return RomanNumber.toRoman(s, false);
                    }
                    if (numberType.equals("lower-case-roman-numbers")) {
                        return RomanNumber.toRoman(s, true);
                    }
                    return String.valueOf(s);
                }).collect(Collectors.toList());
                if (!numberType.equals("no-numbers")) {
                    numberText = String.join((CharSequence)".", strParts) + ". ";
                }
            }
            if (oldText.equals(newText = (String)numberText + HeadingNumberHelper.removePreviousNumber(header.text()))) continue;
            header.text(newText);
            if (hasChanged.booleanValue()) continue;
            hasChanged = true;
        }
        return new HeadingNumberUpdate(hasChanged, document.body().html());
    }

    private static String removePreviousNumber(String text) {
        String result1 = text.replaceAll("^(\\d{1,2}\\.)+\\s", "");
        String result2 = result1.replaceAll("^([LXVI]{1,8}\\.)+\\s", "");
        return result2.replaceAll("^([lxvi]{1,8}\\.)+\\s", "");
    }
}

