/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.shineatlas.confluence.headingpro.dao.UserSettingDAO;
import com.shineatlas.confluence.headingpro.domain.UserSettingObject;
import com.shineatlas.confluence.headingpro.viewmodel.UserSettingViewModel;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;

@Named
public class UserSettingDAOImpl
implements UserSettingDAO {
    private final ActiveObjects ao;

    @Inject
    public UserSettingDAOImpl(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public UserSettingObject find(String userKey) {
        UserSettingObject[] result = (UserSettingObject[])this.ao.find(UserSettingObject.class, Query.select().where("INDEXED_USER_KEY = ?", new Object[]{userKey}));
        return result.length > 0 ? result[0] : null;
    }

    @Override
    public UserSettingObject save(UserSettingViewModel setting) {
        UserSettingObject obj = this.find(setting.getUserKey());
        if (obj == null) {
            obj = (UserSettingObject)this.ao.create(UserSettingObject.class, new DBParam[]{new DBParam("INDEXED_USER_KEY", (Object)setting.getUserKey())});
        }
        obj.setEnabled(setting.isEnabled());
        obj.save();
        return obj;
    }
}

