/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.shineatlas.confluence.headingpro.dao.SpaceSettingDAO;
import com.shineatlas.confluence.headingpro.domain.SpaceSettingObject;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSettingViewModel;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

@Named
public class SpaceSettingDAOImpl
implements SpaceSettingDAO {
    private final ActiveObjects ao;

    @Inject
    public SpaceSettingDAOImpl(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public SpaceSettingObject find(long spaceId) {
        SpaceSettingObject[] result = (SpaceSettingObject[])this.ao.find(SpaceSettingObject.class, Query.select().where("INDEXED_SPACE_ID = ?", new Object[]{spaceId}));
        return result.length > 0 ? result[0] : null;
    }

    @Override
    public SpaceSettingObject save(SpaceSettingViewModel setting) {
        SpaceSettingObject obj = this.find(setting.getSpaceId());
        if (obj == null) {
            obj = (SpaceSettingObject)this.ao.create(SpaceSettingObject.class, new DBParam[]{new DBParam("INDEXED_SPACE_ID", (Object)setting.getSpaceId())});
        }
        obj.setEnabled(setting.isEnabled());
        obj.setEnabledForHome(setting.isEnabledForHome());
        obj.setSelector(setting.getSelector());
        obj.setHeadingIndent(setting.getHeadingIndent());
        obj.setNumberOption(setting.getNumberOption());
        obj.setExpandCollapseOption(setting.getExpandCollapseOption());
        obj.setTitleExpandClickable(setting.isTitleExpandClickable());
        obj.setUseNavigation(setting.isUseNavigation());
        obj.setNavigationMode(setting.getNavigationMode());
        obj.setWrapNavigationText(setting.isWrapNavigationText());
        obj.setNavigationTitle(setting.getNavigationTitle());
        obj.setNavigationTop(setting.getNavigationTop());
        obj.setNavigationWidth(setting.getNavigationWidth());
        obj.setNavigationIndent(setting.getNavigationIndent());
        obj.setDisableNavLinksUnder(setting.getDisableNavLinksUnder());
        obj.setExpandCollapseNavOption(setting.getExpandCollapseNavOption());
        obj.setLabelsAppDisabled(setting.getLabelsAppDisabled());
        obj.setMacrosAppDisabled(setting.getMacrosAppDisabled());
        obj.setMacrosTOCDisabled(setting.getMacrosTOCDisabled());
        obj.setNavigationEditMode(setting.getNavigationEditMode());
        obj.setNavBackgroundColor(setting.getNavBackgroundColor());
        obj.setNavOpacity(setting.getNavOpacity());
        obj.setNavBorderWidth(setting.getNavBorderWidth());
        obj.setNavBorderRadius(setting.getNavBorderRadius());
        obj.setNavBorderStyle(setting.getNavBorderStyle());
        obj.setNavBorderColor(setting.getNavBorderColor());
        obj.setNavPadding(setting.getNavPadding());
        obj.setNavTitleBackgroundColor(setting.getNavTitleBackgroundColor());
        obj.setNavTitleColor(setting.getNavTitleColor());
        obj.setNavTitleFontSize(setting.getNavTitleFontSize());
        obj.setNavTitleFontWeight(setting.getNavTitleFontWeight());
        obj.setNavLinkColor(setting.getNavLinkColor());
        obj.setNavLinkFontSize(setting.getNavLinkFontSize());
        obj.setNavLinkFontWeight(setting.getNavLinkFontWeight());
        obj.setNavLinkDecoration(setting.getNavLinkDecoration());
        obj.setNavLinkDecorationColor(setting.getNavLinkDecorationColor());
        obj.setNavLinkHoverColor(setting.getNavLinkHoverColor());
        obj.setNavLinkHoverDecoration(setting.getNavLinkHoverDecoration());
        obj.setNavLinkHoverDecorationColor(setting.getNavLinkHoverDecorationColor());
        obj.setNavLinkHighlightColor(setting.getNavLinkHighlightColor());
        obj.setNavLinkHighlightFontWeight(setting.getNavLinkHighlightFontWeight());
        obj.setNavLinkHighlightDecoration(setting.getNavLinkHighlightDecoration());
        obj.setNavLinkHighlightDecorationColor(setting.getNavLinkHighlightDecorationColor());
        obj.setNavExpandButtonColor(setting.getNavExpandButtonColor());
        obj.setNavExpandButtonHoverColor(setting.getNavExpandButtonHoverColor());
        obj.setNavSwitcherButtonColor(setting.getNavSwitcherButtonColor());
        obj.setNavSwitcherButtonHoverColor(setting.getNavSwitcherButtonHoverColor());
        obj.setUseCustomColors(setting.isUseCustomColors());
        obj.save();
        return obj;
    }

    @Override
    public void remove(SpaceSettingObject obj) {
        this.ao.delete(new RawEntity[]{obj});
    }
}

