
AJS.toInit(function ($) {
    var MAX_WIDTH_NAVIGATION = 600;
    var MIN_WIDTH_NAVIGATION = 40;
    var SCROLLING_OFFSET_FIX = 100;
    var SCROLLING_ANIMATION_DURATION = 800;
    var SCROLLING_EXPAND_WAIT_TIME = 500;
    var OFFSET_NAV_TO_TOP = 90;
    var OFFSET_NAV_TOP_FIX = 30;
    var OFFSET_NAV_TO_BOTTOM = 80;
    var OFFSET_NAV_TO_CONTENT = 10;
    var WIDTH_NAV_DRAG_BAR = 25;
    var OFFSET_CONTENT_MARGIN_RIGHT_FOR_HIDDEN_NAV = 36;
    var NAVIGATION_MODE_RIGHT = "right";
    var NAVIGATION_MODE_RIGHT_POPUP = "right-popup";
    var SELECTOR_MAIN = "#main";
    var SELECTOR_CONTENT = "#content";
    var SELECTOR_BODY = "#main-content";
    var SELECTOR_MACRO = ".easy-heading-pro";
    var SELECTOR_NAV_WRAPPER = "#ehp-navigation-wrapper";
    var SELECTOR_NAV_CONTENT = "#ehp-navigation-content";
    var SELECTOR_NAV_LIST = "#ehp-navigation-list";
    var COOKIE_NAV_MODE = "easy-heading-pro.nav-mode";
    var COOKIE_NAV_WIDTH = "easy-heading-pro.nav-width";
    var COOKIE_NAV_ENABLED_ANONYMOUS = "easy-heading-pro.nav-enabled";
    var COOKIE_EXPIRE_DAYS = 720;

    var paras;
    var selectorHeaders;
    var notSelectorMacros = ""; // not apply TOC to headings for macros

    var mouseXPosition;
    var mouseIsDown = false;
    var navigationCreated = false;
    var navigationWidth =  0;
    var useNavigationHiddenMode = false;
    var originalContentPaddingRight = 0;

    // For scrolling by Url
    var TIME_LAPSE_NO_CHANGE_MAX = 700;
    var TIME_LAPSE_USER_STOP_DUE = 2000;
    var intervalForScroll;
    var timeLapse = 0;
    var timeLapseNoChange = 0;
    var timeStep = 100;
    var prevScrollHeight = 0;

    AJS.populateParameters();
    if (typeof AJS.params.pageId === 'undefined' || typeof AJS.params.contentType === 'undefined' ) {
        return;
    }

    var isAnonymous = AJS.params.remoteUserKey == "";

    // To apply to headings inside other macros which load html by ajax
    if ($(SELECTOR_CONTENT).find(".converter-macro-ajax-container").length > 0) {
        setTimeout(getParameters, 1000);
    } else {
        getParameters();
    }

    function getParameters() {
        var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/page-parameter";
        var data = {
            pageId: AJS.params.pageId,
            pageContentType: AJS.params.contentType
        };

        $.ajax({
            url: url,
            type: "GET",
            data: data,
            success: function (data, textStatus, XMLHttpRequest) {
                paras = data;

                // Handle cookie values
                paras = loadUserCookieData(paras);
                //console.log(paras);

                init();
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function isMacroExistsOnPage() {
        return $(".easy-heading-free-end").length > 0;
    }

    function init() {
        if (paras.licenseError != null) {
            $("#page-menu-easy-heading-pro-link").hide();
            showMessage("error", paras.licenseError);
            return;
        }

        // Apply css style for navigation (will apply to free macro as well)
        $("head>#eh-style").remove();
        $("head").append('<style id="ehp-style" type="text/css">' + paras.navigationCssStyle + '</style>');

        // Handle page menu item status for current user
        setupNavigationViewMenu();

        if (!paras.enabled || !paras.enabledByUser) return;

        // Pro version will not work as long as the free version is used on current page or enabled for the current space
        if (isMacroExistsOnPage()) {
            //console.log("Warning: Easy heading free macro is detected, make sure remove it or update it to latest version. Pro version will have higher priority to be applied.");

            console.log("disabling pro version because free macro with higher PRI is detected");
            return;
        }

        selectorHeaders = paras.selector;

        // Do not apply this plugin to inside of the specified macros
        notSelectorMacros = getSelectorByMacroNames(paras.macrosTOCDisabled, selectorHeaders);

        // Update block to all headings
        $(SELECTOR_BODY).find(selectorHeaders).not(notSelectorMacros).each(function(){
            processHeadings($(this), paras);
        });
        if (paras.enableExpandCollapse) {
            bindHeadingExpandEvent();
        }

        // Only enable sidebar when it satisfy the parameter
        if ($(SELECTOR_BODY).find(".heading-expand-header").length < paras.disableNavLinksUnder) {
            return;
        }

        // It will only use the paras of the first macro block for navigation set up
        navigationCreated = createNavigation(paras);

        //console.log("navigationCreated = " + navigationCreated);
        if (navigationCreated) {
            bindDragEventForNavigation();
            bindWidthChangeForNavigation();
            bindLinkEventForNavigation();
            bindSwicherEventForNavigation();

            // Highlight current heading in navigation bar
            updateNavigationPosition();
            highlightCurrentHeading();
            $(document).scroll(function(){
                updateNavigationPosition();
                highlightCurrentHeading();
            });

            bindAnchorLinks();
        }

        // Navigate to section defined in url
        handleHeadingByUrl();
    }

    function handleHeadingByUrl() {
        var targetId = decodeURI(location.hash).replace("#", "");
        if (targetId == "") return;

        $(window).scrollTop();
        intervalForScroll = setInterval(function(){
            var scrollHeight = document.body.scrollHeight;
            if (prevScrollHeight != scrollHeight) {
                prevScrollHeight = scrollHeight;
                timeLapseNoChange = 0;
            }
            timeLapse = timeLapse + timeStep;
            timeLapseNoChange = timeLapseNoChange + timeStep;

            //console.log("scrollHeight=" + scrollHeight + ", timeLapseNoChange=" + timeLapseNoChange + ", timeLapse=" + timeLapse);
            if (timeLapseNoChange >= TIME_LAPSE_NO_CHANGE_MAX) {
                clearInterval(intervalForScroll);
                navigateToHeading(targetId);
            }

        }, timeStep);

        // Cancel scrolling if user starts scrolling with mousewheel (not able to detect dragging scrollbar by user)
        $("html, body").bind('mousewheel DOMMouseScroll onmousewheel touchmove', function(){
            if (timeLapse >= TIME_LAPSE_USER_STOP_DUE) {
                clearInterval(intervalForScroll);
            }
        });
    }

    function setupNavigationViewMenu() {
        if (!paras.enabled || isMacroExistsOnPage()) {
            $("#page-menu-easy-heading-pro-link").hide();
            return;
        }

        if (paras.enabledByUser) {
            $("#page-menu-easy-heading-pro-link").append('<i class="fas fa-check ehp-nav-view-enabled"></i>');
        } else {
            $("#page-menu-easy-heading-pro-link>i").remove();
        }
        $("#page-menu-easy-heading-pro-link").off("click").on("click", function(e) {
            e.preventDefault();
            toggleNavigationViewEnabled();
        });
    }

    function toggleNavigationViewEnabled() {
        var enabledByUser = $(".ehp-nav-view-enabled").length == 0;
        if (isAnonymous) {
            setCookie(COOKIE_NAV_ENABLED_ANONYMOUS, enabledByUser.toString().toLowerCase(), COOKIE_EXPIRE_DAYS);
            window.location.reload();
            return;
        }

        // Save navigation view status to database only for logged in user
        var url = AJS.contextPath() + "/plugins/servlet/easy-heading-pro/page-parameter";
        var data = {
            pageId: AJS.params.pageId,
            enabledByUser: enabledByUser
        };

        $.ajax({
            url: url,
            type: "POST",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            processData: false,
            success: function (data, textStatus, XMLHttpRequest) {
                window.location.reload();
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function loadUserCookieData(paras) {
        // Use enabled setting for anonymous from local cookie instead of server setting
        if (isAnonymous) {
            var navEnabledAnonymous = getCookie(COOKIE_NAV_ENABLED_ANONYMOUS);
            if (navEnabledAnonymous != null && navEnabledAnonymous != "") {
                paras.enabledByUser = navEnabledAnonymous == "true";
            }
        }

        var navMode = getCookie(COOKIE_NAV_MODE);
        var navWidth = Number(getCookie(COOKIE_NAV_WIDTH));
        if (navMode != null && navMode != "") {
            paras.navigationMode = navMode;
        }
        if (navWidth != null && navWidth != "") {
            paras.navigationWidth = navWidth;
        }

        return paras;
    }

    /* Process heading blocks on the page */
    // Attention, this is a recursive function
    function processHeadings(h, paras) {
        if (h == null || h.length == 0) return;
        // Don't process empty headings
        if (h.text().trim() == "") {
            processHeadings(h.next(selectorHeaders), paras);
            return;
        }
        // Don't process the same heading second time
        if (h.parent().hasClass("heading-expand-header")) return;

        var divHeader = updateHeading(h, paras);
        var divBody = divHeader.next("div.heading-expand-body");
        processHeadings(divBody.find(selectorHeaders).not(notSelectorMacros).eq(0), paras);
        var hNext = divBody.next(selectorHeaders).not(notSelectorMacros);
        processHeadings(hNext, paras);
    }

    function updateHeading(h, paras){
        // Create the body div and move all its sub H elements into it
        var level = parseInt(h[0].nodeName.substring(1), 10);
        var until = ".easy-heading-pro-end";
        for (i = level; i > 0; i--){
            if (until != "") until += ",";
            until += "h" + i;
        }

        var expandHeading = paras.expandAllByDefault || (paras.expandUntil > 0 && level <= paras.expandUntil);
        //console.log("level=" + level + ", paras.expandUntil=" + paras.expandUntil);

        var styleIndent = "padding-left: " + paras.headingIndent + "px;";
        var style = !expandHeading && paras.enableExpandCollapse ? styleIndent + "display:none;" : styleIndent + "display:block;";

        $("<div class='heading-expand-body' style='" + style + "'></div>").insertAfter(h);

        var arrConVersion = $('meta[name="ajs-version-number"]').attr('content').split(".");
        h.next("div").each(function(){
            // Avoid executing the script inside other macro blocks for Confluence version lower than 7
            if (Number(arrConVersion[0] <= 6)) {
                $(this).nextUntil(until).find('script').remove();
            }
            $(this).nextUntil(until).appendTo($(this));
        });

        // Move header elements into the header div along with the expanding/collapsing icon
        var encodedText = encodeHeadingText(h.text());
        var headerId = encodedText;
        var index = 1;
        while ($("#" + headerId).length > 0) {
            index = index + 1;
            headerId = encodedText + "-" + index;
        }

        var buttonClass = expandHeading ? "fa-caret-down" : "fa-caret-right";
        var buttonHtml = paras.enableExpandCollapse ? "<i class='fa fa-ms heading-arrow " + buttonClass + "'></i>" : "";
        var divHeader = $("<div id='"+ headerId +"' class='heading-expand-header' style='display:flex;'>" + buttonHtml + "</div>");
        divHeader.insertAfter(h);
        h.appendTo(divHeader);

        return divHeader;
    }

    function bindHeadingExpandEvent() {
        // Bind expand/collapse event
        var selElementsClicking = paras.titleExpandClickable ? "i:eq(0), " + selectorHeaders : "i:eq(0)";
        $(SELECTOR_BODY).find(".heading-expand-header").find(selElementsClicking).click(function(event){
            event.preventDefault();

            $(this).parent().find("i:eq(0)").toggleClass("fa-caret-down").toggleClass("fa-caret-right");
            var bodyDiv = $(this).parent().next("div.heading-expand-body");
            bodyDiv.css("display", bodyDiv.is(":visible") ? "none" : "block" );
        });

        // Bind hover event for expanding buttons
        $(SELECTOR_BODY + " .heading-expand-header").find(".heading-arrow-hover, .heading-arrow").hover(function() {
            $(this).toggleClass("heading-arrow-hover", true).toggleClass("heading-arrow", false);
        }, function() {
            $(this).toggleClass("heading-arrow-hover", false).toggleClass("heading-arrow", true);
        });
    }


    /* Create floating navigation bar */
    function createNavigation(paras) {
        if (!paras.useNavigation || navigationCreated) return false;
        if ($(SELECTOR_NAV_WRAPPER).length > 0) return false;
        if ($(SELECTOR_BODY).find(".heading-expand-header").length == 0) return false;

        // Copy all heading text and create a list
        var divNavigationWrapper =  $('<div id="ehp-navigation-wrapper"></div>');
        var divNavigation = $('<div id="ehp-navigation"></div>');
        var divNavContentWrapper = $('<div id="ehp-nav-content-wrapper"></div>');
        var divNavigationContent = $('<div id="ehp-navigation-content"></div>');
        var divDragBar = $('<div id="ehp-drag-bar"><i class="fas fa-grip-lines-vertical nav-drag-button"></i></div>');
        var divTitle = $('<div id="ehp-navigation-title">' + htmlEncode(paras.navigationTitle) + '</div>');
        var classNavList = paras.wrapNavigationText ? "nav-list-wrap" : "nav-list-nowrap";
        var divList = $('<ul id="ehp-navigation-list" class="' + classNavList + '"></ul>');
        var divNavigationBottom = $('<div id="ehp-navigation-bottom"></div>');

        // Save right padding of content
        originalContentPaddingRight = Number($(SELECTOR_CONTENT).css("padding-right").replace("px", ""));

        // Set width of navigation
        navigationWidth = paras.navigationWidth;
        divNavigationWrapper.width(navigationWidth);
        divNavigation.width(navigationWidth);

        // Give navigation one column to display
        var switcherIconClass = "fa-list-alt";
        var switcherStyle = "";
        useNavigationHiddenMode = paras.navigationMode == NAVIGATION_MODE_RIGHT_POPUP;
        if (useNavigationHiddenMode) {

        } else {
            switcherIconClass = "fa-columns";
            switcherStyle = ' style="display:none"';
            $(SELECTOR_CONTENT).css("padding-right", (OFFSET_NAV_TO_CONTENT + WIDTH_NAV_DRAG_BAR + navigationWidth) + "px");
        }
        var divNavSwicher = $('<i id="ehp-navigation-switcher" class="fas fa-lg nav-switcher ' + switcherIconClass + '"' + switcherStyle + '></i>"');
        divNavSwicher.toggle(useNavigationHiddenMode);
        divNavigationContent.toggle(!useNavigationHiddenMode);
        divNavigationContent.toggleClass("ehp-navigation-shadow", useNavigationHiddenMode);

        // Add navigation content elements
        divNavigationContent.append(divDragBar).append(divTitle).append(divList).append(divNavigationBottom);
        divNavContentWrapper.append(divNavigationContent).append(divNavSwicher).appendTo(divNavigation);
        divNavigationWrapper.append(divNavigation).appendTo($(SELECTOR_CONTENT));

        // Initialize the y position for the wrapper
        var stickyStartY = $(SELECTOR_CONTENT).offset().top - $(SELECTOR_NAV_WRAPPER).offsetParent().offset().top;
        $(SELECTOR_NAV_WRAPPER).css("top", stickyStartY + "px");

        createNavigationLinks(paras);
        createHeadingExpandButtons(paras);

        return true;
    }

    function createNavigationLinks(paras) {
        var linksContainer = $(SELECTOR_NAV_LIST);
        var headings = $(SELECTOR_BODY).find(paras.selector).not(notSelectorMacros).filter(function(){
            return $(this).text().trim() != "";
        });

        //console.log("createNavigationLinks - headings.length=" + headings.length);

        var indent = paras.navigationIndent;

        var layers = [];
        var preLevel = 0;
        var numbers = [];
        var preNumber = 1;
        for (var i=0; i<headings.length; i++) {
            var level = parseInt(headings.eq(i)[0].nodeName.substring(1), 10);
            var preLevel = 0;
            var preNumber = 1;
            if (layers.length > 0) {
                preLevel = layers[layers.length-1];
                preNumber = numbers[numbers.length-1];
            }

            //console.log("i = " + i + ", level = " + level + ", preLevel = " + preLevel + ", preNumber = " + preNumber + ", text = " + headings.eq(i).text());

            if (level == preLevel) {
                numbers[numbers.length-1] = numbers[numbers.length-1] + 1;
            } else if (level > preLevel) {
                layers.push(level);
                numbers.push(1);
            } else if (level < preLevel) {
                // reduce indent
                while (level < preLevel && layers.length > 0) {
                    layers.pop();

                    if (layers.length == 0) {
                        preLevel = 0;
                    } else {
                        preLevel = layers[layers.length-1];
                    }

                    if (level > preLevel) {
                        layers.push(level);
                    } else {
                        numbers.pop();
                    }
                }

                numbers[numbers.length-1] = numbers[numbers.length-1] + 1;
            }

            //console.log("layers and numbers:");
            //console.log(layers);
            //console.log(numbers);

            var linkId = "number" + numbers.join("-") + "-";
            var padding = indent * (layers.length-1);
            var linkText = htmlEncode(filterHeadingText(headings.eq(i)));
            var encodedText = encodeHeadingText(filterHeadingText(headings.eq(i)));
            var linkAnchor = encodedText;
            var index = 1;
            while ($("a[href='#" + linkAnchor + "']").length > 0) {
                index = index + 1;
                linkAnchor = encodedText + "-" + index;
            }

            var textWrapClass = paras.wrapNavigationText ? "nav-header-wrap" : "nav-header-nowrap";
            var link = $("<li id='" + linkId + "' class='" + textWrapClass + "' style='padding-left: "
                + padding + "px;'><a href='#" + linkAnchor + "'>" + linkText
                + "</a><input type='hidden' value='" + level + "'></li>");

            // Update the link or create a new link
            link.appendTo(linksContainer);
        }
    }

    function createHeadingExpandButtons(paras) {
        $(SELECTOR_NAV_LIST + ">li").each(function(index){
            // Check if the current link (li) has sub links
            var isParentNode = false;
            var nextLink = $(this).next();
            if (nextLink.length > 0) {
                //todo: replace this way because we should not use padding value which can be 0 from settings
                isParentNode = Number($(nextLink).css("padding-left").replace("px","")) > Number($(this).css("padding-left").replace("px",""));
            }

            // Set status for the expand/collapse buttons
            var level = Number($(this).find("input:hidden").val());
            var expandNavHeading = paras.expandNavAllByDefault || (paras.expandNavUntil > 0 && level <= paras.expandNavUntil);
            var buttonClass = expandNavHeading ? "fa-chevron-down" : "fa-chevron-right";
            var button;
            if (paras.enableNavExpandCollapse) {
                button = isParentNode ? $("<i class='fas fa-xs nav-arrow " + buttonClass + "'></i>") : $("<span class='nav-empty'></span>");
                $(this).find("i").remove();
                button.prependTo($(this));

                // Set visible for current link based on previous link
                var parentLinkId = $(this).attr("id").replace(/\d{1,3}-$/g, "");
                var parentLink = $("li#" + parentLinkId);
                if (parentLink.length > 0) {
                    var linkVisible = parentLink.find(".nav-arrow, .nav-arrow-hover").hasClass("fa-chevron-down");
                    $(this).toggle(linkVisible);
                }
            }
        });

        $(SELECTOR_NAV_LIST).find(".nav-arrow, .nav-arrow-hover").off("click").on("click", function(){
            event.preventDefault();

            // Expand/Collapse sub headings
            $(this).toggleClass("fa-chevron-right").toggleClass("fa-chevron-down");

            // Show/Hide sub headings
            var number = $(this).parent().attr("id").replace("number","");
            $(SELECTOR_NAV_LIST + " [id^='number" + number + "']:not(#number" + number + ")").each(function(){
                var num = $(this).attr("id").replace("number","");
                var visible = true;

                while(num.match(/\d{1,3}-$/g) != null && num.match(/\d{1,3}-$/g).length > 0) {
                    num = num.replace(/\d{1,3}-$/g, "");
                    var parentNode = $("#number" + num);
                    if (parentNode.length == 0) break;

                    visible = parentNode.find(".nav-arrow, .nav-arrow-hover").hasClass("fa-chevron-down");
                    if (!visible) break;
                }
                $(this).toggle(visible);
            });

            updateLinkWidthForWrap();
        });
    }

    function bindSwicherEventForNavigation() {
        $("#ehp-navigation-switcher").click(function(event) {
            event.preventDefault();

            useNavigationHiddenMode = !useNavigationHiddenMode;
            $(this).toggleClass("fa-list-alt").toggleClass("fa-columns");

            // Save the mode to cookie so that it remembers this for user
            var cookieNavigationMode = useNavigationHiddenMode ? NAVIGATION_MODE_RIGHT_POPUP : NAVIGATION_MODE_RIGHT ;
            setCookie(COOKIE_NAV_MODE, cookieNavigationMode, COOKIE_EXPIRE_DAYS);

            if (useNavigationHiddenMode) {
                $(SELECTOR_NAV_CONTENT).addClass("ehp-navigation-shadow");
                $(SELECTOR_CONTENT).css("padding-right", (OFFSET_CONTENT_MARGIN_RIGHT_FOR_HIDDEN_NAV) + "px");

            } else {
                $(SELECTOR_NAV_CONTENT).removeClass("ehp-navigation-shadow");
                $(SELECTOR_CONTENT).css("padding-right", (OFFSET_NAV_TO_CONTENT + WIDTH_NAV_DRAG_BAR + navigationWidth) + "px");
            }
            resizeNavigation(0);
        });

        // Hover on the switcher button
        $("#ehp-navigation-switcher").hover(function(event) {
            $(this).toggleClass("nav-switcher-hover", true).toggleClass("nav-switcher", false);
        }, function(event) {
            $(this).toggleClass("nav-switcher", true).toggleClass("nav-switcher-hover", false);
        });

        // Hover in and out the navigation
        $(SELECTOR_NAV_WRAPPER).hover(function(event) {
            if (useNavigationHiddenMode) {
                $(SELECTOR_NAV_CONTENT).show();
            } else {
				$("#ehp-navigation-switcher").show();
			}
			updateLinkWidthForWrap();
        }, function(event) {
            if (useNavigationHiddenMode) {
                $(SELECTOR_NAV_CONTENT).hide();
            } else {
				$("#ehp-navigation-switcher").hide();
			}
        });
    }

    function bindLinkEventForNavigation() {
        $(SELECTOR_NAV_LIST).find(".nav-arrow-hover, .nav-arrow").hover(function() {
            $(this).toggleClass("nav-arrow-hover", true).toggleClass("nav-arrow", false);
        }, function() {
            $(this).toggleClass("nav-arrow-hover", false).toggleClass("nav-arrow", true);
        });
    }

    function bindDragEventForNavigation() {
        // Dragging to resize
        var dragBar = $("#ehp-drag-bar")[0];
        dragBar.addEventListener('mousedown', function(event) {
            event.preventDefault();
            mouseIsDown = true;
            mouseXPosition = event.clientX;
        }, true);

        document.addEventListener('mouseup', function() {
            mouseIsDown = false;
        }, true);

        document.addEventListener('mousemove', function(event) {
            if ($("#ehp-navigation").length == 0) return;

            navigationWidth = $(SELECTOR_NAV_WRAPPER).width();
            var xOffset = event.clientX - mouseXPosition;
            var canDragRight = xOffset > 0 && navigationWidth > MIN_WIDTH_NAVIGATION;
            var canDragLeft = xOffset < 0 && navigationWidth < MAX_WIDTH_NAVIGATION;
            if (mouseIsDown && (canDragRight || canDragLeft)) {
                mouseXPosition = event.clientX;
                resizeNavigation(xOffset);
            }

            // Save the mode to cookie so that it remembers this for user
            setCookie(COOKIE_NAV_WIDTH, "" + navigationWidth, COOKIE_EXPIRE_DAYS);
        }, true);
    }

    function bindWidthChangeForNavigation() {
        var elementBody = document.getElementById('main-content');
        new ResizeSensor(elementBody, function() {
            if ($(SELECTOR_NAV_WRAPPER).length == 0) return;

            if (!useNavigationHiddenMode) {
                var commentWidth = $(".ic-display-comment-view").width();
                navigationWidth = Math.max(commentWidth, $(SELECTOR_NAV_WRAPPER).width());
                $(SELECTOR_NAV_WRAPPER).width(navigationWidth);
                $("#ehp-navigation").width(navigationWidth);
                $(SELECTOR_CONTENT).css("padding-right", (OFFSET_NAV_TO_CONTENT + WIDTH_NAV_DRAG_BAR + navigationWidth) + "px");
            } else {
                var commentWidth = Math.max(0, $(".ic-display-comment-view").width());
                if (commentWidth > 0) {
                    $(SELECTOR_CONTENT).css("padding-right", commentWidth + "px");
                } else {
                    $(SELECTOR_CONTENT).css("padding-right", (OFFSET_CONTENT_MARGIN_RIGHT_FOR_HIDDEN_NAV) + "px");
                }
            }

    		updateNavigationPosition();
    		// Fix issue: when switch off the inline comment, drag left side bar will lead layout issue for navigation
    		$(SELECTOR_BODY).css("position", "relative");
        });
    }

    function bindAnchorLinks() {
        $(SELECTOR_CONTENT + ' a[href^="#heading-"]').click(function(event){
            event.preventDefault();

            // Add hash to the link without jump there directly
            var hash = $(this).attr("href");
            if(history.pushState) {
                history.pushState(null, null, hash);
            }
            else {
                location.hash = hash;
            }

            // Expand the target heading and scroll to the target heading only once it's completely expanded
            var targetId = hash.replace("#", "");
            navigateToHeading(targetId);

            return false;
        });
    }

    function navigateToHeading(targetId) {
        var expanded = isHeadingExpanded(targetId);
        if (expanded) {
            scrollToHeading(targetId);
        } else {
            expandHeading(targetId);
            setTimeout(function(){
                scrollToHeading(targetId);
            }, SCROLLING_EXPAND_WAIT_TIME);
        }

        var headingHeader = getHeadingHeader(targetId);
        expandNavHeading(headingHeader.attr("id"));
    }

    function fixNavigationFloating() {
        var contentTop = $(SELECTOR_CONTENT).offset().top;
        var offsetParent = $(SELECTOR_NAV_WRAPPER).offsetParent();
        $(SELECTOR_NAV_WRAPPER).css("top", (contentTop - offsetParent.offset().top) + "px");
    }

    function updateNavigationPosition() {
        // Update left of the navigation
        var offsetParent = $(SELECTOR_NAV_WRAPPER).offsetParent();
        var offsetParentElement = offsetParent[0];
        var contentLeft = document.getElementById("content").getBoundingClientRect().left;
        var offsetParentLeft = offsetParentElement.getBoundingClientRect().left;

        if (useNavigationHiddenMode) {
            var navLeft = contentLeft - offsetParentLeft  + $(SELECTOR_CONTENT).width() - $(SELECTOR_NAV_WRAPPER).width() + OFFSET_CONTENT_MARGIN_RIGHT_FOR_HIDDEN_NAV;
            //console.log(contentLeft, offsetParentLeft, $(SELECTOR_CONTENT).width());
            $(SELECTOR_NAV_WRAPPER).css("left", navLeft + "px");
        } else {
            var navLeft = contentLeft - offsetParentLeft  + $(SELECTOR_CONTENT).width() + WIDTH_NAV_DRAG_BAR + OFFSET_NAV_TO_CONTENT;
            //console.log(contentLeft, offsetParentLeft, $(SELECTOR_CONTENT).width());
            $(SELECTOR_NAV_WRAPPER).css("left", navLeft + "px");
        }

        // Make the navigation floating
        var stickyTop = paras.navigationTop <= 0 ? OFFSET_NAV_TO_TOP : paras.navigationTop;
        var stickyStartY = $(SELECTOR_CONTENT).offset().top - $(SELECTOR_NAV_WRAPPER).offsetParent().offset().top;
        var contentBottom = $(SELECTOR_CONTENT).offset().top + $(SELECTOR_CONTENT).height();
        var navHeight = $("#ehp-navigation").height();
        var contentHeight = $(SELECTOR_CONTENT).height();
        if (navHeight > contentHeight) {
            navHeight = contentHeight;
        }
        var stickyStopY = contentBottom - navHeight - OFFSET_NAV_TO_BOTTOM;

        //console.log(window.pageYOffset, stickyStartY, stickyStopY, -1, $(SELECTOR_CONTENT).offset().top, $(SELECTOR_CONTENT).height(), -1, $("#ehp-navigation").height(), stickyStartY , OFFSET_NAV_TO_BOTTOM);
        if (window.pageYOffset >= stickyStopY) {
            $(SELECTOR_NAV_WRAPPER).css("top",  stickyStopY + "px");
            $("#ehp-navigation").toggleClass("nav-sticky", false).css("top",  "0px");
        } else if (window.pageYOffset >= stickyStartY) {
            $(SELECTOR_NAV_WRAPPER).css("top", stickyStartY + "px");
            $("#ehp-navigation").toggleClass("nav-sticky", true).css("top", stickyTop + "px");
        } else {
            $(SELECTOR_NAV_WRAPPER).css("top", (stickyStartY + OFFSET_NAV_TOP_FIX ) + "px");
            $("#ehp-navigation").toggleClass("nav-sticky", false).css("top",  "0px");
        }

        updateLinkWidthForWrap();
    }

    function resizeNavigation(xOffset) {
        if (!useNavigationHiddenMode) {
            var contentMarginRight = Number($(SELECTOR_CONTENT).css("padding-right").replace("px", ""));
            $(SELECTOR_CONTENT).css("padding-right",  (contentMarginRight - xOffset) +  "px");
        }

        $(SELECTOR_NAV_WRAPPER).width($(SELECTOR_NAV_WRAPPER).width() - xOffset);
        $("#ehp-navigation").width($(SELECTOR_NAV_WRAPPER).width());

        updateNavigationPosition();
    }

    function highlightCurrentHeading() {
        var headers = $(SELECTOR_BODY).find(".heading-expand-header");
        var viewPosition = $(document).scrollTop() + SCROLLING_OFFSET_FIX;
        var index = 0;
        var contentBottom = $(SELECTOR_CONTENT).offset().top + $(SELECTOR_CONTENT).height();
        for (i = 0; i<headers.length; i++) {
            var prev = headers.eq(i).offset().top;
            var next = i < headers.length-1 ? headers.eq(i+1).offset().top : contentBottom + 99999;
            //console.log("prev=" + prev + ", next=" + next);
            if (viewPosition >= prev && viewPosition < next) {
                index = i;
                break;
            }
        }

        // highlight the current heading
        var targetLink = $(SELECTOR_NAV_LIST).find("a:eq(" + index + ")");
        if (!targetLink.hasClass("ehp-highlight")) {
            $(".ehp-highlight").removeClass("ehp-highlight");
            targetLink.addClass("ehp-highlight");
        }
    }

    function getHeadingHeader(targetId) {
        var target = $(SELECTOR_BODY + " #" + targetId);
        var isHeader = target.hasClass("heading-expand-header");
        if (isHeader) {
            return target;
        } else {
            return target.closest(".heading-expand-body").prev(".heading-expand-header");
        }
    }

    function getHeadingBody(targetId) {
        var target = $(SELECTOR_BODY + " #" + targetId);
        var isHeader = target.hasClass("heading-expand-header");
        if (isHeader) {
            return target.next(".heading-expand-body");
        } else {
            return target.closest(".heading-expand-body");
        }
    }

    function isHeadingExpanded(targetId) {
        var headingBody = getHeadingBody(targetId);
        return headingBody.is(":hidden") == false && headingBody.parents(".heading-expand-body:hidden").length == 0;
    }


    function expandHeading(targetId) {
        getHeadingBody(targetId)
            .parents(".heading-expand-body:hidden")
            .andSelf()
            .each(function(){
                $(this).show();
                $(this).prev()
                    .find("i.heading-arrow")
                    .toggleClass("fa-caret-right", false)
                    .toggleClass("fa-caret-down", true);
            });
    }

    function isScrolledToHeading(targetId) {
        var viewPosition = $(document).scrollTop() + SCROLLING_OFFSET_FIX;
        var targetPosition = $(SELECTOR_BODY + " #" + targetId).offset().top;
        //console.log("viewPosition=" + viewPosition, " targetPosition=" + targetPosition);
        return viewPosition > targetPosition;
    }

    function isScrolledToBottom() {
        //console.log("a=" + (window.innerHeight + window.scrollY) + " b=" + document.body.scrollHeight);
        return ((window.innerHeight + window.scrollY) >= document.body.scrollHeight);
    }

    function scrollToHeading(targetId) {
        var target = $(SELECTOR_BODY + " #" + targetId);
        $('html, body').stop().animate({ scrollTop: target.offset().top - SCROLLING_OFFSET_FIX + 1 }, SCROLLING_ANIMATION_DURATION);
    }

    function expandNavHeading(headerId) {
        $(SELECTOR_NAV_LIST + " a[href='#" + headerId + "']")
            .parents(".nav-expand-body:hidden")
            .each(function(){
                $(this).show();
                $(this).prev()
                    .find("i.nav-arrow")
                    .toggleClass("fa-chevron-right", false)
                    .toggleClass("fa-chevron-down", true);
            });

    }

    function updateLinkWidthForWrap() {
        $(SELECTOR_NAV_LIST + " a").each(function(){
            var header = $(this).parent();
            var icon = header.find("span,i");
            if (icon.length == 1) {
                $(this).width(header.width() - icon.width());
            }
        });
    }

    function filterHeadingText(heading) {
        return heading.contents().not("i, img, input, select").text().trim();
    }

    // Encode to resolve XSS vulnerability
    function htmlEncode(str){
      return String(str).replace(/[^\w. ]/gi, function(c){
         return '&#'+c.charCodeAt(0)+';';
      });
    }

    // Encode text to generate id of heading
    function encodeHeadingText(text) {
        var result = text.replace(/[&\/\\\s\|\[\],;+()$~%.:*?<>{}#@!="'`^]/g, '');
        result = "heading-" + result.substring(0, 100);
        return result;
    }

    // Encode selector, should not encode comma
    function encodeSelector(name) {
        return name.replace(/[&\/\\\s\|\[\];+()$~%.:*?<>{}#@!="'`^]/g, '');
    }

    function getSelectorByMacroNames(macroNames, headingSelectors) {
        var names = encodeSelector(macroNames);
        var headingSelectors = encodeSelector(headingSelectors);
        if (names == "") return "";

        var selector = "";
        var arryNames = names.split(",");
        var arryHeadingSelectors = headingSelectors.split(",");
        for (var i=0; i<arryNames.length; i++) {
            for (var j=0; j<arryHeadingSelectors.length; j++) {
                if (selector != "") selector = selector + ",";
                selector = selector + ".conf-macro[data-macro-name='"+ arryNames[i] +"'] " + arryHeadingSelectors[j];
            }
        }
        return selector;
    }

    function setCookie(cname, cvalue, exdays) {
      var d = new Date();
      d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
      var expires = "expires="+d.toUTCString();
      document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
    }

    function getCookie(cname) {
      var name = cname + "=";
      var ca = document.cookie.split(';');
      for(var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') {
          c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
          return c.substring(name.length, c.length);
        }
      }
      return "";
    }

    // Common
    function showMessage(type, message) {
        AJS.flag({
            type: type,
            body: message,
            close: "auto"
        });
    }
});