/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.servlet;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSettingViewModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(StyleServlet.class);
    private final I18nResolver i18nResolver;

    @Inject
    public StyleServlet(@ComponentImport I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser == null || currentUser.getKey().getStringValue().isEmpty()) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-not-authenticated"));
            response.getWriter().flush();
        }
        SpaceSettingViewModel setting = null;
        StringBuffer jb = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
        }
        catch (Exception e) {
            log.error("Error reading value from request with BufferedReader", (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jb.toString());
            setting = new SpaceSettingViewModel(-1L, false, false, jsonObject.getString("selector"), jsonObject.getInt("headingIndent"), jsonObject.getString("numberOption"), jsonObject.getString("expandCollapseOption"), jsonObject.getBoolean("titleExpandClickable"), jsonObject.getBoolean("useNavigation"), jsonObject.getString("navigationMode"), jsonObject.getBoolean("wrapNavigationText"), jsonObject.getString("navigationTitle"), jsonObject.getInt("navigationTop"), jsonObject.getInt("navigationWidth"), jsonObject.getInt("navigationIndent"), jsonObject.getInt("disableNavLinksUnder"), jsonObject.getString("expandCollapseNavOption"), jsonObject.getString("macrosTOCDisabled"), jsonObject.getString("navigationEditMode"), jsonObject.getString("navBackgroundColor"), jsonObject.getDouble("navOpacity"), jsonObject.getInt("navBorderWidth"), jsonObject.getInt("navBorderRadius"), jsonObject.getString("navBorderStyle"), jsonObject.getString("navBorderColor"), jsonObject.getInt("navPadding"), jsonObject.getString("navTitleBackgroundColor"), jsonObject.getString("navTitleColor"), jsonObject.getInt("navTitleFontSize"), jsonObject.getString("navTitleFontWeight"), jsonObject.getString("navLinkColor"), jsonObject.getInt("navLinkFontSize"), jsonObject.getString("navLinkFontWeight"), jsonObject.getString("navLinkDecoration"), jsonObject.getString("navLinkDecorationColor"), jsonObject.getString("navLinkHoverColor"), jsonObject.getString("navLinkHoverDecoration"), jsonObject.getString("navLinkHoverDecorationColor"), jsonObject.getString("navLinkHighlightColor"), jsonObject.getString("navLinkHighlightFontWeight"), jsonObject.getString("navLinkHighlightDecoration"), jsonObject.getString("navLinkHighlightDecorationColor"), jsonObject.getString("navExpandButtonColor"), jsonObject.getString("navExpandButtonHoverColor"), jsonObject.getString("navSwitcherButtonColor"), jsonObject.getString("navSwitcherButtonHoverColor"));
        }
        catch (JSONException e) {
            log.error("Error extracting json object from StringBuffer", (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("setting", setting);
        String navigationCssStyle = VelocityUtils.getRenderedTemplate((String)"templates/navigation-style.vm", (Map)context);
        setting.setNavigationCssStyle(navigationCssStyle);
        response.setStatus(200);
        JSONObject jsonObject = new JSONObject((Object)setting);
        response.setContentType("application/json");
        response.getWriter().write(jsonObject.toString());
        response.getWriter().close();
    }
}

