/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.servlet;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.shineatlas.confluence.headingpro.service.ContentDeactivationService;
import com.shineatlas.confluence.headingpro.viewmodel.ContentDeactivationViewModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentDeactivationServlet
extends HttpServlet {
    private final String TEMPLATE_DEACTIVATION_SEARCH = "templates/deactivation-search.vm";
    private final String TEMPLATE_DEACTIVATION_LOAD_ALL = "templates/deactivation-load-all.vm";
    private static final Logger log = LoggerFactory.getLogger(ContentDeactivationServlet.class);
    private final I18nResolver i18nResolver;
    private final TemplateRenderer renderer;
    private final ContentDeactivationService contentDeactivationService;

    @Inject
    public ContentDeactivationServlet(@ComponentImport I18nResolver i18nResolver, TemplateRenderer renderer, ContentDeactivationService contentDeactivationService) {
        this.i18nResolver = i18nResolver;
        this.renderer = renderer;
        this.contentDeactivationService = contentDeactivationService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String action = request.getParameter("action");
        String searchTitle = Optional.ofNullable(request.getParameter("title")).orElse("").trim();
        String spaceKey = Optional.ofNullable(request.getParameter("spaceKey")).orElse("").trim();
        String strContentId = Optional.ofNullable(request.getParameter("contentId")).orElse("-1");
        long contentId = Long.parseLong(strContentId);
        if (action.equals("get") && contentId == -1L) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        try {
            List<Object> result = new ArrayList();
            if (action.equals("search") && !searchTitle.isEmpty()) {
                result = this.contentDeactivationService.searchContentForDeactivation(searchTitle);
                Map context = MacroUtils.defaultVelocityContext();
                context.put("models", result);
                String html = VelocityUtils.getRenderedTemplate((String)"templates/deactivation-search.vm", (Map)context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(html);
            } else if (action.equals("get")) {
                ContentDeactivationViewModel model = this.contentDeactivationService.getContentDeactivation(contentId);
                if (model != null) {
                    result.add(model);
                }
                JSONObject jsonObject = new JSONObject(result);
                response.setContentType("application/json");
                response.getWriter().write(jsonObject.toString());
            } else if (action.equals("getAll")) {
                result = this.contentDeactivationService.getAllContentDeactivations(spaceKey);
                Map context = MacroUtils.defaultVelocityContext();
                context.put("models", result);
                String html = VelocityUtils.getRenderedTemplate((String)"templates/deactivation-load-all.vm", (Map)context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(html);
            }
            response.setStatus(200);
            response.getWriter().close();
        }
        catch (Exception e) {
            log.error(String.format("Error getting deactivated contents with action: %s, title: %s, contentId: %s", action, searchTitle, contentId), (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser == null || currentUser.getKey().getStringValue().isEmpty()) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.error-message-not-authenticated"));
            response.getWriter().flush();
            return;
        }
        StringBuffer jb = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
        }
        catch (Exception e) {
            log.error("Error reading value from request with BufferedReader", (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        long contentId = -1L;
        boolean beingDeactivated = false;
        try {
            JSONObject jsonObject = new JSONObject(jb.toString());
            contentId = jsonObject.getLong("contentId");
            beingDeactivated = jsonObject.getBoolean("beingDeactivated");
        }
        catch (JSONException e) {
            log.error("Error extracting json object from StringBuffer", (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        if (contentId == -1L) {
            log.error(String.format("Error getting contentId, the contentId is invalid", new Object[0]));
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        try {
            ContentDeactivationViewModel result = this.contentDeactivationService.deactivateContent(contentId, beingDeactivated);
            if (result == null) {
                log.error(String.format("Error calling contentDeactivationService.deactivateContent, the contentId is invalid", new Object[0]));
                response.setStatus(400);
                response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
                response.getWriter().flush();
                return;
            }
            JSONObject jsonObject = new JSONObject((Object)result);
            response.setStatus(200);
            response.setContentType("application/json");
            response.getWriter().write(jsonObject.toString());
            response.getWriter().close();
        }
        catch (Exception e) {
            log.error(String.format("Error calling contentDeactivationService.deactivateContent with user key: %s, contentId: %s, beingDeactivated: %s", currentUser.getKey().getStringValue(), contentId, beingDeactivated), (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.error-message-request-handle-failed"));
            response.getWriter().flush();
        }
    }
}

